/*
 * Decompiled with CFR 0.152.
 */
package xiamomc.pluginbase;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Exceptions.NullDependencyException;
import xiamomc.pluginbase.Managers.DependencyManager;
import xiamomc.pluginbase.ScheduleInfo;
import xiamomc.pluginbase.XiaMoJavaPlugin;

public abstract class PluginObject<P extends XiaMoJavaPlugin> {
    protected final XiaMoJavaPlugin plugin = XiaMoJavaPlugin.getInstance(this.getPluginNamespace());
    protected final DependencyManager dependencies = DependencyManager.getInstance(this.getPluginNamespace());
    protected final Logger logger = this.plugin.getSLF4JLogger();
    @Deprecated
    protected final DependencyManager Dependencies = this.dependencies;
    @Deprecated
    protected final XiaMoJavaPlugin Plugin = this.plugin;
    @Deprecated
    protected final Logger Logger = this.logger;
    private List<Field> fieldsToResolve = new ObjectArrayList();
    private final List<Method> initializerMethods = new ObjectArrayList();

    protected abstract String getPluginNamespace();

    protected PluginObject() {
        this.initialDependencyResolve();
    }

    private void addInitializerMethods(Class<?> clazz) {
        List<Method> methods = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Initializer.class)).toList();
        if (methods.size() > 1) {
            throw new RuntimeException(String.valueOf(clazz) + "\u4e2d\u4e0d\u80fd\u62e5\u6709\u591a\u4e2a\u521d\u59cb\u5316\u65b9\u6cd5");
        }
        methods.stream().findFirst().ifPresent(this.initializerMethods::add);
    }

    private void resolveFields(Class<?> clazz) {
        ArrayList<Field> ftr = new ArrayList<Field>(Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Resolved.class)).toList());
        List<Field> fieldToResolveNow = ftr.stream().filter(f -> f.getAnnotation(Resolved.class).shouldSolveImmediately()).toList();
        for (Field f2 : fieldToResolveNow) {
            this.resolveField(f2);
            ftr.remove(f2);
        }
        this.fieldsToResolve.addAll(ftr);
    }

    private void initialDependencyResolve() {
        try {
            List superclasses = ClassUtils.getAllSuperclasses(this.getClass());
            Collections.reverse(superclasses);
            for (Class c : superclasses) {
                this.addInitializerMethods(c);
            }
            this.addInitializerMethods(this.getClass());
            for (Class c : superclasses) {
                this.resolveFields(c);
            }
            this.resolveFields(this.getClass());
            this.addSchedule(this::resolveRemainingDependencies);
        }
        catch (Throwable t) {
            this.logger.error("\u521d\u59cb\u5316" + String.valueOf(this) + "\u5931\u8d25: " + t.getMessage());
            t.printStackTrace();
            this.fieldsToResolve.clear();
            this.initializerMethods.clear();
        }
    }

    private void resolveRemainingDependencies() {
        for (Field field : this.fieldsToResolve) {
            this.resolveField(field);
        }
        this.fieldsToResolve.clear();
        this.fieldsToResolve = null;
        for (Method initializerMethod : this.initializerMethods) {
            if (Modifier.isPrivate(initializerMethod.getModifiers())) {
                Parameter[] parameters = initializerMethod.getParameters();
                ObjectArrayList values = new ObjectArrayList();
                for (Parameter p : parameters) {
                    Class<?> targetClassType = p.getType();
                    Object value = this.dependencies.get(targetClassType, false);
                    if (value == null) {
                        this.throwDependencyNotFound(targetClassType);
                    }
                    values.add(value);
                }
                try {
                    initializerMethod.setAccessible(true);
                    initializerMethod.invoke((Object)this, values.toArray());
                    initializerMethod.setAccessible(false);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    initializerMethod.setAccessible(false);
                    throw new RuntimeException(e.getCause() != null ? e.getCause() : e);
                }
            }
            throw new RuntimeException("\u521d\u59cb\u5316\u65b9\u6cd5\u4e0d\u662fprivate");
        }
    }

    private void resolveField(Field field) {
        if (Modifier.isPrivate(field.getModifiers())) {
            field.setAccessible(true);
            try {
                Class<?> targetClassType = field.getType();
                Object value = this.dependencies.get(targetClassType, false);
                if (value == null && !field.getAnnotation(Resolved.class).allowNull()) {
                    this.throwDependencyNotFound(targetClassType);
                }
                field.set(this, value);
            }
            catch (IllegalAccessException e) {
                field.setAccessible(false);
                throw new RuntimeException(e.getCause() != null ? e.getCause() : e);
            }
        } else {
            throw new RuntimeException("\u5b57\u6bb5\u5fc5\u987b\u662fprivate");
        }
        field.setAccessible(false);
    }

    private void throwDependencyNotFound(Class<?> targetClassType) {
        throw new NullDependencyException(this.getClass().getSimpleName() + "\u4f9d\u8d56" + targetClassType.getSimpleName() + ", \u4f46\u5176\u5c1a\u672a\u88ab\u6ce8\u518c");
    }

    @Deprecated
    protected ScheduleInfo addSchedule(Consumer<?> c) {
        return this.addSchedule(() -> c.accept(null), 0);
    }

    @Deprecated
    protected ScheduleInfo addSchedule(Consumer<?> c, int delay) {
        return this.addSchedule(() -> c.accept(null), delay);
    }

    @Deprecated
    protected ScheduleInfo addSchedule(Consumer<?> c, int delay, boolean isAsync) {
        return this.addSchedule(() -> c.accept(null), delay, isAsync);
    }

    protected ScheduleInfo addSchedule(Runnable r) {
        return this.plugin.schedule(r);
    }

    protected ScheduleInfo addSchedule(Runnable r, int delay) {
        return this.plugin.schedule(r, delay);
    }

    protected ScheduleInfo addSchedule(Runnable r, int delay, boolean isAsync) {
        return this.plugin.schedule(r, delay, isAsync);
    }
}

