/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Bindables.Bindable;
import xiamomc.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.EntityCache;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.toasts.DisguiseEntryToast;
import xyz.nifeather.morph.client.graphics.toasts.NewDisguiseSetToast;
import xyz.nifeather.morph.client.properties.AbstractPropertyHandler;
import xyz.nifeather.morph.client.properties.PropertyHandlers;
import xyz.nifeather.morph.client.syncers.ClientDisguiseSyncer;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;
import xyz.nifeather.morph.client.syncers.OtherClientDisguiseSyncer;
import xyz.nifeather.morph.client.syncers.animations.AnimHandlerIndex;
import xyz.nifeather.morph.client.syncers.animations.AnimationHandler;

public class ClientMorphManager
extends MorphClientObject {
    private final SortedSet<String> availableMorphs = new ObjectAVLTreeSet();
    public final Bindable<String> selectedIdentifier = new Bindable<Object>(null);
    public final Bindable<String> currentIdentifier = new Bindable<Object>(null);
    public final Bindable<Boolean> equipOverriden = new Bindable<Boolean>(false);
    public final Bindable<class_2487> currentNbtCompound = new Bindable<Object>(null);
    public final Bindable<Float> revealingValue = new Bindable<Float>(Float.valueOf(0.0f));
    @Resolved
    private DisguiseInstanceTracker instanceTracker;
    private final List<String> emotes = new ObjectArrayList();
    @Nullable
    public String lastEmote;
    @Nullable
    public String emoteDisplayName;
    @Nullable
    private DisguiseSyncer localPlayerSyncer;
    private class_638 world;
    private class_638 prevWorld;
    @Nullable
    private class_1657 lastClientPlayer;
    private final AtomicBoolean syncerRefreshScheduled = new AtomicBoolean(false);
    public final Bindable<Boolean> selfVisibleEnabled = new Bindable<Boolean>(false);
    private final List<Function<List<String>, Boolean>> onGrantConsumers = new ObjectArrayList();
    private final List<Function<List<String>, Boolean>> onRevokeConsumers = new ObjectArrayList();
    private final Map<class_1304, class_1799> equipmentSlotItemStackMap = new Object2ObjectOpenHashMap();
    private final class_1799 air = class_1799.field_8037;
    @Resolved
    private AnimHandlerIndex animIndex;
    @Nullable
    private GameProfile serverSkin;
    @Nullable
    private AbstractPropertyHandler<?> propertyHandler;

    public List<String> getAvailableMorphs() {
        return this.availableMorphs.stream().toList();
    }

    public void clearAvailableDisguises() {
        ObjectArrayList disguises = new ObjectArrayList(this.availableMorphs);
        this.availableMorphs.clear();
        this.invokeRevoke((List<String>)disguises);
    }

    public void setEmotes(List<String> emotes) {
        if (emotes.size() > 4) {
            this.logger.warn("Server send a emote that has more than 4 elements!");
        }
        this.emotes.clear();
        this.emotes.addAll(emotes);
    }

    public void setEmoteDisplay(String id) {
        this.emoteDisplayName = id;
    }

    public void playEmote(String emote) {
        this.lastEmote = !emote.equals("reset") && !emote.equals("try_reset") ? emote : null;
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.playAnimation(emote);
        }
    }

    public List<String> getEmotes() {
        return new ObjectArrayList(this.emotes);
    }

    @Initializer
    private void load() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (RenderSystem.isOnRenderThread()) {
                this.onDisconnect();
            } else {
                this.addSchedule(this::onDisconnect);
            }
        });
        this.addSchedule(this::update);
    }

    private void onDisconnect() {
        this.world = null;
        this.prevWorld = null;
        this.reset();
    }

    private void update() {
        class_746 currentClientPlayer;
        this.addSchedule(this::update);
        this.world = class_310.method_1551().field_1687;
        if (this.world == null) {
            return;
        }
        if (this.prevWorld == null) {
            this.prevWorld = this.world;
        }
        if (this.world != this.prevWorld) {
            this.prevWorld = this.world;
        }
        if ((currentClientPlayer = class_310.method_1551().field_1724) != null && this.lastClientPlayer != currentClientPlayer && !this.syncerRefreshScheduled.get()) {
            if (this.localPlayerSyncer != null && this.localPlayerSyncer.disposed()) {
                this.localPlayerSyncer = null;
            }
            this.refreshLocalSyncer(this.currentIdentifier.get());
        }
        this.lastClientPlayer = currentClientPlayer;
    }

    private void refreshLocalSyncer(String n) {
        this.logger.info("Refresh local syncer...");
        this.syncerRefreshScheduled.set(false);
        if (this.localPlayerSyncer != null) {
            this.logger.info("Removing previous syncer " + String.valueOf(this.localPlayerSyncer));
            this.instanceTracker.removeSyncer(this.localPlayerSyncer);
            this.localPlayerSyncer.dispose();
            this.localPlayerSyncer = null;
        }
        this.propertyHandler = null;
        if (n == null || n.isEmpty()) {
            return;
        }
        this.localPlayerSyncer = this.instanceTracker.setSyncer((class_1297)class_310.method_1551().field_1724, n);
        if (this.localPlayerSyncer == null) {
            return;
        }
        if (this.lastEmote != null) {
            this.localPlayerSyncer.playAnimation(this.lastEmote);
        }
        if (this.serverSkin != null) {
            this.localPlayerSyncer.updateSkin(this.serverSkin);
        }
        this.localPlayerSyncer.getEntityFuture().thenAccept(entity -> {
            AbstractPropertyHandler<class_1309> newHandler = PropertyHandlers.INSTANCE.getHandler(entity).orElseThrow();
            newHandler.tryCast((class_1297)entity).ifPresent(living -> newHandler.handle(this.localPlayerSyncer.cachedNetworkProperties(), (class_1309)living));
            this.propertyHandler = newHandler;
        });
    }

    public void onMorphGrant(Function<List<String>, Boolean> consumer) {
        this.onGrantConsumers.add(consumer);
    }

    public void onMorphRevoke(Function<List<String>, Boolean> consumer) {
        this.onRevokeConsumers.add(consumer);
    }

    private void invokeRevoke(List<String> diff) {
        ObjectArrayList tobeRemoved = new ObjectArrayList();
        this.onRevokeConsumers.forEach(f -> {
            if (!((Boolean)f.apply(diff)).booleanValue()) {
                tobeRemoved.add(f);
            }
        });
        this.onRevokeConsumers.removeAll((Collection<?>)tobeRemoved);
    }

    private void invokeGrant(List<String> diff) {
        ObjectArrayList tobeRemoved = new ObjectArrayList();
        this.onGrantConsumers.forEach(f -> {
            if (!((Boolean)f.apply(diff)).booleanValue()) {
                tobeRemoved.add(f);
            }
        });
        this.onGrantConsumers.removeAll((Collection<?>)tobeRemoved);
    }

    public void setDisguises(List<String> identifiers, boolean displayToasts) {
        this.invokeRevoke(this.availableMorphs.stream().toList());
        this.availableMorphs.clear();
        this.addDisguises(identifiers, false);
        DisguiseEntryToast.invalidateAll();
        if (displayToasts) {
            class_310.method_1551().method_1566().method_1999((class_368)new NewDisguiseSetToast(this.availableMorphs.size() <= 0));
        }
    }

    public void addDisguises(List<String> identifiers, boolean displayToasts) {
        identifiers = new ObjectArrayList(identifiers);
        identifiers.removeIf(this.availableMorphs::contains);
        identifiers.forEach(i -> this.addDisguisePrivate((String)i, displayToasts));
        this.invokeGrant((List<String>)identifiers);
    }

    public void addDisguise(String identifier, boolean displayToasts) {
        this.addDisguisePrivate(identifier, displayToasts);
    }

    public void removeDisguises(List<String> identifiers, boolean displayToasts) {
        identifiers.forEach(i -> this.removeDisguisePrivate((String)i, displayToasts));
        this.invokeRevoke(identifiers);
    }

    public void removeDisguise(String identifier, boolean displayToasts) {
        this.removeDisguisePrivate(identifier, displayToasts);
    }

    private void addDisguisePrivate(String identifier, boolean displayToasts) {
        if (identifier.isEmpty()) {
            return;
        }
        this.availableMorphs.add(identifier);
        if (displayToasts) {
            class_310.method_1551().method_1566().method_1999((class_368)new DisguiseEntryToast(identifier, true));
        }
    }

    private void removeDisguisePrivate(String identifier, boolean displayToasts) {
        this.availableMorphs.remove(identifier);
        if (displayToasts) {
            class_310.method_1551().method_1566().method_1999((class_368)new DisguiseEntryToast(identifier, false));
        }
    }

    public class_1799 getOverridedItemStackOn(class_1304 slot) {
        return this.equipmentSlotItemStackMap.getOrDefault(slot, this.air);
    }

    public void swapHand() {
        class_1799 mainHand = this.equipmentSlotItemStackMap.getOrDefault(class_1304.field_6173, this.air);
        class_1799 offHand = this.equipmentSlotItemStackMap.getOrDefault(class_1304.field_6171, this.air);
        this.equipmentSlotItemStackMap.put(class_1304.field_6173, offHand);
        this.equipmentSlotItemStackMap.put(class_1304.field_6171, mainHand);
    }

    public void setEquip(class_1304 slot, class_1799 item) {
        this.equipmentSlotItemStackMap.put(slot, item);
    }

    public void reset() {
        this.clearAvailableDisguises();
        this.setEmotes(List.of());
        this.selectedIdentifier.set(null);
        this.currentIdentifier.set(null);
        this.revealingValue.set(Float.valueOf(0.0f));
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.dispose();
        }
        this.localPlayerSyncer = null;
        this.lastEmote = null;
        EntityCache.getGlobalCache().dropAll();
        this.prevWorld = null;
        this.world = null;
        this.lastClientPlayer = null;
    }

    public void setCurrent(String val) {
        RenderSystem.assertOnRenderThread();
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.dispose();
        }
        this.localPlayerSyncer = null;
        this.lastEmote = null;
        this.emoteDisplayName = null;
        this.serverSkin = null;
        String finalVal = val;
        this.refreshLocalSyncer(finalVal);
        this.syncerRefreshScheduled.set(true);
        if (val != null && val.isBlank()) {
            val = null;
        }
        this.currentIdentifier.set(val);
        this.equipOverriden.set(false);
        this.equipmentSlotItemStackMap.clear();
        this.currentNbtCompound.set(null);
    }

    public DisguiseSyncer createSyncerFor(class_742 player, String disguiseId, int networkId) {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            throw new NullDependencyException("Required non-null client player to get DisguiseSyncer");
        }
        DisguiseSyncer syncer = clientPlayer == player ? new ClientDisguiseSyncer(player, disguiseId, networkId) : new OtherClientDisguiseSyncer(player, disguiseId, networkId);
        AnimationHandler handler = this.animIndex.get(disguiseId);
        syncer.setAnimationHandler(handler);
        return syncer;
    }

    public void updateSkin(GameProfile profile) {
        this.serverSkin = profile;
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.updateSkin(profile);
        } else {
            this.logger.warn("Calling UpdateSkin while localPlayerSyncer is null!");
            Thread.dumpStack();
        }
    }

    public void handlePropertiesUpdate(Map<String, String> input) {
        if (this.localPlayerSyncer == null) {
            return;
        }
        this.localPlayerSyncer.mergeNetworkProperties(input);
        class_1309 entity = this.localPlayerSyncer.getDisguiseInstance();
        if (entity == null) {
            return;
        }
        AbstractPropertyHandler<?> propertyHandler = this.propertyHandler();
        if (propertyHandler == null) {
            return;
        }
        propertyHandler.tryCast((class_1297)entity).ifPresent(cast -> propertyHandler.handle(input, cast));
    }

    @Nullable
    public AbstractPropertyHandler<?> propertyHandler() {
        return this.propertyHandler;
    }
}

