/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.client.utilties.NbtHelperCopy;
import xyz.nifeather.morph.client.utilties.NbtUtils;
import xyz.nifeather.morph.network.commands.S2C.clientrender.Equipment;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CRenderMeta;

public class ConvertedMeta {
    @Nullable
    public class_2487 nbt;
    @Nullable
    public GameProfile profileNbt;
    @Nullable
    public ConvertedEquipment convertedEquipment;
    public boolean showOverridedEquips;
    public boolean outdated = false;

    public void mergeFrom(ConvertedMeta other) {
        if (other.nbt != null) {
            this.nbt = other.nbt;
        }
        if (other.profileNbt != null) {
            this.profileNbt = other.profileNbt;
        }
        if (other.convertedEquipment != null) {
            this.convertedEquipment = other.convertedEquipment;
        }
        this.showOverridedEquips = other.showOverridedEquips;
    }

    public static ConvertedMeta of(S2CRenderMeta renderMeta, class_7225.class_7874 registry) {
        ConvertedMeta instance = new ConvertedMeta();
        Logger logger = LoggerFactory.getLogger((String)"MorphClient");
        instance.nbt = NbtUtils.parseSNbt(renderMeta.sNbt);
        class_2487 profileNbt = NbtUtils.parseSNbt(renderMeta.profileCompound);
        if (profileNbt != null) {
            instance.profileNbt = NbtHelperCopy.toGameProfile(profileNbt);
        }
        instance.showOverridedEquips = renderMeta.showOverridedEquipment;
        try {
            Equipment overridedEquipment = renderMeta.overridedEquipment;
            if (overridedEquipment != null) {
                String[] eqIds = new String[]{overridedEquipment.headId, overridedEquipment.chestId, overridedEquipment.leggingId, overridedEquipment.feetId, overridedEquipment.handId, overridedEquipment.offhandId};
                String[] eqNbt = new String[]{overridedEquipment.headNbt, overridedEquipment.chestNbt, overridedEquipment.leggingNbt, overridedEquipment.feetNbt, overridedEquipment.handNbt, overridedEquipment.offhandNbt};
                ObjectArrayList items = new ObjectArrayList();
                for (int i = 0; i < eqIds.length - 1; ++i) {
                    class_1799 item;
                    String itemId = eqIds[i];
                    class_2960 identifier = class_2960.method_12829((String)itemId);
                    if (identifier == null) {
                        logger.warn("Cannot parse item id %s, ignoring".formatted(itemId));
                        item = class_1799.field_8037;
                    } else {
                        item = new class_1799((class_1935)class_7923.field_41178.method_63535(identifier));
                    }
                    item.method_7939(Math.max(item.method_7947(), 1));
                    items.add((Object)item);
                }
                instance.convertedEquipment = ConvertedEquipment.from((class_1799[])items.toArray((Object[])new class_1799[0]));
            }
            return instance;
        }
        catch (Throwable t) {
            logger.error("Error occurred while parsing meta: %s".formatted(t.getMessage()));
            t.printStackTrace();
            return null;
        }
    }

    public static class ConvertedEquipment {
        @NotNull
        public class_1799 head = class_1799.field_8037;
        @NotNull
        public class_1799 chest = class_1799.field_8037;
        @NotNull
        public class_1799 leggings = class_1799.field_8037;
        @NotNull
        public class_1799 feet = class_1799.field_8037;
        @NotNull
        public class_1799 mainHand = class_1799.field_8037;
        @NotNull
        public class_1799 offHand = class_1799.field_8037;

        public boolean isEmpty() {
            return this.head.method_7960() && this.chest.method_7960() && this.leggings.method_7960() && this.feet.method_7960() && this.mainHand.method_7960() && this.offHand.method_7960();
        }

        public static ConvertedEquipment from(class_1799 ... stacks) {
            ConvertedEquipment instance = new ConvertedEquipment();
            for (int i = 0; i < stacks.length; ++i) {
                class_1799 item = stacks[i];
                if (i == 0) {
                    instance.head = item;
                    continue;
                }
                if (i == 1) {
                    instance.chest = item;
                    continue;
                }
                if (i == 2) {
                    instance.leggings = item;
                    continue;
                }
                if (i == 3) {
                    instance.feet = item;
                    continue;
                }
                if (i == 4) {
                    instance.mainHand = item;
                    continue;
                }
                if (i != 5) continue;
                instance.offHand = item;
            }
            return instance;
        }
    }
}

