/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.ConvertedMeta;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRClearCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSetMetaCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSyncRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRUnregisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CRenderMeta;

public class DisguiseInstanceTracker
extends MorphClientObject {
    private static DisguiseInstanceTracker instance;
    @Resolved
    private ClientMorphManager manager;
    private final Map<Integer, String> trackingDisguises = new Object2ObjectArrayMap();
    private final Map<Integer, ConvertedMeta> idMetaMap = new HashMap<Integer, ConvertedMeta>();
    private final Map<Integer, DisguiseSyncer> idSyncerMap = new ConcurrentHashMap<Integer, DisguiseSyncer>();
    public final Map<Integer, String> playerMap = new Object2ObjectArrayMap();

    public static DisguiseInstanceTracker getInstance() {
        return instance;
    }

    public DisguiseInstanceTracker() {
        instance = this;
    }

    public Map<Integer, String> getTrackingDisguises() {
        return new Object2ObjectArrayMap(this.trackingDisguises);
    }

    public void onSyncCommand(S2CCRSyncRegisterCommand s2CRenderMapSyncCommand) {
        this.reset();
        Map map = s2CRenderMapSyncCommand.getMap();
        this.trackingDisguises.putAll(map);
        map.forEach(this::addSyncerIfNotExist);
    }

    public void onAddCommand(S2CCRRegisterCommand s2CRenderMapAddCommand) {
        if (!s2CRenderMapAddCommand.isValid()) {
            return;
        }
        int networkId = s2CRenderMapAddCommand.getPlayerNetworkId();
        this.trackingDisguises.put(networkId, s2CRenderMapAddCommand.getMobId());
        if (class_310.method_1551().field_1724.method_5628() == networkId) {
            return;
        }
        DisguiseSyncer prevSyncer = this.getSyncerFor(networkId);
        if (prevSyncer != null) {
            this.removeSyncer(prevSyncer);
        }
        this.addSyncerIfNotExist(networkId, s2CRenderMapAddCommand.getMobId());
    }

    public void onRemoveCommand(S2CCRUnregisterCommand s2CRenderMapRemoveCommand) {
        if (!s2CRenderMapRemoveCommand.isValid()) {
            return;
        }
        int id = s2CRenderMapRemoveCommand.getPlayerNetworkId();
        this.trackingDisguises.remove(id);
        DisguiseSyncer syncer = this.idSyncerMap.getOrDefault(id, null);
        if (syncer != null) {
            this.removeSyncer(syncer);
        }
    }

    public void onClearCommand(S2CCRClearCommand s2CRenderMapClearCommand) {
        this.reset();
    }

    public void onMetaCommand(S2CCRSetMetaCommand metaCommand) {
        S2CRenderMeta meta = metaCommand.renderMeta;
        if (meta == null) {
            this.logger.warn("Received S2CRenderMapMetaCommand with no meta! Not Processing...");
            return;
        }
        int networkId = meta.networkId;
        if (networkId == -1) {
            this.logger.warn("Received S2CRenderMapMetaCommand with -1 network id! Not Processing...");
            return;
        }
        class_5455 registry = class_310.method_1551().field_1724.method_73183().method_30349();
        ConvertedMeta newMeta = ConvertedMeta.of(meta, (class_7225.class_7874)registry);
        ConvertedMeta currentMeta = this.getMetaFor(networkId);
        if (newMeta != null) {
            currentMeta.mergeFrom(newMeta);
        }
        currentMeta.outdated = true;
        this.idMetaMap.put(networkId, currentMeta);
    }

    public void reset() {
        this.trackingDisguises.clear();
        this.playerMap.clear();
        Object2ObjectArrayMap mapCopy = new Object2ObjectArrayMap(this.idSyncerMap);
        mapCopy.forEach((id, syncer) -> this.removeSyncer((DisguiseSyncer)syncer));
        this.idMetaMap.clear();
    }

    public ConvertedMeta getMetaFor(class_1297 entity) {
        return this.getMetaFor(entity.method_5628());
    }

    @NotNull
    public ConvertedMeta getMetaFor(int networkId) {
        ConvertedMeta meta = this.idMetaMap.getOrDefault(networkId, null);
        return meta == null ? new ConvertedMeta() : meta;
    }

    public List<DisguiseSyncer> getAllSyncer() {
        return new ObjectArrayList(this.idSyncerMap.values());
    }

    @Nullable
    public DisguiseSyncer findSyncerByDisguiseEntity(class_1297 entity) {
        int id = entity.method_5628();
        DisguiseSyncer targetSyncer = this.idSyncerMap.values().stream().filter(syncer -> syncer.getDisguiseInstance() != null && syncer.getDisguiseInstance().method_5628() == id).findFirst().orElse(null);
        return targetSyncer;
    }

    public void removeSyncer(DisguiseSyncer targetSyncer) {
        targetSyncer.dispose();
        Optional<Map.Entry> optional = this.idSyncerMap.entrySet().stream().filter(e -> ((DisguiseSyncer)e.getValue()).equals(targetSyncer)).findFirst();
        if (optional.isPresent()) {
            this.idSyncerMap.remove(optional.get().getKey());
        } else {
            this.logger.warn("Trying to remove an DisguiseSyncer that is not in the list?!");
            Thread.dumpStack();
        }
    }

    @Nullable
    public DisguiseSyncer getSyncerFor(class_1297 entity) {
        return this.idSyncerMap.getOrDefault(entity.method_5628(), null);
    }

    @Nullable
    public DisguiseSyncer getSyncerFor(int networkId) {
        return this.idSyncerMap.getOrDefault(networkId, null);
    }

    @Nullable
    public DisguiseSyncer addSyncerIfNotExist(int networkId, String did) {
        DisguiseSyncer syncer;
        if (this.idSyncerMap.containsKey(networkId) && !(syncer = this.idSyncerMap.get(networkId)).disposed()) {
            return syncer;
        }
        class_638 world = class_310.method_1551().field_1687;
        class_1297 entity = world.method_8469(networkId);
        if (!(entity instanceof class_742)) {
            return null;
        }
        class_742 player = (class_742)entity;
        DisguiseSyncer syncer2 = this.manager.createSyncerFor(player, did, networkId);
        this.idSyncerMap.put(networkId, syncer2);
        return syncer2;
    }

    @Nullable
    public DisguiseSyncer setSyncer(class_1297 entity, String newId) {
        if (!(entity instanceof class_742)) {
            return null;
        }
        class_742 player = (class_742)entity;
        int networkId = entity.method_5628();
        DisguiseSyncer prevSyncer = this.idSyncerMap.getOrDefault(networkId, null);
        if (prevSyncer != null) {
            this.removeSyncer(prevSyncer);
        }
        DisguiseSyncer syncer = this.manager.createSyncerFor(player, newId, player.method_5628());
        this.idSyncerMap.put(networkId, syncer);
        return syncer;
    }

    @Nullable
    public DisguiseSyncer addSyncerIfNotExist(class_1297 entity) {
        int networkId = entity.method_5628();
        if (this.idSyncerMap.containsKey(networkId)) {
            return this.idSyncerMap.get(networkId);
        }
        String tracking = this.trackingDisguises.getOrDefault(networkId, "no");
        if (tracking.equals("no")) {
            return null;
        }
        if (!(entity instanceof class_742)) {
            return null;
        }
        class_742 player = (class_742)entity;
        DisguiseSyncer syncer = this.manager.createSyncerFor(player, tracking, player.method_5628());
        this.idSyncerMap.put(networkId, syncer);
        return syncer;
    }
}

