/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.entities.MorphLocalAvatar;
import xyz.nifeather.morph.client.entities.MorphLocalPlayer;
import xyz.nifeather.morph.client.utilties.EntityCacheUtils;

public class EntityCache {
    private static final EntityCache globalInstance = new EntityCache();
    private final Map<String, class_1309> cacheMap = new ConcurrentHashMap<String, class_1309>();
    public final Bindable<Boolean> droppingCaches = new Bindable();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final long lockWait = 10L;
    private final Map<String, Boolean> isLivingMap = new ConcurrentHashMap<String, Boolean>();
    public static final String tag = "FMC_ClientView";
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public static EntityCache getGlobalCache() {
        return globalInstance;
    }

    public EntityCache() {
        EntityCacheUtils.addOnEntityAddHook(this, e -> {
            if (e.method_5752().contains(tag)) {
                return;
            }
            List<Map.Entry> targets = this.cacheMap.entrySet().stream().filter(entry -> ((class_1309)entry.getValue()).method_5667().equals(e.method_5667())).toList();
            targets.forEach(ee -> {
                String id = (String)ee.getKey();
                this.discardEntity(id);
            });
        });
    }

    public void clearCache() {
        this.cacheMap.clear();
    }

    public boolean containsId(int id) {
        try {
            return this.cacheMap.values().stream().filter(l -> l.method_5628() == id).findFirst().orElse(null) != null;
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"MorphClient").error("Error checking cache: " + e.getMessage());
            e.printStackTrace();
            this.cacheMap.remove(null);
            return false;
        }
    }

    public void discardEntity(String identifier) {
        class_1309 entity = this.cacheMap.getOrDefault(identifier, null);
        if (entity != null) {
            FeatherMorphClientBootstrap.getInstance().schedule(() -> {
                entity.method_31472();
                entity.method_36209();
            });
            this.cacheMap.remove(identifier);
        }
    }

    public boolean isLiving(String identifier) {
        return this.isLivingMap.getOrDefault(identifier, false);
    }

    public void dropAll() {
        this.droppingCaches.set(true);
        FeatherMorphClientBootstrap morphClient = FeatherMorphClientBootstrap.getInstance();
        this.cacheMap.forEach((id, entity) -> {
            morphClient.schedule(() -> ((class_1309)entity).method_31472());
            this.cacheMap.remove(id);
        });
        this.cacheMap.clear();
        this.droppingCaches.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public class_1309 getEntity(String identifier, class_1657 bindingPlayer) {
        Object living;
        boolean locked;
        block41: {
            class_1309 cache;
            if (identifier == null) {
                return null;
            }
            if (this.disposed.get()) {
                throw new RuntimeException("Cannot access getEntity() for a disposed EntityCache.");
            }
            try {
                locked = this.readLock.tryLock(10L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                FeatherMorphClientBootstrap.LOGGER.warn("Unable to lock entity cache for read: " + t.getMessage());
                locked = false;
            }
            if (!locked) {
                FeatherMorphClientBootstrap.LOGGER.warn("Unable to lock entity cache for read: Timed out.");
                return null;
            }
            try {
                cache = this.cacheMap.getOrDefault(identifier, null);
            }
            finally {
                this.readLock.unlock();
            }
            if (cache != null && !cache.method_31481()) {
                return cache;
            }
            living = null;
            if (identifier.startsWith("minecraft:")) {
                Optional typeOptional = class_1299.method_5898((String)identifier);
                if (typeOptional.isEmpty()) {
                    return null;
                }
                class_1299 type = (class_1299)typeOptional.get();
                try (class_638 world = class_310.method_1551().field_1687;){
                    MorphLocalAvatar instance;
                    if (world == null) {
                        class_1309 class_13092 = null;
                        return class_13092;
                    }
                    MorphLocalAvatar morphLocalAvatar = instance = type == class_1299.field_62515 ? new MorphLocalAvatar((class_1937)world) : type.method_5883((class_1937)world, class_3730.field_16462);
                    if (!(instance instanceof class_1309)) {
                        this.isLivingMap.put(identifier, false);
                        class_1309 class_13093 = null;
                        return class_13093;
                    }
                    class_1309 le = (class_1309)instance;
                    UUID uuid = this.ensureUUIDUnique(class_3532.method_15394());
                    le.method_5826(uuid);
                    living = le;
                    break block41;
                }
                catch (Throwable t) {
                    FeatherMorphClientBootstrap.LOGGER.error("Error occurred while creating entity: %s".formatted(t.getMessage()));
                    t.printStackTrace();
                    return null;
                }
            }
            if (identifier.startsWith("player:")) {
                String[] splitedId = identifier.split(":", 2);
                if (splitedId.length != 2) {
                    return null;
                }
                UUID uuid = this.ensureUUIDUnique(class_3532.method_15394());
                GameProfile profile = new GameProfile(uuid, splitedId[1]);
                try (class_638 world = class_310.method_1551().field_1687;){
                    MorphLocalPlayer localPlayer = new MorphLocalPlayer(world, profile, bindingPlayer);
                    localPlayer.updateSkin(new GameProfile(class_156.field_25140, splitedId[1]));
                    living = localPlayer;
                }
                catch (Throwable t) {
                    FeatherMorphClientBootstrap.LOGGER.error("Error occurred while creating entity: %s".formatted(t.getMessage()));
                    t.printStackTrace();
                    return null;
                }
                this.isLivingMap.put(identifier, true);
            }
        }
        if (living == null) {
            return null;
        }
        try {
            locked = this.writeLock.tryLock(10L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            FeatherMorphClientBootstrap.LOGGER.warn("Unable to lock entity cache for write: " + t.getMessage());
            t.printStackTrace();
            return null;
        }
        if (!locked) {
            FeatherMorphClientBootstrap.LOGGER.warn("Unable to lock entity cache for write: Timed out");
            return null;
        }
        try {
            living.method_5780(tag);
            this.isLivingMap.put(identifier, true);
            this.cacheMap.put(identifier, (class_1309)living);
        }
        finally {
            this.writeLock.unlock();
        }
        if (!identifier.startsWith("player:")) return living;
        LoggerFactory.getLogger((String)"morph").info("Pushing " + identifier + " into EntityCache.");
        return living;
    }

    private UUID ensureUUIDUnique(UUID uuid) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return uuid;
        }
        boolean haveMatch = true;
        block0: while (haveMatch) {
            haveMatch = false;
            for (class_1297 entity : world.method_18112()) {
                if (!entity.method_5667().equals(uuid)) continue;
                uuid = class_3532.method_15394();
                haveMatch = true;
                continue block0;
            }
        }
        return uuid;
    }

    public boolean disposed() {
        return this.disposed.get();
    }

    public void dispose() {
        this.dropAll();
        EntityCacheUtils.removeOnEntityAddHook(this);
        this.disposed.set(true);
    }
}

