/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakReferenceList<T>
implements Iterable<T> {
    private final ObjectArrayList<WeakReference<T>> list = new ObjectArrayList();

    public void removeNull() {
        this.list.removeIf(ref -> ref.get() == null);
    }

    @Nullable
    public T get(int i) {
        WeakReference ref = (WeakReference)this.list.get(i);
        return ref == null ? null : (T)ref.get();
    }

    public T set(int i, T t) {
        WeakReference<T> ref = new WeakReference<T>(t);
        this.list.set(i, ref);
        return t;
    }

    public void add(int i, T t) {
        WeakReference<T> ref = new WeakReference<T>(t);
        this.list.add(i, ref);
    }

    public T remove(int i) {
        WeakReference ref = (WeakReference)this.list.remove(i);
        return ref.get();
    }

    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        WeakReference ref = this.list.stream().filter(r -> o.equals(r.get())).findFirst().orElse(null);
        if (ref != null) {
            return this.list.indexOf((Object)ref);
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        WeakReference ref = this.list.stream().filter(r -> o.equals(r.get())).findFirst().orElse(null);
        if (ref != null) {
            return this.list.lastIndexOf((Object)ref);
        }
        return -1;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(WeakReference<T> weakRef) {
        if (weakRef == null) {
            return false;
        }
        return this.list.contains(weakRef);
    }

    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        return this.list.stream().anyMatch(ref -> t.equals(ref.get()));
    }

    public boolean add(WeakReference<T> weakRef) {
        if (weakRef == null) {
            return false;
        }
        return this.list.add(weakRef);
    }

    public boolean remove(WeakReference<T> weakRef) {
        if (weakRef == null) {
            return false;
        }
        return this.list.removeIf(ref -> weakRef == ref);
    }

    public boolean remove(T t) {
        if (t == null) {
            return false;
        }
        return this.list.removeIf(ref -> t.equals(ref.get()));
    }

    public boolean containsAll(@NotNull Collection<T> collection) {
        boolean success = true;
        for (T o : collection) {
            if (this.contains(o)) continue;
            success = false;
            break;
        }
        return success;
    }

    public boolean addAll(@NotNull Collection<WeakReference<T>> collection) {
        boolean changed = false;
        for (WeakReference<T> o : collection) {
            changed = changed || this.add(o);
        }
        return changed;
    }

    public boolean removeAll(@NotNull Collection<T> collection) {
        boolean changed = false;
        for (T o : collection) {
            changed = changed || this.remove(o);
        }
        return changed;
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new WeakRefIterator(this);
    }

    private static class WeakRefIterator<T>
    implements ListIterator<T> {
        private final WeakReferenceList<T> refList;
        private final ListIterator<WeakReference<T>> backendIterator;

        private WeakRefIterator(WeakReferenceList<T> weakList) {
            this.refList = weakList;
            this.backendIterator = weakList.list.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.backendIterator.hasNext();
        }

        @Override
        public T next() {
            return this.backendIterator.next().get();
        }

        @Override
        public boolean hasPrevious() {
            return this.backendIterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.backendIterator.previous().get();
        }

        @Override
        public int nextIndex() {
            return this.backendIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.backendIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.backendIterator.remove();
        }

        @Override
        public void set(T t) {
            this.backendIterator.set(new WeakReference<T>(t));
        }

        @Override
        public void add(T t) {
            this.backendIterator.add(new WeakReference<T>(t));
        }
    }
}

