/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.commands.subCommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.storage.SavedDisguiseStorage;
import xyz.nifeather.morph.client.storage.struct.SavedDisguise;
import xyz.nifeather.morph.client.syncers.ClientDisguiseSyncer;
import xyz.nifeather.morph.shared.commands.IBrigadierCommand;

public class SaveDisguiseSubCommand
implements IBrigadierCommand<FabricClientCommandSource> {
    @Override
    public void registerAsChild(ArgumentBuilder<FabricClientCommandSource, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"saved-morphs").then(ClientCommandManager.literal((String)"save").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::runSaveDisguise)))).then(ClientCommandManager.literal((String)"drop").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggestSavedDisguise).executes(this::runDropDisguise)))).then(ClientCommandManager.literal((String)"disguise").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggestSavedDisguise).executes(this::runSelectDisguise)))).then(ClientCommandManager.literal((String)"refresh").executes(this::refreshStorage)));
    }

    private int refreshStorage(CommandContext<FabricClientCommandSource> context) {
        this.savedDisguiseStorage().refresh();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"text.morphclient.refresh_cache"));
        return 1;
    }

    private SavedDisguiseStorage savedDisguiseStorage() {
        return FeatherMorphClientBootstrap.getInstance().savedDisguiseStorage;
    }

    private CompletableFuture<Suggestions> suggestSavedDisguise(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        String input = builder.getRemaining();
        this.savedDisguiseStorage().listAll().forEach(id -> {
            if (id.contains(input)) {
                builder.suggest(id);
            }
        });
        return builder.buildFuture();
    }

    private int runDropDisguise(CommandContext<FabricClientCommandSource> context) {
        String saveName = StringArgumentType.getString(context, (String)"name");
        class_5250 message = this.savedDisguiseStorage().drop(saveName) ? class_2561.method_43469((String)"text.morphclient.drop_morph_success", (Object[])new Object[]{saveName}) : class_2561.method_43469((String)"text.morphclient.drop_morph_failed", (Object[])new Object[]{saveName});
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)message);
        return 1;
    }

    private int runSelectDisguise(CommandContext<FabricClientCommandSource> context) {
        String saveName = StringArgumentType.getString(context, (String)"name");
        SavedDisguise saved = (SavedDisguise)this.savedDisguiseStorage().get(saveName);
        if (saved == null || saved.equals(this.savedDisguiseStorage().getDefault())) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"text.morphclient.saved_morph_not_found"));
            return 0;
        }
        FeatherMorphClientBootstrap.getInstance().requestDisguise(saved.disguiseIdentifier(), saved.properties());
        return 1;
    }

    private int runSaveDisguise(CommandContext<FabricClientCommandSource> context) {
        if (ClientDisguiseSyncer.getCurrentInstance() == null || ClientDisguiseSyncer.getCurrentInstance().disposed()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"text.morphclient.not_disguising"));
            return 0;
        }
        String saveName = StringArgumentType.getString(context, (String)"name");
        SavedDisguise savedDisguise = SavedDisguise.fromSyncer(ClientDisguiseSyncer.getCurrentInstance());
        if (this.savedDisguiseStorage().save(savedDisguise, saveName)) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.morphclient.save_morph_success", (Object[])new Object[]{saveName}));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"text.morphclient.save_morph_failed"));
        }
        return 1;
    }
}

