/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_5611;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.client.EntityCache;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.Axes;
import xyz.nifeather.morph.client.graphics.LoadingSpinner;
import xyz.nifeather.morph.client.graphics.MDrawable;
import xyz.nifeather.morph.client.graphics.PlayerRenderHelper;

public class EntityDisplay
extends MDrawable {
    private final String rawIdentifier;
    private final boolean isPlayerItSelf;
    private final boolean displayLoadingIfInvalid;
    @Nullable
    private class_1309 displayingEntity;
    private AtomicBoolean isLiving = new AtomicBoolean(true);
    private class_2561 displayName;
    private final AtomicInteger initialEntitySize = new AtomicInteger(1);
    private int entityYOffset;
    private final AtomicBoolean loadingEntity = new AtomicBoolean(false);
    public Runnable postEntitySetup;
    private boolean allowRender;
    private final LoadingSpinner loadingSpinner = new LoadingSpinner();

    public EntityDisplay(@NotNull String rawIdentifier, boolean displayLoadingIfNotValid, InitialSetupMethod initialSetupMethod) {
        this.rawIdentifier = rawIdentifier;
        this.isPlayerItSelf = rawIdentifier.equals("morph:unmorph");
        this.displayName = class_2561.method_43471((String)"gui.morphclient.loading").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
        this.displayLoadingIfInvalid = displayLoadingIfNotValid;
        this.loadingSpinner.setAnchor(Anchor.Centre);
        this.loadingSpinner.setParent(this);
        this.loadingSpinner.setRelativeSizeAxes(Axes.Both);
        this.loadingSpinner.setSize(new class_5611(1.0f, 1.0f));
        switch (initialSetupMethod.ordinal()) {
            case 1: {
                CompletableFuture.runAsync(this::setupEntity);
                break;
            }
            case 2: {
                this.setupEntity();
                break;
            }
        }
    }

    public EntityDisplay(String id) {
        this(id, false, InitialSetupMethod.NONE);
    }

    @Override
    public void invalidatePosition() {
        super.invalidatePosition();
        this.loadingSpinner.invalidatePosition();
    }

    @Nullable
    public class_1309 getDisplayingEntity() {
        return this.displayingEntity;
    }

    public boolean isLiving() {
        return this.isLiving.get();
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    private int getEntityYOffset(class_1309 entity) {
        class_2960 type = class_7923.field_41177.method_10221((Object)entity.method_5864());
        return switch (type.toString()) {
            case "minecraft:ender_dragon" -> -1;
            default -> 0;
        };
    }

    protected int getInitialEntitySize(class_1309 entity) {
        class_2960 type = class_7923.field_41177.method_10221((Object)entity.method_5864());
        return switch (type.toString()) {
            case "minecraft:ender_dragon" -> 3;
            case "minecraft:squid", "minecraft:glow_squid" -> 10;
            case "minecraft:horse", "minecraft:player" -> 8;
            default -> 1;
        };
    }

    public void resetEntity() {
        this.displayingEntity = null;
    }

    public void doSetupImmedately() {
        this.setupEntity();
    }

    private void setupEntity() {
        try {
            this.loadingEntity.set(true);
            EntityCache entityCache = EntityCache.getGlobalCache();
            class_1309 living = entityCache.getEntity(this.rawIdentifier, null);
            this.isLiving.set(entityCache.isLiving(this.rawIdentifier));
            if (living == null) {
                class_746 entity = null;
                if (this.isPlayerItSelf) {
                    entity = class_310.method_1551().field_1724;
                    this.isLiving.set(true);
                }
                if (entity == null) {
                    Runnable complete = () -> {
                        this.displayName = class_2561.method_43470((String)this.rawIdentifier);
                        if (this.postEntitySetup != null) {
                            this.postEntitySetup.run();
                        }
                        this.loadingEntity.set(false);
                    };
                    if (RenderSystem.isOnRenderThread()) {
                        complete.run();
                    } else {
                        this.addSchedule(complete);
                    }
                    return;
                }
                living = entity;
            }
            class_1309 finalLiving = living;
            Runnable onComplete = () -> {
                this.loadingEntity.set(false);
                this.allowRender = true;
                this.displayingEntity = finalLiving;
                this.displayName = finalLiving.method_5476();
                this.initialEntitySize.set(this.getInitialEntitySize(finalLiving));
                this.entityYOffset = this.getEntityYOffset(finalLiving);
                if (this.postEntitySetup != null) {
                    this.postEntitySetup.run();
                }
            };
            if (RenderSystem.isOnRenderThread()) {
                onComplete.run();
            } else {
                this.addSchedule(onComplete);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void renderLoading(class_332 context) {
        this.loadingSpinner.method_25394(context, 0, 0, 0.0f);
    }

    protected float getRenderScale() {
        float scaledMaxEntityBorder = Math.max(this.displayingEntity.method_17681(), this.displayingEntity.method_17682()) * (float)this.initialEntitySize.get();
        int scale = Math.round(Math.min(this.getRenderHeight(), this.getRenderWidth()) * 0.8f / scaledMaxEntityBorder);
        scale = Math.max(1, scale);
        return scale;
    }

    @Override
    protected void onRender(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.displayingEntity == null && this.isLiving()) {
            if (!this.loadingEntity.get()) {
                CompletableFuture.runAsync(this::setupEntity);
            }
            this.renderLoading(context);
            return;
        }
        if (!this.allowRender || !this.isLiving()) {
            if (this.displayLoadingIfInvalid) {
                this.renderLoading(context);
            }
            return;
        }
        try {
            if (this.displayingEntity.method_31481()) {
                this.resetEntity();
                return;
            }
            int scale = 1;
            float scaledMaxEntityBorder = Math.max(this.displayingEntity.method_17681(), this.displayingEntity.method_17682()) * (float)this.initialEntitySize.get();
            scale = Math.round(Math.min(this.getRenderHeight(), this.getRenderWidth()) * 0.8f / scaledMaxEntityBorder);
            scale = Math.max(1, scale);
            int xStart = (int)this.getScreenSpaceX();
            int xEnd = xStart + this.renderWidth;
            int yStart = (int)this.getScreenSpaceY();
            int yEnd = yStart + this.renderHeight;
            context.method_51448().translate((float)(-xStart), (float)(-yStart));
            PlayerRenderHelper.instance().skipRender = true;
            class_490.method_2486((class_332)context, (int)xStart, (int)yStart, (int)xEnd, (int)yEnd, (int)(scale * this.initialEntitySize.get()), (float)(0.0625f + (float)this.entityYOffset), (float)mouseX, (float)mouseY, (class_1309)this.displayingEntity);
            context.method_51448().translate((float)xStart, (float)yStart);
            PlayerRenderHelper.instance().skipRender = false;
        }
        catch (Throwable t) {
            this.allowRender = false;
            LoggerFactory.getLogger((String)"morph").error(t.getMessage());
            t.printStackTrace();
        }
    }

    public static enum InitialSetupMethod {
        NONE,
        ASYNC,
        SYNC;

    }
}

