/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics;

import java.util.Map;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.entities.IDisguiseRenderState;
import xyz.nifeather.morph.client.entities.IMorphClientEntity;
import xyz.nifeather.morph.client.graphics.color.ColorUtils;
import xyz.nifeather.morph.client.graphics.color.MaterialColors;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;

public class EntityRendererHelper {
    private static final Logger log = LoggerFactory.getLogger(EntityRendererHelper.class);
    public static EntityRendererHelper instance;
    public static boolean doRenderRealName;
    private final int textColor = MaterialColors.Orange500.getColor();
    public final int textColorTransparent = ColorUtils.forOpacity(MaterialColors.Orange500, 0.0f).getColor();
    private final class_4587 renderPoseStack = new class_4587();

    public EntityRendererHelper() {
        instance = this;
    }

    @Nullable
    public final Map.Entry<Integer, String> getRevealNameEntry(Integer id) {
        return DisguiseInstanceTracker.getInstance().playerMap.entrySet().stream().filter(set -> id.equals(set.getKey())).findFirst().orElse(null);
    }

    public final void setupEntityState(class_1297 renderingEntity, IDisguiseRenderState renderState) {
        Map.Entry<Integer, String> entrySet;
        renderState.morphclient$setRevealName(null);
        renderState.morphclient$setMasterPosition(null);
        renderState.morphclient$setDisguiseSyncer(null);
        int id = renderingEntity.method_5628();
        class_742 masterEntity = null;
        if (renderingEntity instanceof IMorphClientEntity) {
            IMorphClientEntity iMorphEntity = (IMorphClientEntity)renderingEntity;
            if (iMorphEntity.featherMorph$isDisguiseEntity()) {
                DisguiseSyncer syncer = DisguiseInstanceTracker.getInstance().getSyncerFor(iMorphEntity.featherMorph$getMasterEntityId());
                if (syncer != null) {
                    masterEntity = syncer.getBindingPlayer();
                    id = syncer.getBindingPlayer().method_5628();
                    renderState.morphclient$setDisguiseSyncer(syncer);
                    renderState.morphclient$setMasterPosition(masterEntity.method_73189());
                    syncer.onEntityRenderStateSetup((class_10017)renderState, renderState);
                }
            } else {
                renderState.morphclient$setMasterPosition(renderingEntity.method_73189());
            }
        }
        if ((entrySet = this.getRevealNameEntry(id)) == null) {
            return;
        }
        String revealName = entrySet.getValue();
        String disguiseEntityName = renderingEntity.method_5477().getString();
        String text = "%s(%s)".formatted(disguiseEntityName, revealName);
        renderState.morphclient$setRevealName(text);
    }

    public final void submitRevealName(class_4587 ignored, class_10017 renderState, class_11659 collector, class_12075 cameraRenderState) {
        if (!doRenderRealName) {
            return;
        }
        if (!(renderState instanceof IDisguiseRenderState)) {
            throw new RuntimeException("Given render state is not an instance of IDisguiseRenderState");
        }
        IDisguiseRenderState disguiseRenderState = (IDisguiseRenderState)renderState;
        String revealName = disguiseRenderState.morphclient$getRevealName();
        if (revealName == null) {
            return;
        }
        class_4184 camera = class_310.method_1551().method_1561().field_4686;
        if (camera == null) {
            throw new RuntimeException("Camera is NULL!");
        }
        float tickDelta = class_310.method_1551().method_61966().method_60637(false);
        if (!this.renderPoseStack.method_67795()) {
            throw new RuntimeException("Non-empty PoseStack for submitRevealName");
        }
        this.renderPoseStack.method_22903();
        class_243 anchorPosition = ((IDisguiseRenderState)renderState).morphclient$masterPosition();
        DisguiseSyncer syncer = disguiseRenderState.morphclient$getDisguiseSyncer();
        if (syncer != null) {
            class_742 bindingPlayer = syncer.getBindingPlayer();
            anchorPosition = class_3532.method_61342((double)tickDelta, (class_243)bindingPlayer.method_61411(), (class_243)bindingPlayer.method_73189());
        }
        class_243 labelOffset = EntityRendererHelper.getLabelOffset(renderState);
        class_243 positionDiff = anchorPosition.method_1020(camera.method_71156()).method_1019(labelOffset);
        this.renderPoseStack.method_61958(positionDiff);
        if (FeatherMorphClientBootstrap.getInstance().getModConfigData().scaleNameTag) {
            double distance = camera.method_71156().method_1022(anchorPosition);
            float scale = Math.max(1.0f, (float)distance / 7.5f);
            this.renderPoseStack.method_22905(scale, scale, scale);
        }
        collector.method_73482(this.renderPoseStack, class_243.field_1353, 0, (class_2561)class_2561.method_43470((String)revealName).method_54663(this.textColor), true, 0xF000F0, 0.0, cameraRenderState);
        this.renderPoseStack.method_22909();
    }

    @NotNull
    private static class_243 getLabelOffset(class_10017 renderState) {
        class_243 labelOffset;
        class_243 class_2432 = labelOffset = renderState.field_53338 != null ? renderState.field_53338 : new class_243(0.0, (double)renderState.field_53330, 0.0);
        if (renderState.field_53337 != null) {
            labelOffset = labelOffset.method_1031(0.0, 0.25, 0.0);
        }
        if (renderState instanceof class_10055) {
            class_10055 avatarRenderState = (class_10055)renderState;
            if (avatarRenderState.field_53525 != null && renderState.field_53338 != null) {
                labelOffset = labelOffset.method_1031(0.0, (double)0.25875f, 0.0);
            }
        }
        return labelOffset;
    }

    static {
        doRenderRealName = false;
    }
}

