/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1007;
import net.minecraft.class_11659;
import net.minecraft.class_11901;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1511;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5600;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_625;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_895;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9779;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.Vec3dUtils;
import xyz.nifeather.morph.client.entities.IMorphClientEntity;
import xyz.nifeather.morph.client.graphics.ModelWorkarounds;
import xyz.nifeather.morph.client.mixin.accessors.DragonEntityRendererAccessor;
import xyz.nifeather.morph.client.mixin.accessors.LivingRendererAccessor;
import xyz.nifeather.morph.client.syncers.ClientDisguiseSyncer;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;

public class PlayerRenderHelper
extends MorphClientObject {
    private static PlayerRenderHelper instance;
    private final DisguiseInstanceTracker instanceTracker = DisguiseInstanceTracker.getInstance();
    private boolean doingRender = false;
    @ApiStatus.Internal
    public boolean skipRender = false;
    private boolean allowRender = true;
    public boolean renderingLeftPart;
    private final Map<class_1299<?>, ModelInfo> typeModelPartMap = new Object2ObjectOpenHashMap();
    private final class_1921 dragonLayer = class_1921.method_23578((class_2960)class_2960.method_60654((String)"textures/entity/enderdragon/dragon.png"));

    public static PlayerRenderHelper instance() {
        if (instance == null) {
            instance = new PlayerRenderHelper();
        }
        return instance;
    }

    @Initializer
    private void load(ClientMorphManager morphManager) {
        morphManager.currentIdentifier.onValueChanged((o, n) -> {
            this.allowRender = true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_10017 getState(class_1297 entity, float f, Operation<class_10017> original) {
        Objects.requireNonNull(entity, "Null entity!");
        if (this.doingRender) {
            return (class_10017)original.call(new Object[]{entity, Float.valueOf(f)});
        }
        try {
            if (PlayerRenderHelper.instance().skipRender) {
                class_10017 class_100172 = (class_10017)original.call(new Object[]{entity, Float.valueOf(f)});
                return class_100172;
            }
            if (!(entity instanceof IMorphClientEntity)) {
                class_10017 class_100173 = (class_10017)original.call(new Object[]{entity, Float.valueOf(f)});
                return class_100173;
            }
            IMorphClientEntity iMorphClientEntity = (IMorphClientEntity)entity;
            if (iMorphClientEntity.featherMorph$bypassesDispatcherRedirect()) {
                class_10017 class_100174 = (class_10017)original.call(new Object[]{entity, Float.valueOf(f)});
                return class_100174;
            }
            DisguiseSyncer syncer = DisguiseInstanceTracker.getInstance().getSyncerFor(entity);
            if (syncer == null) {
                class_10017 class_100175 = (class_10017)original.call(new Object[]{entity, Float.valueOf(f)});
                return class_100175;
            }
            class_1309 disguiseInstance = syncer.getDisguiseInstance();
            if (disguiseInstance == null) {
                class_10017 class_100176 = (class_10017)original.call(new Object[]{entity, Float.valueOf(f)});
                return class_100176;
            }
            this.doingRender = true;
            syncer.preRenderStateSetup();
            class_10017 state = (class_10017)original.call(new Object[]{disguiseInstance, Float.valueOf(f)});
            syncer.modifyRenderState(state);
            syncer.postRenderStateSetup();
            class_10017 class_100177 = state;
            return class_100177;
        }
        finally {
            this.doingRender = false;
        }
    }

    private void onRenderException(Exception exception) {
        this.allowRender = false;
        exception.printStackTrace();
        ClientDisguiseSyncer syncer = ClientDisguiseSyncer.getCurrentInstance();
        if (syncer == null) {
            throw new NullDependencyException("Render Exception with null Syncer ?!");
        }
        class_1309 entity = syncer.getDisguiseInstance();
        if (entity != null) {
            try {
                entity.method_5650(class_1297.class_5529.field_26999);
            }
            catch (Exception ee) {
                LoggerFactory.getLogger((String)"MorphClient").error("\u65e0\u6cd5\u79fb\u9664\u5b9e\u4f53\uff1a" + ee.getMessage());
                ee.printStackTrace();
            }
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        assert (clientPlayer != null);
        clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"text.morphclient.error.render_disguise1"), false);
        clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"text.morphclient.error.render_disguise2"), false);
    }

    private class_4184 camera() {
        return class_310.method_1551().field_1773.method_19418();
    }

    public void submitCrystalBeamIfPossible(class_9779 tickCounter, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_11659 submitNodeCollector, int light) {
        DisguiseSyncer abstractSyncer = this.instanceTracker.getSyncerFor((class_1297)class_310.method_1551().field_1724);
        if (!(abstractSyncer instanceof ClientDisguiseSyncer)) {
            return;
        }
        ClientDisguiseSyncer syncer = (ClientDisguiseSyncer)abstractSyncer;
        class_1297 connectedCrystal = syncer.getBeamTarget();
        if (connectedCrystal == null) {
            return;
        }
        matrixStack.method_22903();
        class_243 cameraPos = this.camera().method_19326();
        double cameraX = cameraPos.field_1352;
        double cameraY = cameraPos.field_1351;
        double cameraZ = cameraPos.field_1350;
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        float tickDelta = tickCounter.method_60637(true);
        double lerpPlayerX = class_3532.method_16436((double)tickDelta, (double)player.field_6014, (double)player.method_23317());
        double lerpPlayerY = class_3532.method_16436((double)tickDelta, (double)player.field_6036, (double)player.method_23318());
        double lerpPlayerZ = class_3532.method_16436((double)tickDelta, (double)player.field_5969, (double)player.method_23321());
        float yOffset = 1.0f;
        float relativeX = (float)(connectedCrystal.method_23317() - lerpPlayerX);
        float relativeY = (float)(connectedCrystal.method_23318() - lerpPlayerY) + yOffset;
        float relativeZ = (float)(connectedCrystal.method_23321() - lerpPlayerZ);
        matrixStack.method_22904(lerpPlayerX - cameraX, lerpPlayerY - cameraY - (double)yOffset, lerpPlayerZ - cameraZ);
        class_895.method_3917((float)relativeX, (float)(relativeY + this.getCrystalYOffsetCopy(connectedCrystal, tickDelta)), (float)relativeZ, (float)((float)player.field_6012 + tickDelta), (class_4587)matrixStack, (class_11659)submitNodeCollector, (int)light);
        matrixStack.method_22909();
    }

    private float getCrystalYOffsetCopy(class_1297 entity, float tickDelta) {
        int n;
        if (entity instanceof class_1511) {
            class_1511 endCrystalEntity = (class_1511)entity;
            n = endCrystalEntity.field_7034;
        } else {
            n = 0;
        }
        int age = n;
        float f = (float)age + tickDelta;
        float g = class_3532.method_15374((float)(f * 0.2f)) / 2.0f + 0.5f;
        g = (g * g + g) * 0.4f;
        return g - 1.4f;
    }

    public ModelInfo tryGetModel(class_1299<?> type, @Nullable class_583<?> sourceModel) {
        if (sourceModel == null) {
            return new ModelInfo(null, null, Vec3dUtils.of(0.0), Vec3dUtils.of(1.0));
        }
        ModelInfo map = this.typeModelPartMap.getOrDefault(type, null);
        if (map != null) {
            return map;
        }
        class_630 model = null;
        Map.Entry targetEntry = class_5600.method_32073().entrySet().stream().filter(e -> ((class_5601)e.getKey()).comp_2995().equals((Object)class_1299.method_5890((class_1299)type))).findFirst().orElse(null);
        if (targetEntry != null) {
            model = ((class_5607)targetEntry.getValue()).method_32109();
        }
        class_630 leftPart = null;
        class_630 rightPart = null;
        class_243 offset = Vec3dUtils.of(0.0);
        class_243 scale = Vec3dUtils.ONE();
        if (model != null) {
            List<String> leftPartNames = List.of("left_arm", "left_leg", "left_front_leg", "left_hind_leg", "left_foot", "left_front_foot", "left_hind_foot", "part9");
            List<String> rightPartNames = List.of("right_arm", "right_leg", "right_front_leg", "right_hind_leg", "right_foot", "right_front_foot", "right_hind_foot", "part9");
            if (sourceModel instanceof class_572) {
                class_572 bipedEntityModel = (class_572)sourceModel;
                leftPart = bipedEntityModel.field_27433;
                rightPart = bipedEntityModel.field_3401;
            } else {
                leftPart = this.tryGetChild(model, leftPartNames);
                rightPart = this.tryGetChild(model, rightPartNames);
                ModelWorkarounds.WorkaroundMeta meta = ModelWorkarounds.getInstance().apply(type, leftPart, rightPart);
                offset = meta.offset();
                scale = meta.scale();
            }
        }
        map = new ModelInfo(leftPart, rightPart, offset, scale);
        this.typeModelPartMap.put(type, map);
        return map;
    }

    private class_630 tryGetChild(class_630 modelPart, String childName) {
        return modelPart.method_32088().stream().filter(part -> part.method_41919(childName)).findFirst().map(part -> part.method_32086(childName)).orElse(null);
    }

    private class_630 tryGetChild(class_630 modelPart, List<String> childNames) {
        String s;
        class_630 part = null;
        Iterator<String> iterator = childNames.iterator();
        while (iterator.hasNext() && (part = this.tryGetChild(modelPart, s = iterator.next())) == null) {
        }
        return part;
    }

    public boolean onArmDrawCall(class_4587 matrices, class_11659 submitNodeCollector, int light) {
        if (!this.allowRender) {
            return false;
        }
        try {
            ModelInfo modelInfo;
            class_630 targetArm;
            ClientDisguiseSyncer syncer = ClientDisguiseSyncer.getCurrentInstance();
            if (syncer == null || syncer.disposed()) {
                return false;
            }
            class_1309 disguiseEntity = syncer.getDisguiseInstance();
            if (disguiseEntity == null) {
                return false;
            }
            class_897 disguiseRenderer = class_310.method_1551().method_1561().method_3953((class_1297)disguiseEntity);
            class_1921 renderType = null;
            class_625 model = null;
            if (disguiseRenderer instanceof class_895) {
                class_895 enderDragonEntityRenderer = (class_895)disguiseRenderer;
                model = ((DragonEntityRendererAccessor)enderDragonEntityRenderer).getModel();
                renderType = this.dragonLayer;
            } else if (disguiseRenderer instanceof class_922) {
                class_922 livingEntityRenderer = (class_922)disguiseRenderer;
                model = livingEntityRenderer.method_4038();
                if (disguiseEntity instanceof class_11901) {
                    class_11901 avatar = (class_11901)disguiseEntity;
                    class_1007 renderer = (class_1007)livingEntityRenderer;
                    class_2960 id = avatar.method_52814().comp_1626().comp_3627();
                    if (this.renderingLeftPart) {
                        renderer.method_4221(matrices, submitNodeCollector, light, id, true);
                    } else {
                        renderer.method_4220(matrices, submitNodeCollector, light, id, true);
                    }
                    return true;
                }
                class_10042 renderState = (class_10042)livingEntityRenderer.method_62425((class_1297)disguiseEntity, 0.0f);
                renderType = ((LivingRendererAccessor)livingEntityRenderer).callGetRenderType(renderState, true, false, true);
            }
            if (model != null) {
                model.method_63514();
            }
            if ((targetArm = (modelInfo = this.tryGetModel((class_1299<?>)disguiseEntity.method_5864(), (class_583<?>)model)).getPart(this.renderingLeftPart)) != null) {
                renderType = renderType == null ? class_1921.method_23577() : renderType;
                targetArm.field_3665 = true;
                class_243 scale = modelInfo.scale;
                matrices.method_22905((float)scale.method_10216(), (float)scale.method_10214(), (float)scale.method_10215());
                class_243 offset = modelInfo.offset;
                matrices.method_22904(offset.method_10216(), offset.method_10214(), offset.method_10215());
                light = disguiseEntity.method_5864() == class_1299.field_38384 || disguiseEntity.method_5864() == class_1299.field_6059 ? 0xF000F0 : light;
                targetArm.field_3654 = 0.0f;
                submitNodeCollector.method_73491(targetArm, matrices, renderType, light, class_4608.field_21444, null);
                return true;
            }
        }
        catch (Exception e) {
            this.onRenderException(e);
        }
        return false;
    }

    public record ModelInfo(@Nullable class_630 left, @Nullable class_630 right, class_243 offset, class_243 scale) {
        @Nullable
        public class_630 getPart(boolean isLeftArm) {
            return isLeftArm ? this.left : this.right;
        }
    }
}

