/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.capes.providers;

import com.mojang.authlib.GameProfile;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.client.graphics.capes.ICapeProvider;

public final class KappaCapeProvider
implements ICapeProvider {
    private final ExecutorService capeService = Executors.newFixedThreadPool(3, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("FeatherMorph Cape Worker");
        thread.setUncaughtExceptionHandler((t, error) -> {
            log.info("Error occurred in thread '%s': %s".formatted(t.getName(), error.getMessage()));
            error.printStackTrace();
        });
        return thread;
    });
    private static final Logger log = LoggerFactory.getLogger(KappaCapeProvider.class);
    private final Map<UUID, CompletableFuture<Optional<class_2960>>> onGoingRequests = new ConcurrentHashMap<UUID, CompletableFuture<Optional<class_2960>>>();
    private static final Map<String, class_2960> capes = new HashMap<String, class_2960>();

    private ExecutorService getCapeExecutor() {
        return this.capeService;
    }

    @Override
    public CompletableFuture<Optional<class_2960>> getCapeAsync(GameProfile profile) {
        UUID uuid = profile.id();
        CompletableFuture existingRequest = this.onGoingRequests.getOrDefault(uuid, null);
        if (existingRequest != null) {
            return existingRequest;
        }
        CompletableFuture<Optional<class_2960>> future = CompletableFuture.supplyAsync(() -> this.loadCape(profile), this.getCapeExecutor());
        this.onGoingRequests.put(uuid, future);
        future.thenAccept(optional -> this.onGoingRequests.remove(uuid));
        return future;
    }

    public Optional<class_2960> loadCape(GameProfile profile) {
        class_2960 existingCape = capes.get(profile.name());
        if (existingCape != null) {
            return Optional.of(existingCape);
        }
        class_2960 ofCape = this.tryUrl(profile, "https://optifine.net/capes/" + profile.name() + ".png");
        if (ofCape != null) {
            return Optional.of(ofCape);
        }
        class_2960 sOptifine = this.tryUrl(profile, "http://s.optifine.net/capes/" + profile.name() + ".png");
        return sOptifine == null ? Optional.empty() : Optional.of(sOptifine);
    }

    private class_1011 uncrop(class_1011 in) {
        int srcHeight = in.method_4323();
        int srcWidth = in.method_4307();
        int zoom = (int)Math.ceil((float)in.method_4323() / 32.0f);
        class_1011 out = new class_1011(64 * zoom, 32 * zoom, true);
        for (int x = 0; x < srcWidth; ++x) {
            for (int y = 0; y < srcHeight; ++y) {
                out.method_61941(x, y, in.method_61940(x, y));
            }
        }
        return out;
    }

    @Nullable
    private class_2960 tryUrl(GameProfile player, String targetUrl) {
        try {
            URL url = new URL(targetUrl);
            class_1011 tex = this.uncrop(class_1011.method_4309((InputStream)url.openStream()));
            class_2960 id = CompletableFuture.supplyAsync(() -> {
                class_1043 texture = new class_1043(() -> "cape_tex_" + player.id().toString().toLowerCase().replace("-", "_"), tex);
                class_2960 texID = class_2960.method_60655((String)"kappa", (String)player.id().toString().replace("-", "_"));
                class_310.method_1551().method_1531().method_4616(texID, (class_1044)texture);
                return texID;
            }, (Executor)class_310.method_1551()).join();
            capes.put(player.name(), id);
            return id;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Throwable t) {
            log.info("Error occurred while fetching/processing cape: " + t.getMessage());
            t.printStackTrace();
            return null;
        }
    }

    public KappaCapeProvider() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> capes.clear());
    }
}

