/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.toasts;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5611;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;
import xiamomc.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.EntityDisplay;
import xyz.nifeather.morph.client.graphics.color.MaterialColors;
import xyz.nifeather.morph.client.graphics.toasts.LinedToast;

public class DisguiseEntryToast
extends LinedToast {
    private final String rawIdentifier;
    private final boolean isGrant;
    public static final ConcurrentLinkedQueue<DisguiseEntryToast> instances = new ConcurrentLinkedQueue();
    private final AtomicBoolean isValid = new AtomicBoolean(true);
    private final EntityDisplay entityDisplay;

    public static void invalidateAll() {
        instances.forEach(DisguiseEntryToast::invalidate);
    }

    public void invalidate() {
        this.isValid.set(false);
        instances.remove(this);
    }

    public DisguiseEntryToast(String rawIdentifier, boolean isGrant) {
        this.rawIdentifier = rawIdentifier;
        this.isGrant = isGrant;
        this.entityDisplay = new ToastEntityDisplay(rawIdentifier, true, EntityDisplay.InitialSetupMethod.NONE);
        this.entityDisplay.setX(512);
        this.entityDisplay.setSize(new class_5611(26.0f, 20.0f));
        this.entityDisplay.setMasking(true);
        this.entityDisplay.postEntitySetup = () -> this.setDescription(this.entityDisplay.getDisplayName());
        instances.add(this);
    }

    @Override
    protected boolean fadeInOnEnter() {
        return true;
    }

    @Initializer
    private void load() {
        int x = 4;
        int y = 0;
        switch (this.rawIdentifier) {
            case "minecraft:horse": {
                --x;
                y += 2;
                break;
            }
            case "minecraft:axolotl": {
                --x;
                break;
            }
            case "minecraft:armor_stand": {
                --y;
            }
        }
        this.entityDisplay.setX(x);
        this.entityDisplay.setY(y);
        this.entityDisplay.setAnchor(Anchor.CentreLeft);
        this.entityDisplay.setParentScreenSpace(new class_8030(0, 0, this.method_29049(), this.method_29050()));
        this.setTitle((class_2561)class_2561.method_43471((String)"text.morphclient.toast.disguise_%s".formatted(this.isGrant ? "grant" : "lost")));
        this.setLineColor(this.isGrant ? MaterialColors.Green500 : MaterialColors.Amber500);
        this.visibility.onValueChanged((o, n) -> {
            boolean isHide;
            boolean bl = isHide = n == class_368.class_369.field_2209;
            if (isHide) {
                instances.remove(this);
            }
        }, true);
    }

    @Override
    protected void postBackgroundDrawing(class_332 context, long startTime) {
        Matrix3x2fStack matrices = context.method_51448();
        super.postBackgroundDrawing(context, startTime);
        matrices.pushMatrix();
        matrices.translate(0.0f, 0.5f, (Matrix3x2f)matrices);
        Vector2f pos = new Vector2f(matrices.m20(), matrices.m21());
        int mX = (int)pos.x() - 30;
        int mY = (int)pos.y() + this.method_29050() / 2;
        this.entityDisplay.setParentScreenSpaceX(pos.x);
        this.entityDisplay.setParentScreenSpaceY(pos.y);
        this.entityDisplay.method_25394(context, mX, mY, 0.0f);
        matrices.popMatrix();
    }

    @Override
    public void method_61989(class_374 manager, long startTime) {
        super.method_61989(manager, startTime);
        this.visibility.set(this.isValid.get() ? (class_368.class_369)this.visibility.get() : class_368.class_369.field_2209);
    }

    private static final class ToastEntityDisplay
    extends EntityDisplay {
        public ToastEntityDisplay(String rawIdentifier, boolean displayLoadingIfNotValid, EntityDisplay.InitialSetupMethod initialSetupMethod) {
            super(rawIdentifier, displayLoadingIfNotValid, initialSetupMethod);
        }

        public ToastEntityDisplay(String id) {
            super(id);
        }

        @Override
        protected void updateParentScreenSpace() {
        }
    }
}

