/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.transforms;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_310;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.graphics.transforms.BindableTransform;
import xyz.nifeather.morph.client.graphics.transforms.DelayTransform;
import xyz.nifeather.morph.client.graphics.transforms.GenericTransform;
import xyz.nifeather.morph.client.graphics.transforms.Recorder;
import xyz.nifeather.morph.client.graphics.transforms.Transform;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;

public class Transformer {
    private static long currentTime;
    private static final List<Transform<?>> transforms;

    public static void onClientRenderEnd(class_310 client) {
        currentTime = System.currentTimeMillis();
        ObjectArrayList transformList = new ObjectArrayList(transforms);
        for (Transform t : transformList) {
            if (t.aborted) {
                transforms.remove(t);
                continue;
            }
            double timeProgress = (double)(currentTime - t.startTime) * 1.0 / (double)t.duration;
            t.applyProgress(timeProgress);
            if (timeProgress < 1.0) continue;
            transforms.remove(t);
            if (t.onFinish == null) continue;
            for (Runnable onFinish : t.onFinish) {
                try {
                    onFinish.run();
                }
                catch (Throwable throwable) {
                    FeatherMorphClientBootstrap.LOGGER.warn(throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static synchronized void startTransform(Transform<?> info) {
        transforms.add(info);
    }

    public static <T> GenericTransform<T> transform(Recorder<T> recorder, T endValue, long duration, Easing easing) {
        GenericTransform prevTransform = transforms.stream().filter(t -> {
            if (!(t instanceof GenericTransform)) return false;
            GenericTransform tB = (GenericTransform)t;
            if (tB.val != recorder) return false;
            return true;
        }).findFirst().orElse(null);
        if (prevTransform != null) {
            prevTransform.update(recorder, currentTime, duration, endValue, easing);
            return prevTransform;
        }
        GenericTransform<T> transform = new GenericTransform<T>(recorder, currentTime, duration, endValue, easing);
        Transformer.startTransform(transform);
        return transform;
    }

    public static DelayTransform delay(int duration) {
        DelayTransform transform = new DelayTransform(currentTime, duration);
        Transformer.startTransform(transform);
        return transform;
    }

    public static <T> BindableTransform<T> transform(Bindable<T> bindable, T endValue, long duration, Easing easing) {
        BindableTransform prevTransform = transforms.stream().filter(t -> {
            if (!(t instanceof BindableTransform)) return false;
            BindableTransform tB = (BindableTransform)t;
            if (tB.bindable != bindable) return false;
            return true;
        }).findFirst().orElse(null);
        if (prevTransform != null) {
            prevTransform.update(bindable, currentTime, duration, endValue, easing);
            return prevTransform;
        }
        BindableTransform<T> info = new BindableTransform<T>(bindable, currentTime, duration, endValue, easing);
        Transformer.startTransform(info);
        return info;
    }

    static {
        transforms = new ObjectArrayList();
    }
}

