/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.network;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7260;
import net.minecraft.class_746;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.ClientRequestManager;
import xyz.nifeather.morph.client.ClientSkillHandler;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.config.ModConfigData;
import xyz.nifeather.morph.client.entities.IMorphClientEntity;
import xyz.nifeather.morph.client.entities.IMorphLocalPlayer;
import xyz.nifeather.morph.client.network.LegacyServerHandler;
import xyz.nifeather.morph.client.network.commands.ClientSetEquipCommand;
import xyz.nifeather.morph.client.network.handlers.IProtocolHandler;
import xyz.nifeather.morph.client.network.handlers.V3ProtocolHandler;
import xyz.nifeather.morph.client.network.handlers.record.CommandHandleResult;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;
import xyz.nifeather.morph.client.utilties.NbtHelperCopy;
import xyz.nifeather.morph.client.utilties.NbtUtils;
import xyz.nifeather.morph.network.BasicServerHandler;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestInitialCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SSetSingleOptionCommand;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.CommandRegistriesNew;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.commands.S2C.S2CCommandRecord;
import xyz.nifeather.morph.network.commands.S2C.S2CPlayAnimationCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CReAuthCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSetCurrentCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSwapCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUnAuthCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUpdatePropertiesCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUpdateRequestStatusCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CAddAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CClearAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CRemoveAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CSyncAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRClearCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSetMetaCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSyncRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRUnregisterCommand;
import xyz.nifeather.morph.network.commands.S2C.query.S2CQueryCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAggressiveCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAnimationDisplayNameCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAvailableAnimationsCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetDisplayingFakeEquipCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetFakeEquipCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetMobRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetModifyBoundingBoxCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetProfileCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSNbtCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSelfViewingStatusCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSkillCooldownCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSneakingCommand;
import xyz.nifeather.morph.shared.SharedValues;
import xyz.nifeather.morph.shared.payload.V3MorphCommandPayload;
import xyz.nifeather.morph.shared.payload.V3MorphInitChannelPayload;

public class ServerHandler
extends MorphClientObject
implements BasicServerHandler<class_1657> {
    private final FeatherMorphClientBootstrap client;
    private final CommandRegistriesNew registries = new CommandRegistriesNew();
    private final LegacyServerHandler legacyServerHandler = new LegacyServerHandler(this);
    @Resolved
    private ClientMorphManager morphManager;
    @Resolved
    private DisguiseInstanceTracker instanceTracker;
    @Resolved
    private ModConfigData config;
    @Resolved
    private ClientSkillHandler skillHandler;
    private IProtocolHandler protocolHandler = V3ProtocolHandler.INSTANCE;
    private int serverVersion = -1;
    public static final List<String> clientFeatures = List.of("1_21_3_packetbuf", "equip_property");
    public final Bindable<Boolean> serverReady = new Bindable<Boolean>(false);
    private boolean handshakeReceived;
    private boolean networkInitialized;
    private final AtomicBoolean displaySetToast = new AtomicBoolean();
    public static boolean modifyBoundingBox = false;
    @Resolved
    private ClientRequestManager requestManager;

    public ServerHandler(FeatherMorphClientBootstrap client) {
        this.client = client;
        this.registries.registerS2C("set_current", S2CSetCurrentCommand::fromArguments).registerS2C("reauth", S2CReAuthCommand::fromArguments).registerS2C("unauth", S2CUnAuthCommand::fromArguments).registerS2C("action_swap_hand", S2CSwapCommand::fromArguments).registerS2C("query", S2CQueryCommand::fromArguments);
        this.registries.registerS2C("update_request_status", S2CUpdateRequestStatusCommand::fromArguments);
        this.registries.registerS2C("set_aggressive", S2CSetAggressiveCommand::fromArguments).registerS2C("set_fake_equip", ClientSetEquipCommand::fromArguments).registerS2C("set_displaying_fake_equip", S2CSetDisplayingFakeEquipCommand::fromArguments).registerS2C("set_skin_profile", S2CSetProfileCommand::fromArguments).registerS2C("set_skill_cooldown", S2CSetSkillCooldownCommand::fromArguments).registerS2C("set_nbt", S2CSetSNbtCommand::fromArguments).registerS2C("set_sneaking", S2CSetSneakingCommand::fromArguments).registerS2C("set_clientview_enabled", S2CSetSelfViewingStatusCommand::fromArguments).registerS2C("set_boundingbox_modify_status", S2CSetModifyBoundingBoxCommand::fromArguments);
        this.registries.registerS2C("set_mob_reveal", S2CSetMobRevealCommand::fromArguments);
        this.registries.registerS2C("play_animation", S2CPlayAnimationCommand::fromArguments).registerS2C("set_anim_display", S2CSetAnimationDisplayNameCommand::fromArguments).registerS2C("set_avail_anim", S2CSetAvailableAnimationsCommand::fromArguments);
        this.registries.registerS2C("admin_reveal_sync", S2CSyncAdminRevealCommand::fromArguments).registerS2C("admin_reveal_add", S2CAddAdminRevealCommand::fromArguments).registerS2C("admin_reveal_clear", S2CClearAdminRevealCommand::fromArguments).registerS2C("admin_reveal_remove", S2CRemoveAdminRevealCommand::fromArguments);
        this.registries.registerS2C("cr_add", S2CCRRegisterCommand::fromArguments).registerS2C("cr_clear", S2CCRClearCommand::fromArguments).registerS2C("cr_syncrender", S2CCRSyncRegisterCommand::fromArguments).registerS2C("cr_remove", S2CCRUnregisterCommand::fromArguments).registerS2C("cr_meta", S2CCRSetMetaCommand::fromArguments);
        this.registries.registerS2C("update_properties", S2CUpdatePropertiesCommand::fromArguments);
    }

    public void setProtocolHandler(IProtocolHandler newHandler) {
        this.logger.info("ProtocolHandler set to " + newHandler.getClass().getSimpleName());
        this.protocolHandler = newHandler;
    }

    public IProtocolHandler protocolHandler() {
        return this.protocolHandler;
    }

    public boolean serverReady() {
        return this.serverReady.get();
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public boolean serverApiMatch() {
        return this.getServerVersion() == this.getImplmentingApiVersion();
    }

    public boolean sendCommand(AbstractC2SCommand<?> command) {
        try {
            this.protocolHandler.sendCommand(command);
        }
        catch (Throwable t) {
            this.logger.error("Failed to send command", t);
        }
        return true;
    }

    private void tryProtocols() {
        ClientInitializeRecordV3 initRecord = new ClientInitializeRecordV3(clientFeatures, this.getImplmentingApiVersion(), false);
        V3ProtocolHandler.INSTANCE.sendInitializeRequest(initRecord);
        this.addSchedule(() -> {
            if (this.serverReady.get().booleanValue()) {
                return;
            }
            this.legacyServerHandler.sendInitializeV2(List.of("1_21_3_packetbuf"), this.getImplmentingApiVersion());
        }, 20);
    }

    public void connect() {
        this.resetServerStatus();
        this.setProtocolHandler(V3ProtocolHandler.INSTANCE);
        this.tryProtocols();
    }

    public void disconnect() {
        this.resetServerStatus();
    }

    public int getServerApiVersion() {
        return this.serverVersion;
    }

    public int getImplmentingApiVersion() {
        return Constants.PROTOCOL_VERSION;
    }

    public void resetServerStatus() {
        this.handshakeReceived = false;
        this.morphManager.reset();
        this.updateServerStatus();
        this.instanceTracker.reset();
    }

    public void testSetServerReady() {
        this.serverReady.set(true);
    }

    private void updateServerStatus() {
        this.serverReady.set(this.handshakeReceived);
        this.displaySetToast.set(false);
    }

    public void initializeNetwork() {
        if (this.networkInitialized) {
            throw new RuntimeException("The network has been initialized once!");
        }
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.connect());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.disconnect());
        PayloadTypeRegistry.playC2S().register(V3MorphInitChannelPayload.id, V3MorphInitChannelPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(V3MorphCommandPayload.id, V3MorphCommandPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(V3MorphInitChannelPayload.id, (payload, context) -> {
            ServerHandler.logPacket(false, SharedValues.initializeChannelV3, payload.message());
            this.logger.info("Server is using V3 packets");
            InitializeRespondV3 respond = this.protocolHandler.handleInitializeRespond(payload);
            this.handleServerInitRespond(respond);
        });
        ClientPlayNetworking.registerGlobalReceiver(V3MorphCommandPayload.id, (payload, context) -> {
            ServerHandler.logPacket(false, SharedValues.commandChannelV3, payload.content());
            CommandHandleResult result = this.protocolHandler.handleCommandInput(payload);
            if (!result.success()) {
                return;
            }
            this.handleCommand(result.result());
        });
        this.networkInitialized = true;
    }

    public void handleServerInitRespond(InitializeRespondV3 respond) {
        if (this.serverReady.get().booleanValue()) {
            this.logger.warn("Received init respond while the server is ready?!");
            Thread.dumpStack();
            return;
        }
        this.serverVersion = respond.apiVersion();
        this.logger.info("Server is using command API V" + this.serverVersion);
        this.serverReady.set(true);
        this.handshakeReceived = true;
        this.updateServerStatus();
        this.sendCommand((AbstractC2SCommand<?>)new C2SRequestInitialCommand());
        this.sendCommand((AbstractC2SCommand<?>)new C2SSetSingleOptionCommand(C2SSetSingleOptionCommand.ClientOptionEnum.CLIENTVIEW, this.config.allowClientView));
        this.sendCommand((AbstractC2SCommand<?>)new C2SSetSingleOptionCommand(C2SSetSingleOptionCommand.ClientOptionEnum.HUD, this.config.displayDisguiseOnHud));
    }

    public void handleCommand(S2CCommandRecord commandRecord) {
        try {
            if (!this.serverReady.get().booleanValue() && !commandRecord.commandName().equals("reauth")) {
                if (this.config.verbosePackets) {
                    this.logger.warn("Received command before initialize complete, not processing... ('%s')".formatted(commandRecord.commandName()));
                }
                return;
            }
            String baseName = commandRecord.commandName();
            Map arguments = commandRecord.arguments();
            AbstractS2CCommand cmd = this.registries.createS2CCommand(baseName, arguments);
            if (RenderSystem.isOnRenderThread()) {
                cmd.onCommand((BasicServerHandler)this);
            } else {
                FeatherMorphClientBootstrap.getInstance().schedule(() -> cmd.onCommand((BasicServerHandler)this));
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling server command\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void logPacket(boolean isOutGoingPacket, class_2960 channel, String content) {
        if (!FeatherMorphClientBootstrap.getInstance().getModConfigData().verbosePackets) {
            return;
        }
        String arrow = isOutGoingPacket ? " -> " : " <- ";
        String builder = channel.toString() + arrow + "SERVER :: " + "'%s'".formatted(content);
        FeatherMorphClientBootstrap.LOGGER.info(builder);
    }

    public void onCurrentCommand(S2CSetCurrentCommand s2CCurrentCommand) {
        String id = s2CCurrentCommand.getDisguiseIdentifier();
        this.morphManager.setCurrent(id);
    }

    public void onReAuthCommand(S2CReAuthCommand s2CReAuthCommand) {
        this.disconnect();
        this.connect();
    }

    public void onUnAuthCommand(S2CUnAuthCommand s2CUnAuthCommand) {
        this.disconnect();
    }

    public void onSwapCommand(S2CSwapCommand s2CSwapCommand) {
        this.morphManager.swapHand();
    }

    public void onQueryCommand(S2CQueryCommand s2CQueryCommand) {
        List diff = s2CQueryCommand.getDiff();
        ModConfigData modConfig = FeatherMorphClientBootstrap.getInstance().getModConfigData();
        switch (s2CQueryCommand.queryType()) {
            case ADD: {
                this.morphManager.addDisguises(diff, modConfig.displayGrantRevokeToast);
                break;
            }
            case REMOVE: {
                this.morphManager.removeDisguises(diff, modConfig.displayGrantRevokeToast);
                break;
            }
            case SET: {
                this.morphManager.setDisguises(diff, this.displaySetToast.get() && modConfig.displayQuerySetToast);
                this.displaySetToast.set(true);
            }
        }
    }

    public void onSetAggressiveCommand(S2CSetAggressiveCommand s2CSetAggressiveCommand) {
        boolean aggressive = s2CSetAggressiveCommand.val;
        DisguiseSyncer syncer = this.instanceTracker.getSyncerFor((class_1297)class_310.method_1551().field_1724);
        if (syncer != null) {
            class_1309 instance = syncer.getDisguiseInstance();
            if (instance instanceof class_1571) {
                class_1571 ghast = (class_1571)instance;
                ghast.method_7048(aggressive);
            } else if (instance instanceof class_7260) {
                class_7260 warden = (class_7260)instance;
                if (aggressive) {
                    warden.method_5711((byte)62);
                }
            }
        }
    }

    public void onSetFakeEquipCommand(S2CSetFakeEquipCommand<?> s2CSetEquipCommand) {
        if (this.serverVersion >= Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            this.logger.info("Ignoring %s as the server support a newer protocol".formatted(s2CSetEquipCommand.getClass().getSimpleName()));
            return;
        }
        Object object = s2CSetEquipCommand.getItemStack();
        if (!(object instanceof class_1799)) {
            return;
        }
        class_1799 stack = (class_1799)object;
        switch (s2CSetEquipCommand.getSlot()) {
            case MAINHAND: {
                this.morphManager.setEquip(class_1304.field_6173, stack);
                break;
            }
            case OFF_HAND: {
                this.morphManager.setEquip(class_1304.field_6171, stack);
                break;
            }
            case HELMET: {
                this.morphManager.setEquip(class_1304.field_6169, stack);
                break;
            }
            case CHESTPLATE: {
                this.morphManager.setEquip(class_1304.field_6174, stack);
                break;
            }
            case LEGGINGS: {
                this.morphManager.setEquip(class_1304.field_6172, stack);
                break;
            }
            case BOOTS: {
                this.morphManager.setEquip(class_1304.field_6166, stack);
            }
        }
    }

    public void onSetDisplayingFakeEquipCommand(S2CSetDisplayingFakeEquipCommand s2CSetFakeEquipCommand) {
        if (this.serverVersion >= Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            this.logger.info("Ignoring %s as the server support a newer protocol".formatted(s2CSetFakeEquipCommand.getClass().getSimpleName()));
            return;
        }
        this.morphManager.equipOverriden.set(s2CSetFakeEquipCommand.displaying);
    }

    public void onSetSNbtCommand(S2CSetSNbtCommand s2CSetSNbtCommand) {
        class_2487 nbt = NbtUtils.parseSNbt(s2CSetSNbtCommand.getSNbt());
        if (nbt == null) {
            nbt = new class_2487();
        }
        this.morphManager.currentNbtCompound.set(nbt);
    }

    public void onSetProfileCommand(S2CSetProfileCommand s2CSetProfileCommand) {
        if (this.serverVersion >= Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            this.logger.info("Ignoring %s as the server support a newer protocol".formatted(s2CSetProfileCommand.getClass().getSimpleName()));
            return;
        }
        try {
            class_2487 nbt = NbtUtils.parseOrThrow(s2CSetProfileCommand.getProfileSNbt());
            GameProfile profile = NbtHelperCopy.toGameProfile(nbt);
            if (profile != null) {
                this.client.schedule(() -> this.morphManager.updateSkin(profile));
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed processing S2CSetProfileCommand: " + t.getMessage());
            t.printStackTrace();
        }
    }

    public void onSetSkillCooldownCommand(S2CSetSkillCooldownCommand s2CSetSkillCooldownCommand) {
        this.skillHandler.setSkillCooldown(s2CSetSkillCooldownCommand.val);
    }

    public void onSetSneakingCommand(S2CSetSneakingCommand s2CSetSneakingCommand) {
        IMorphLocalPlayer player;
        IMorphLocalPlayer pl;
        class_746 class_7462 = class_310.method_1551().field_1724;
        IMorphLocalPlayer iMorphLocalPlayer = pl = class_7462 instanceof IMorphLocalPlayer ? (player = (IMorphLocalPlayer)class_7462) : null;
        if (pl == null) {
            return;
        }
        pl.morphclient$overrideSneaking(s2CSetSneakingCommand.sneaking);
    }

    public void onSetSelfViewingCommand(S2CSetSelfViewingStatusCommand s2CSetToggleSelfCommand) {
        boolean enabled = s2CSetToggleSelfCommand.selfViewing();
        this.morphManager.selfVisibleEnabled.set(enabled);
        IMorphClientEntity iEntity = (IMorphClientEntity)class_310.method_1551().field_1724;
        iEntity.featherMorph$requestBypassDispatcherRedirect(this, !enabled);
    }

    public void onSetModifyBoundingBox(S2CSetModifyBoundingBoxCommand s2CSetModifyBoundingBoxCommand) {
        modifyBoundingBox = s2CSetModifyBoundingBoxCommand.getModifyBoundingBox();
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer != null) {
            clientPlayer.method_18382();
        }
    }

    public void onSetRevealing(S2CSetMobRevealCommand command) {
        this.morphManager.revealingValue.set(Float.valueOf(command.getValue()));
    }

    public void onExchangeRequestReceive(S2CUpdateRequestStatusCommand s2CRequestCommand) {
        if (s2CRequestCommand.requestType == S2CUpdateRequestStatusCommand.Type.Unknown) {
            this.logger.warn("Received an invalid exchange request");
        }
        this.requestManager.addRequest(s2CRequestCommand.requestType, s2CRequestCommand.source);
    }

    public void onMapCommand(S2CSyncAdminRevealCommand s2CMapCommand) {
        Map map = s2CMapCommand.getMap();
        this.instanceTracker.playerMap.clear();
        this.instanceTracker.playerMap.putAll(map);
    }

    public void onMapPartialCommand(S2CAddAdminRevealCommand s2CPartialMapCommand) {
        this.instanceTracker.playerMap.putAll(s2CPartialMapCommand.getMap());
    }

    public void onMapClearCommand(S2CClearAdminRevealCommand s2CMapClearCommand) {
        this.instanceTracker.playerMap.clear();
    }

    public void onMapRemoveCommand(S2CRemoveAdminRevealCommand s2CMapRemoveCommand) {
        int id = s2CMapRemoveCommand.getTargetId();
        this.instanceTracker.playerMap.remove(id);
    }

    public void onClientMapSyncCommand(S2CCRSyncRegisterCommand s2CRenderMapSyncCommand) {
        this.instanceTracker.onSyncCommand(s2CRenderMapSyncCommand);
    }

    public void onClientMapAddCommand(S2CCRRegisterCommand s2CRenderMapAddCommand) {
        this.instanceTracker.onAddCommand(s2CRenderMapAddCommand);
    }

    public void onClientMapRemoveCommand(S2CCRUnregisterCommand s2CRenderMapRemoveCommand) {
        this.instanceTracker.onRemoveCommand(s2CRenderMapRemoveCommand);
    }

    public void onClientMapClearCommand(S2CCRClearCommand s2CRenderMapClearCommand) {
        this.instanceTracker.onClearCommand(s2CRenderMapClearCommand);
    }

    public void onClientMapMetaNbtCommand(S2CCRSetMetaCommand s2CRenderMapMetaCommand) {
        this.instanceTracker.onMetaCommand(s2CRenderMapMetaCommand);
    }

    public void onAnimationCommand(S2CPlayAnimationCommand command) {
        this.morphManager.playEmote(command.getAnimId());
    }

    public void onValidAnimationsCommand(S2CSetAvailableAnimationsCommand command) {
        ObjectArrayList cmdList = new ObjectArrayList((Collection)command.getAvailableAnimations());
        cmdList.removeIf(String::isBlank);
        this.morphManager.setEmotes((List<String>)cmdList);
    }

    public void onSetAnimationDisplayCommand(S2CSetAnimationDisplayNameCommand command) {
        this.morphManager.setEmoteDisplay(command.getDisplayIdentifier());
    }

    public void onUpdatePropertiesCommand(S2CUpdatePropertiesCommand command) {
        this.morphManager.handlePropertiesUpdate(command.getProperties());
    }
}

