/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.network.handlers;

import java.util.Arrays;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import xyz.nifeather.fmccl.converter.C2SCommandConverter;
import xyz.nifeather.fmccl.converter.S2CCommandConverter;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCommand;
import xyz.nifeather.fmccl.processor.S2CCommandProcessor;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.network.ServerHandler;
import xyz.nifeather.morph.client.network.handlers.IProtocolHandler;
import xyz.nifeather.morph.client.network.handlers.command.ClientS2CCommandConverter;
import xyz.nifeather.morph.client.network.handlers.command.ClientS2CCommandProcessor;
import xyz.nifeather.morph.client.network.handlers.record.CommandHandleResult;
import xyz.nifeather.morph.client.network.handlers.record.VersionHandleResult;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.commands.S2C.S2CCommandRecord;
import xyz.nifeather.morph.shared.SharedValues;
import xyz.nifeather.morph.shared.payload.V1MorphCommandPayload;
import xyz.nifeather.morph.shared.payload.V1MorphVersionChannelPayload;
import xyz.nifeather.morph.shared.payload.V1V2MorphInitChannelPayload;

public class V1ProtocolHandler
implements IProtocolHandler {
    public static final V1ProtocolHandler INSTANCE = new V1ProtocolHandler();
    private final C2SCommandConverter c2sConverter = new C2SCommandConverter();
    private final S2CCommandConverter s2cConverter = new ClientS2CCommandConverter();
    private final S2CCommandProcessor legacyS2CProcessor = new ClientS2CCommandProcessor();

    @Override
    public void sendCommand(AbstractC2SCommand<?> command) {
        NetheriteC2SCommand netherite = this.c2sConverter.toNetheriteCommand(command);
        String cmd = netherite.buildCommand();
        ServerHandler.logPacket(true, SharedValues.commandChannelV1, cmd);
        ClientPlayNetworking.send((class_8710)new V1MorphCommandPayload(cmd));
    }

    @Override
    public void sendInitializeRequest(ClientInitializeRecordV3 initializeRecordV3) {
        ServerHandler.logPacket(true, SharedValues.initializeChannelV1V2, "<???>");
        ClientPlayNetworking.send((class_8710)new V1V2MorphInitChannelPayload("1_21_3_packetbuf"));
    }

    @Override
    public void sendVersion(int clientVersion) {
        ServerHandler.logPacket(true, SharedValues.versionChannelV1, "<???> " + clientVersion);
        ClientPlayNetworking.send((class_8710)new V1MorphVersionChannelPayload(clientVersion));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InitializeRespondV3 handleInitializeRespond(class_8710 customPayload) {
        String message;
        if (!(customPayload instanceof V1V2MorphInitChannelPayload)) throw new RuntimeException("Given payload is not an instance of V1V2MorphInitChannelPayload");
        V1V2MorphInitChannelPayload v1V2MorphInitChannelPayload = (V1V2MorphInitChannelPayload)customPayload;
        try {
            String string;
            message = string = v1V2MorphInitChannelPayload.message();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return new InitializeRespondV3(Arrays.stream(message.split(" ")).toList(), -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommandHandleResult handleCommandInput(class_8710 customPayload) {
        try {
            if (!(customPayload instanceof V1MorphCommandPayload)) throw new RuntimeException("Given payload is not an instance of V1MorphCommandPayload");
            V1MorphCommandPayload v1MorphCommandPayload = (V1MorphCommandPayload)customPayload;
            try {
                String string;
                String message = string = v1MorphCommandPayload.content();
            }
            catch (Throwable message32) {
                throw new MatchException(message32.toString(), message32);
            }
            NetheriteS2CCommand legacyCommand = this.legacyS2CProcessor.processLegacyCommandLine((String)message32);
            AbstractS2CCommand modern = this.s2cConverter.fromNetheriteCommand(legacyCommand);
            return CommandHandleResult.from(S2CCommandRecord.fromS2CCommand((AbstractS2CCommand)modern));
        }
        catch (Throwable t) {
            FeatherMorphClientBootstrap.LOGGER.error("Failed to handle command from server: %s".formatted(t.getMessage()));
            t.printStackTrace();
            return CommandHandleResult.fail();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VersionHandleResult handleServerVersionInput(class_8710 customPayload) {
        String protocolVersion;
        if (!(customPayload instanceof V1MorphCommandPayload)) throw new RuntimeException("Given payload is not an instance of V2MorphVersionChannelPayload");
        V1MorphCommandPayload v1MorphCommandPayload = (V1MorphCommandPayload)customPayload;
        try {
            String string;
            protocolVersion = string = v1MorphCommandPayload.content();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return VersionHandleResult.from(Integer.parseInt(protocolVersion));
    }
}

