/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.network.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.network.ServerHandler;
import xyz.nifeather.morph.client.network.handlers.IProtocolHandler;
import xyz.nifeather.morph.client.network.handlers.record.CommandHandleResult;
import xyz.nifeather.morph.client.network.handlers.record.VersionHandleResult;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SCommandRecord;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.commands.S2C.S2CCommandRecord;
import xyz.nifeather.morph.shared.SharedValues;
import xyz.nifeather.morph.shared.payload.V3MorphCommandPayload;
import xyz.nifeather.morph.shared.payload.V3MorphInitChannelPayload;

public class V3ProtocolHandler
implements IProtocolHandler {
    public static final V3ProtocolHandler INSTANCE = new V3ProtocolHandler();
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public void sendCommand(AbstractC2SCommand<?> command) {
        C2SCommandRecord record = C2SCommandRecord.fromC2SCommand(command);
        String cmd = this.gson.toJson((Object)record);
        ServerHandler.logPacket(true, SharedValues.commandChannelV3, cmd);
        ClientPlayNetworking.send((class_8710)new V3MorphCommandPayload(cmd));
    }

    @Override
    public void sendInitializeRequest(ClientInitializeRecordV3 initializeRecordV3) {
        String str = this.gson.toJson((Object)initializeRecordV3);
        ServerHandler.logPacket(true, SharedValues.initializeChannelV3, str);
        ClientPlayNetworking.send((class_8710)new V3MorphInitChannelPayload(str));
    }

    @Override
    public void sendVersion(int clientVersion) {
        throw new RuntimeException("V3 protocol does not have a version payload");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InitializeRespondV3 handleInitializeRespond(class_8710 customPayload) {
        String message;
        if (!(customPayload instanceof V3MorphInitChannelPayload)) throw new RuntimeException("Given payload is not an instance of V3MorphInitChannelPayload");
        V3MorphInitChannelPayload v3MorphInitChannelPayload = (V3MorphInitChannelPayload)customPayload;
        try {
            String string;
            message = string = v3MorphInitChannelPayload.message();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return (InitializeRespondV3)this.gson.fromJson(message, InitializeRespondV3.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommandHandleResult handleCommandInput(class_8710 customPayload) {
        String content;
        if (!(customPayload instanceof V3MorphCommandPayload)) {
            FeatherMorphClientBootstrap.LOGGER.error("Can't handle command input: Given payload is not an instance of V3MorphCommandPayload");
            return CommandHandleResult.fail();
        }
        V3MorphCommandPayload v3MorphCommandPayload = (V3MorphCommandPayload)customPayload;
        try {
            String string;
            content = string = v3MorphCommandPayload.content();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        S2CCommandRecord record = (S2CCommandRecord)this.gson.fromJson(content, S2CCommandRecord.class);
        return CommandHandleResult.from(record);
    }

    @Override
    public VersionHandleResult handleServerVersionInput(class_8710 customPayload) {
        throw new RuntimeException("V3 protocol does not have a version payload");
    }
}

