/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.properties;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import xyz.nifeather.morph.client.properties.ClientProperty;

public abstract class AbstractPropertyHandler<E extends class_1297> {
    private final Map<String, ClientProperty<?>> propertyMap = new ConcurrentHashMap();

    public abstract Optional<E> tryCast(class_1297 var1);

    protected void register(ClientProperty<?> ... properties) {
        for (ClientProperty<?> property : properties) {
            this.register(property);
        }
    }

    protected void register(ClientProperty<?> property) {
        this.propertyMap.put(property.identifier, property);
    }

    protected abstract <X> void applyToEntity(E var1, ClientProperty<X> var2, X var3);

    protected boolean acceptNullOptional() {
        return false;
    }

    public final void handle(Map<String, String> input, E entity) {
        input.forEach((key, value) -> {
            ClientProperty clientProperty = this.propertyMap.getOrDefault(key, null);
            if (clientProperty == null) {
                return;
            }
            ClientProperty cast = clientProperty;
            Optional handleResult = cast.handleInput((String)value);
            if (handleResult.isEmpty() && this.acceptNullOptional()) {
                this.applyToEntity(entity, cast, null);
            } else {
                cast.handleInput((String)value).ifPresent(result -> this.applyToEntity(entity, cast, result));
            }
        });
    }
}

