/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.screens.emote;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.DrawableText;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;
import xyz.nifeather.morph.client.network.ServerHandler;
import xyz.nifeather.morph.client.screens.WaitingForServerScreen;
import xyz.nifeather.morph.client.screens.emote.SingleEmoteWidget;
import xyz.nifeather.morph.client.screens.spinner.SpinnerScreen;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestAnimationCommand;

public class EmoteScreen
extends SpinnerScreen<SingleEmoteWidget> {
    private final Bindable<Boolean> serverReady = new Bindable();
    private final DrawableText titleText = new DrawableText();
    private final DrawableText currentAnimText = new DrawableText();
    private final ServerHandler serverHandler;
    @Nullable
    private String emoteName;
    private final ClientMorphManager morphManager;

    @Override
    protected SingleEmoteWidget createWidget() {
        return new SingleEmoteWidget();
    }

    private int getWidgetSize() {
        return 55;
    }

    @Override
    protected int getWidgetWidth() {
        return this.getWidgetSize();
    }

    @Override
    protected int getWidgetHeight() {
        return this.getWidgetSize();
    }

    public EmoteScreen() {
        super((class_2561)class_2561.method_43470((String)"Disguise emote select screen"));
        this.serverHandler = FeatherMorphClientBootstrap.getInstance().serverHandler;
        this.morphManager = FeatherMorphClientBootstrap.getInstance().morphManager;
        this.titleText.setText((class_2561)class_2561.method_43471((String)"gui.morphclient.emote_select"));
        this.titleText.setAnchor(Anchor.TopCentre);
        this.titleText.setDrawShadow(true);
        this.currentAnimText.setAnchor(Anchor.BottomCentre);
        this.currentAnimText.setDrawShadow(true);
        int size = this.getWidgetSize();
        int widgetOffset = size + 5;
        this.addEmoteWidget(0, -widgetOffset * 2).moveTo(new Vector2i(0, -widgetOffset), 300L, Easing.OutExpo);
        this.addEmoteWidget(widgetOffset * 2, 0).moveTo(new Vector2i(widgetOffset, 0), 300L, Easing.OutExpo);
        this.addEmoteWidget(0, widgetOffset * 2).moveTo(new Vector2i(0, widgetOffset), 300L, Easing.OutExpo);
        this.addEmoteWidget(-widgetOffset * 2, 0).moveTo(new Vector2i(-widgetOffset, 0), 300L, Easing.OutExpo);
        ClientMorphManager morphManager = FeatherMorphClientBootstrap.getInstance().morphManager;
        List<String> emotes = morphManager.getEmotes();
        for (int i = 0; i < emotes.size() && i < this.spinnerWidgets.size(); ++i) {
            SingleEmoteWidget widget = (SingleEmoteWidget)this.spinnerWidgets.get(i);
            widget.setEmote(emotes.get(i));
        }
        this.addEmoteWidget(0, 0).setText((class_2561)class_2561.method_43471((String)"gui.back"));
        this.add(this.titleText);
        this.add(this.currentAnimText);
        ServerHandler serverHandler = FeatherMorphClientBootstrap.getInstance().serverHandler;
        this.serverReady.bindTo(serverHandler.serverReady);
        this.serverReady.onValueChanged((o, n) -> FeatherMorphClientBootstrap.getInstance().schedule(() -> {
            if (this.isCurrent() && !n.booleanValue()) {
                this.push(new WaitingForServerScreen(new EmoteScreen()));
            }
        }), true);
        this.updateEmoteText(morphManager.emoteDisplayName);
    }

    private SingleEmoteWidget addEmoteWidget(int x, int y) {
        SingleEmoteWidget widget = (SingleEmoteWidget)this.addSingleWidget(x, y);
        widget.setX(x);
        widget.setY(y);
        widget.onClick(() -> {
            String emote = widget.getEmote();
            if (emote != null) {
                this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SRequestAnimationCommand(emote));
            }
            FeatherMorphClientBootstrap.getInstance().schedule(this::tryClose);
        });
        return widget;
    }

    @Override
    protected void onScreenExit(@Nullable class_437 nextScreen) {
        super.onScreenExit(nextScreen);
        if (nextScreen == null) {
            this.serverReady.unBindFromTarget();
        }
    }

    @Override
    protected void onScreenResize() {
        super.onScreenResize();
        this.titleText.setY((int)Math.round((double)this.field_22790 * 0.07));
        this.currentAnimText.setY(-((int)Math.round((double)this.field_22790 * 0.07)));
    }

    private class_2561 getEmoteText(@Nullable String identifier) {
        if (identifier == null || identifier.equals("vanish") || identifier.equals("none")) {
            return class_2561.method_43471((String)"gui.none");
        }
        return class_2561.method_43471((String)("emote.morphclient." + identifier));
    }

    private void updateEmoteText(@Nullable String identifier) {
        class_2561 text = this.getEmoteText(identifier);
        this.currentAnimText.setText((class_2561)class_2561.method_43469((String)"gui.morphclient.current_emote", (Object[])new Object[]{text}));
    }

    public void method_25393() {
        String managerLast = this.morphManager.emoteDisplayName;
        if (!Objects.equals(this.emoteName, managerLast)) {
            this.emoteName = managerLast;
            this.updateEmoteText(managerLast);
        }
        super.method_25393();
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (FeatherMorphClientBootstrap.getInstance().getEmoteKeyBind().method_1417(keyEvent)) {
            FeatherMorphClientBootstrap.getInstance().schedule(this::tryClose);
        }
        return super.method_25404(keyEvent);
    }

    private void tryClose() {
        if (this.isCurrent()) {
            this.method_25419();
        }
    }
}

