/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.storage.ClientDirectoryStorage;

public abstract class ClientDirectoryJsonBasedStorage<T>
extends MorphClientObject {
    protected final ClientDirectoryStorage clientDirectoryStorage;
    protected final Gson gson;
    private final Map<String, T> instancesMap = new ConcurrentHashMap<String, T>();
    private final AtomicInteger packageVersion = new AtomicInteger(-3);

    public abstract T getDefault();

    protected Gson createGson() {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().disableHtmlEscaping().create();
    }

    protected ClientDirectoryJsonBasedStorage(String dirBaseName) {
        this.clientDirectoryStorage = new ClientDirectoryStorage(dirBaseName);
        this.gson = this.createGson();
        if (this.clientDirectoryStorage.initializeFailed()) {
            this.logger.warn("Failed initializing directory storage, please see errors above.");
        }
    }

    protected Map<String, T> instanceMap() {
        return this.instancesMap;
    }

    public void clearCache() {
        this.instancesMap.clear();
    }

    public void setPackageVersion(int version) {
        if (version == -3) {
            throw new IllegalArgumentException("Cannot set package version to -3");
        }
        File file = this.clientDirectoryStorage.getFile("package_version.txt", true);
        this.packageVersion.set(version);
        if (file == null) {
            this.logger.warn("Can't write package version to file, it will not be saved across sessions.");
            return;
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)("" + version), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            this.logger.warn("Can't write package version to file, it will not be saved across sessions: " + t.getMessage());
        }
    }

    public int getPackageVersion() {
        if (this.packageVersion.get() != -3) {
            return this.packageVersion.get();
        }
        File file = this.clientDirectoryStorage.getFile("package_version.txt", false);
        if (file == null) {
            return -1;
        }
        try {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            int version = Integer.parseInt(content);
            this.packageVersion.set(version);
            return version;
        }
        catch (Throwable t) {
            this.logger.error("Can't get package version: " + t.getMessage());
            t.printStackTrace();
            return -1;
        }
    }

    @Nullable
    public String getPath(String key) {
        return key.replace(":", "/").replaceAll("[^a-zA-Z0-9\\-]]", "_");
    }

    @Nullable
    public String getKeyFromFile(File file) {
        File root = this.clientDirectoryStorage.getRootDirectory();
        String rootUri = root.getPath();
        String fileUri = file.toPath().toUri().getPath();
        if (!fileUri.startsWith(rootUri)) {
            this.logger.error("Trying to access a file that does not belongs to this storage: %s".formatted(file.toURI()));
            return null;
        }
        String relativePath = fileUri.replace(rootUri, "");
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.replaceFirst("/", "");
        }
        int dotIndex = relativePath.lastIndexOf(".");
        return relativePath.substring(0, dotIndex).replaceFirst("/", ":");
    }

    @Nullable
    public T loadFrom(@Nullable File file) {
        Object obj;
        if (file == null) {
            return null;
        }
        if (!file.canRead()) {
            this.logger.warn("The file '%s' cannnot be read.".formatted(file.getPath()));
            return null;
        }
        try (InputStreamReader fileStream = new InputStreamReader(new FileInputStream(file));){
            obj = this.gson.fromJson((Reader)fileStream, this.getDefault().getClass());
        }
        catch (Throwable t) {
            this.logger.warn("Can't convert from JSON: " + t.getMessage());
            return null;
        }
        return (T)(obj == null ? null : obj);
    }

    public File getFile(String key) {
        return this.clientDirectoryStorage.getFile(key + ".json", false);
    }

    @Nullable
    public T get(String key) {
        T cached = this.instancesMap.getOrDefault(key = this.getPath(key), null);
        if (cached != null) {
            return cached == this.getDefault() ? null : cached;
        }
        File file = this.getFile(key);
        T obj = this.loadFrom(file);
        if (obj == null) {
            obj = this.getDefault();
        }
        this.instancesMap.put(key, obj);
        return obj;
    }
}

