/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.storage;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import xyz.nifeather.morph.client.storage.ClientDirectoryJsonBasedStorage;
import xyz.nifeather.morph.client.storage.struct.SavedDisguise;

public class SavedDisguiseStorage
extends ClientDirectoryJsonBasedStorage<SavedDisguise> {
    private final List<String> cachedIDs = Collections.synchronizedList(new ObjectArrayList());

    public SavedDisguiseStorage() {
        super("saved_disguises");
    }

    @Override
    public SavedDisguise getDefault() {
        return new SavedDisguise("minecraft:allay", Map.of());
    }

    public void refresh() {
        this.clearCache();
        for (File file : this.clientDirectoryStorage.getFiles()) {
            String key = this.getKeyFromFile(file);
            this.cachedIDs.add(key);
        }
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.cachedIDs.clear();
    }

    public boolean save(SavedDisguise savedDisguise, String id) {
        String path = this.getPath(id) + ".json";
        File file = this.clientDirectoryStorage.getFile(path, true);
        if (file == null) {
            this.logger.error("Can't create storage file at '%s' for unknown reason".formatted(path));
            return false;
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)savedDisguise.asJsonString(), (Charset)StandardCharsets.UTF_8);
            this.cachedIDs.add(id);
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Can't write content to file", t);
            return false;
        }
    }

    public boolean drop(String id) {
        File file = this.getFile(id);
        if (!file.exists()) {
            return false;
        }
        if (file.delete()) {
            this.cachedIDs.remove(id);
            return true;
        }
        return false;
    }

    public List<String> listAll() {
        return List.copyOf(this.cachedIDs);
    }
}

