/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.utilties;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;

public class EntityCacheUtils {
    private static final Map<Object, Consumer<class_1297>> onRemove = new Object2ObjectOpenHashMap();
    private static final Map<Object, Consumer<class_1297>> onAdd = new Object2ObjectOpenHashMap();

    public static void postEntityRemove(class_1297 entity) {
        onRemove.forEach((obj, consumer) -> {
            try {
                consumer.accept(entity);
            }
            catch (Throwable t) {
                FeatherMorphClientBootstrap.LOGGER.error("Error occurred while processing postEntityRemove hook '%s': %s".formatted(consumer, t));
                t.printStackTrace();
            }
        });
    }

    public static void addOnEntityRemoveHook(Object obj, Consumer<class_1297> consumer) {
        onRemove.put(obj, consumer);
    }

    public static void removeOnEntityRemoveHook(Object object) {
        onRemove.remove(object);
    }

    public static void onEntityAdd(class_1297 entity) {
        onAdd.forEach((obj, consumer) -> {
            try {
                consumer.accept(entity);
            }
            catch (Throwable t) {
                FeatherMorphClientBootstrap.LOGGER.error("Error occurred while processing onEntityAdd hook '%s': %s".formatted(consumer, t));
                t.printStackTrace();
            }
        });
    }

    public static void addOnEntityAddHook(Object obj, Consumer<class_1297> consumer) {
        onRemove.put(obj, consumer);
    }

    public static void removeOnEntityAddHook(Object object) {
        onRemove.remove(object);
    }
}

