/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.utilties;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import me.shedaniel.math.Color;
import org.apache.commons.lang3.NotImplementedException;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;

public class TransformUtils {
    public static <TValue> TValue valueAt(double progress, TValue startVal, TValue endVal, Easing easing) {
        return ValueTransformer.create(progress, startVal, endVal, easing);
    }

    private static class ValueTransformer {
        private static final Map<Class<?>, Method> clazzMethodMap = new Object2ObjectArrayMap();

        private ValueTransformer() {
        }

        public static Double valueAt(double progress, double startVal, double endVal, Easing easing) {
            if (startVal == endVal) {
                return endVal;
            }
            if (progress <= 0.0) {
                return startVal;
            }
            if (progress >= 1.0) {
                return endVal;
            }
            return startVal + (endVal - startVal) * easing.getImpl().apply(progress);
        }

        public static Float valueAt(double progress, float startVal, float endVal, Easing easing) {
            return Float.valueOf(ValueTransformer.valueAt(progress, (double)startVal, (double)endVal, easing).floatValue());
        }

        public static Long valueAt(double progress, long startVal, long endVal, Easing easing) {
            return Math.round(ValueTransformer.valueAt(progress, (double)startVal, (double)endVal, easing));
        }

        public static Integer valueAt(double progress, int startVal, int endVal, Easing easing) {
            return (int)Math.round(ValueTransformer.valueAt(progress, (double)startVal, (double)endVal, easing));
        }

        public static Short valueAt(double progress, short startVal, short endVal, Easing easing) {
            return (short)Math.round(ValueTransformer.valueAt(progress, (double)startVal, (double)endVal, easing));
        }

        public static Color valueAt(double progress, Color startVal, Color endVal, Easing easing) {
            if (startVal.equals((Object)endVal)) {
                return endVal;
            }
            if (progress <= 0.0) {
                return startVal;
            }
            if (progress >= 1.0) {
                return endVal;
            }
            Integer r = ValueTransformer.valueAt(progress, startVal.getRed(), endVal.getRed(), easing);
            Integer g = ValueTransformer.valueAt(progress, startVal.getGreen(), endVal.getGreen(), easing);
            Integer b = ValueTransformer.valueAt(progress, startVal.getBlue(), endVal.getBlue(), easing);
            Integer alphaProgress = ValueTransformer.valueAt(progress, startVal.getAlpha(), endVal.getAlpha(), easing);
            Color rawColor = Color.ofRGBA((int)r, (int)g, (int)b, (int)alphaProgress);
            return Color.ofRGBA((int)rawColor.getRed(), (int)rawColor.getGreen(), (int)rawColor.getBlue(), (int)alphaProgress);
        }

        public static <TValue> TValue create(double progress, TValue startVal, TValue endVal, Easing easing) {
            Class<?> valType = startVal.getClass();
            Method method = clazzMethodMap.get(valType);
            if (method == null) {
                Method mm = Arrays.stream(ValueTransformer.class.getMethods()).filter(m -> m.getReturnType() == valType && m.getName().equalsIgnoreCase("valueAt")).findFirst().orElse(null);
                clazzMethodMap.put(valType, mm);
                method = mm;
            }
            if (method == null) {
                throw new NotImplementedException("No such transform method for type " + String.valueOf(startVal.getClass()));
            }
            try {
                return (TValue)method.invoke(null, new Object[]{progress, startVal, endVal, easing});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

