/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xiamomc.pluginbase.XiaMoJavaPlugin;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.server.MorphServerLoader;
import xyz.nifeather.morph.server.commands.CommandHub;
import xyz.nifeather.morph.server.commands.CommandRegistrationContext;
import xyz.nifeather.morph.server.events.CommonEventProcessor;
import xyz.nifeather.morph.server.morphs.MorphManager;
import xyz.nifeather.morph.server.network.ClientHandler;
import xyz.nifeather.morph.shared.payload.V3MorphCommandPayload;
import xyz.nifeather.morph.shared.payload.V3MorphInitChannelPayload;

public class FeatherMorphMain
extends XiaMoJavaPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FeatherMorph$Server");
    @Nullable
    private Runnable mainLoop;
    public ClientHandler clientHandler;
    public MorphManager morphManager;
    @Nullable
    private File dataFolder;
    private CommandHub commandHub;
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    public static String pluginNamespace() {
        return "feathermorph_fabric_main";
    }

    @Override
    public String namespace() {
        return FeatherMorphMain.pluginNamespace();
    }

    @Override
    protected Logger getSLF4JLogger() {
        return LOGGER;
    }

    @Override
    public void startMainLoop(Runnable r) {
        this.logger.info("START MAIN LOOP!");
        this.mainLoop = r;
    }

    @Override
    public void runAsync(Runnable r) {
        class_156.method_18349().execute(r);
    }

    @Override
    protected void enable() {
        ServerPlayNetworking.registerGlobalReceiver(V3MorphInitChannelPayload.id, this::onInitPayload);
        ServerPlayNetworking.registerGlobalReceiver(V3MorphCommandPayload.id, this::onPlayCommandPayload);
        this.morphManager = new MorphManager();
        this.dependencyManager.cache(this.morphManager);
        this.clientHandler = new ClientHandler();
        this.dependencyManager.cache(this.clientHandler);
        CommonEventProcessor events = new CommonEventProcessor();
        events.initListener();
        this.commandHub = new CommandHub();
    }

    @Override
    protected void disable() {
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)V3MorphInitChannelPayload.id.comp_2242());
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)V3MorphCommandPayload.id.comp_2242());
        this.morphManager.dispose();
    }

    @Override
    @NotNull
    public File getDataFolder() {
        if (this.dataFolder == null) {
            class_3218 serverWorld = MorphServerLoader.mcserver.method_30002();
            File dataFile = new File(serverWorld.method_8503().method_27050(class_5218.field_24188).toFile(), "data");
            this.dataFolder = new File(dataFile, "feathermorph-fabric");
        }
        return this.dataFolder;
    }

    public void onCommandRegister(CommandRegistrationContext context) {
        if (this.commandHub != null) {
            this.commandHub.registerCommands(context);
        } else {
            LOGGER.warn("NULL commandHub?! This shouldn't happen!");
        }
    }

    private void onPlayCommandPayload(V3MorphCommandPayload morphCommandPayload, ServerPlayNetworking.Context context) {
        this.clientHandler.onCommandPayload(morphCommandPayload, context);
    }

    private void onInitPayload(V3MorphInitChannelPayload packet, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        LOGGER.info("On init payload! from " + String.valueOf(player));
        InitializeRespondV3 respond = new InitializeRespondV3(List.of("1_21_3_packetbuf"), Constants.PROTOCOL_VERSION);
        V3MorphInitChannelPayload payload = new V3MorphInitChannelPayload(this.gson.toJson((Object)respond));
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public void tick(MinecraftServer tickingServer) {
        if (this.mainLoop != null) {
            this.mainLoop.run();
        }
    }
}

