/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.server.FeatherMorphMain;
import xyz.nifeather.morph.server.commands.CommandRegistrationContext;
import xyz.nifeather.morph.shared.SharedValues;
import xyz.nifeather.morph.shared.platform.Services;

public class MorphServerLoader {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"FeatherMorph$MorphServerLoader");
    @Nullable
    public static MinecraftServer mcserver;
    @Nullable
    private CommandRegistrationContext registrationContext;
    @Nullable
    private FeatherMorphMain main;

    public void onModLoad() {
        Services.PLATFORM.registerServerStoppingEvent(this::onServerStop);
        Services.PLATFORM.registerWorldLoadEvent(this::onServerStart);
        Services.PLATFORM.registerCommandRegistrationEvent(this::onCommandRegister);
        Services.PLATFORM.registerServerStartTickEvent(class_2960.method_60655((String)"feathermorph_fabric_server", (String)"server_tick"), this::onServerTick);
    }

    public void onCommandRegister(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LOGGER.info("Caching CommandRegistrationContext as we register commands later.");
        this.registrationContext = new CommandRegistrationContext(dispatcher, registryAccess, environment);
    }

    private void onServerStart(MinecraftServer startingServer, class_3218 world) {
        if (mcserver == startingServer) {
            return;
        }
        mcserver = startingServer;
        if (!SharedValues.allowSinglePlayerDebugging) {
            LOGGER.error("SinglePlayer debug is disabled.");
            return;
        }
        FeatherMorphMain newInstance = new FeatherMorphMain();
        newInstance.enablePlugin();
        if (this.registrationContext != null) {
            newInstance.onCommandRegister(this.registrationContext);
        }
        this.registrationContext = null;
        this.main = newInstance;
    }

    private void onServerTick(MinecraftServer minecraftServer) {
        if (this.main != null) {
            this.main.tick(minecraftServer);
        }
    }

    private void onServerStop(MinecraftServer mcServer) {
        if (this.main != null) {
            this.main.disablePlugin();
        }
        this.main = null;
        mcserver = null;
    }
}

