/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.commands.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import xiamomc.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.server.FeatherMorphMain;
import xyz.nifeather.morph.server.disguise.providers.AbstractDisguiseProvider;
import xyz.nifeather.morph.server.morphs.MorphManager;

public class DisguiseIdentifierSuggestions {
    public static CompletableFuture<Suggestions> forInputPlayer(CommandContext<class_2168> context, SuggestionsBuilder builder, String playerArgumentName) throws CommandSyntaxException {
        DependencyManager dependencies = DependencyManager.getInstance(FeatherMorphMain.pluginNamespace());
        if (dependencies == null) {
            return builder.buildFuture();
        }
        MorphManager morphManager = dependencies.get(MorphManager.class, false);
        if (morphManager == null) {
            return builder.buildFuture();
        }
        class_3222 player = class_2186.method_9315(context, (String)playerArgumentName);
        List<String> availableDisguises = morphManager.getUnlockedDisguiseIds((class_1657)player);
        String input = builder.getRemainingLowerCase();
        return CompletableFuture.supplyAsync(() -> {
            for (String identifier : availableDisguises) {
                if (!identifier.contains(input)) continue;
                builder.suggest(identifier);
            }
            return builder.build();
        });
    }

    public static <S> CompletableFuture<Suggestions> forPlayer(CommandContext<S> context, SuggestionsBuilder builder) {
        DependencyManager dependencies = DependencyManager.getInstance(FeatherMorphMain.pluginNamespace());
        if (dependencies == null) {
            return builder.buildFuture();
        }
        MorphManager morphManager = dependencies.get(MorphManager.class, false);
        if (morphManager == null) {
            return builder.buildFuture();
        }
        Object source = context.getSource();
        class_3222 player = null;
        if (source instanceof class_2168) {
            class_2168 serverCommandSource = (class_2168)source;
            player = serverCommandSource.method_44023();
        }
        if (player == null) {
            return builder.buildFuture();
        }
        String input = builder.getRemainingLowerCase();
        List<String> availableDisguises = morphManager.getUnlockedDisguiseIds((class_1657)player);
        return CompletableFuture.supplyAsync(() -> {
            for (String identifier : availableDisguises) {
                if (!identifier.contains(input)) continue;
                builder.suggest(identifier);
            }
            return builder.build();
        });
    }

    public static <S> CompletableFuture<Suggestions> allAvailable(CommandContext<S> context, SuggestionsBuilder builder) {
        DependencyManager dependencies = DependencyManager.getInstance(FeatherMorphMain.pluginNamespace());
        if (dependencies == null) {
            return builder.buildFuture();
        }
        MorphManager morphManager = dependencies.get(MorphManager.class, false);
        if (morphManager == null) {
            return builder.buildFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            String input = builder.getRemainingLowerCase();
            for (AbstractDisguiseProvider p : morphManager.listProviders()) {
                if (p.namespace().equals("fallback")) continue;
                String providerNamespace = p.namespace();
                p.availableDisguises().forEach(path -> {
                    String id = providerNamespace + ":" + path;
                    if (id.toLowerCase().contains(input)) {
                        builder.suggest(id);
                    }
                });
                builder.suggest(providerNamespace + ":@all");
            }
            return builder.build();
        });
    }
}

