/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.disguise.animations;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import xyz.nifeather.morph.server.ServerPluginObject;
import xyz.nifeather.morph.server.disguise.animations.AnimationSet;
import xyz.nifeather.morph.server.disguise.animations.SingleAnimation;

public class AnimationSequence
extends ServerPluginObject {
    private final List<SingleAnimation> currentQueue = Collections.synchronizedList(new ObjectArrayList());
    private final AtomicReference<String> currentAnimationSequenceName = new AtomicReference<String>("none");
    @Nullable
    private Pair<String, List<SingleAnimation>> nextQueue;
    @Nullable
    private Pair<Long, SingleAnimation> currentAnimation;
    private int cooldown;
    private int workingCooldown;
    private Consumer<SingleAnimation> hookOnNewAnimation;
    private Consumer<String> hookOnNewAnimationSequence;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public void setCooldown(int cd) {
        this.cooldown = cd;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    @NotNull
    public String getCurrentAnimationSequenceName() {
        return this.currentAnimationSequenceName.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleNext(String sequenceIdentifier, List<SingleAnimation> animations) {
        AnimationSequence animationSequence = this;
        synchronized (animationSequence) {
            this.nextQueue = new Pair((Object)sequenceIdentifier, (Object)new ObjectArrayList(animations));
        }
    }

    public void reset() {
        this.currentQueue.clear();
        this.currentAnimation = null;
        this.currentAnimationSequenceName.set("none");
        this.hookOnNewAnimation.accept(AnimationSet.RESET);
    }

    private void findNextAnimation() {
        this.currentAnimation = null;
        if (this.currentQueue.isEmpty()) {
            return;
        }
        SingleAnimation current = this.currentQueue.removeFirst();
        this.currentAnimation = new Pair((Object)this.plugin.getCurrentTick(), (Object)current);
        if (this.hookOnNewAnimation != null) {
            this.hookOnNewAnimation.accept(current);
        }
    }

    public void update() {
        if (this.disposed.get()) {
            return;
        }
        --this.workingCooldown;
        if (this.workingCooldown > 0) {
            return;
        }
        if (this.currentQueue.isEmpty() && this.currentAnimation == null && !this.tryNextQueue()) {
            return;
        }
        if (this.currentAnimation == null) {
            this.findNextAnimation();
            if (this.currentAnimation == null) {
                return;
            }
        }
        if (this.plugin.getCurrentTick() - (Long)this.currentAnimation.getA() >= (long)((SingleAnimation)this.currentAnimation.getB()).duration()) {
            this.currentAnimation = null;
            if (this.currentQueue.isEmpty()) {
                if (this.hookOnNewAnimationSequence != null) {
                    this.hookOnNewAnimationSequence.accept("none");
                }
                this.workingCooldown = this.cooldown;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryNextQueue() {
        this.currentAnimationSequenceName.set("none");
        if (this.nextQueue == null) {
            return false;
        }
        this.logger.info("Next queue is " + String.valueOf(this.nextQueue));
        AnimationSequence animationSequence = this;
        synchronized (animationSequence) {
            this.currentQueue.addAll((Collection)this.nextQueue.getB());
            this.logger.info("Load queue! current is " + String.valueOf(this.currentQueue));
            if (this.hookOnNewAnimationSequence != null) {
                this.hookOnNewAnimationSequence.accept((String)this.nextQueue.getA());
            }
            this.currentAnimationSequenceName.set((String)this.nextQueue.getA());
            this.nextQueue = null;
        }
        return true;
    }

    public void onNewAnimationSequence(Consumer<String> consumer) {
        this.hookOnNewAnimationSequence = consumer;
    }

    public void onNewAnimation(Consumer<SingleAnimation> consumer) {
        this.hookOnNewAnimation = consumer;
    }

    public void dispose() {
        this.disposed.set(true);
        this.currentQueue.clear();
    }
}

