/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.disguise.providers;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.server.MorphServerLoader;
import xyz.nifeather.morph.server.disguise.animations.provider.VanillaAnimationProvider;
import xyz.nifeather.morph.server.disguise.providers.AbstractDisguiseProvider;
import xyz.nifeather.morph.server.morphs.DisguiseSession;

public class VanillaDisguiseProvider
extends AbstractDisguiseProvider {
    private final List<String> availableIdentifiers;
    private final VanillaAnimationProvider animationProvider = new VanillaAnimationProvider();

    @Override
    public String namespace() {
        return "minecraft";
    }

    @Override
    public boolean isValid(String identifier) {
        class_2960 asIdentifier = class_2960.method_12829((String)identifier);
        if (asIdentifier == null) {
            return false;
        }
        return this.availableIdentifiers.contains(asIdentifier.method_12832());
    }

    public VanillaDisguiseProvider() {
        MinecraftServer server = MorphServerLoader.mcserver;
        assert (server != null);
        Optional entityTypes = server.method_30611().method_46759(class_7923.field_41177.method_46765());
        this.logger.info("Loading vanilla disguise identifiers...");
        class_2338 spawnPos = new class_2338(0, 2048, 0);
        ObjectArrayList list = new ObjectArrayList();
        ((class_2378)entityTypes.orElseThrow()).forEach(eT -> {
            class_1297 entity = eT.method_47821(server.method_30002(), spawnPos, class_3730.field_16462);
            if (!(entity instanceof class_1309)) {
                if (entity != null) {
                    entity.method_31472();
                }
                return;
            }
            entity.method_31472();
            list.add((Object)class_1299.method_5890((class_1299)eT).method_12832());
        });
        this.availableIdentifiers = new ObjectImmutableList((ObjectList)list);
        this.logger.info("Loaded %s vanilla disguise identifiers".formatted(list.size()));
    }

    @Override
    public List<String> availableDisguises() {
        return this.availableIdentifiers;
    }

    @Override
    public boolean disguise(class_1657 player, String disguiseIdentifier) {
        return false;
    }

    @Override
    public void onPostConstructDisguise(DisguiseSession state, @Nullable class_1297 targetEntity) {
    }

    @Override
    public boolean unDisguise(class_1657 player) {
        return true;
    }

    @Override
    public boolean updateDisguise(class_1657 player, DisguiseSession disguiseSession) {
        return true;
    }

    @Override
    public void onDisguiseApplied(DisguiseSession disguiseSession) {
    }

    @Override
    public class_2561 getDisplayName(String disguiseIdentifier) {
        class_1299 entityType = class_1299.method_5898((String)disguiseIdentifier).orElse(null);
        if (entityType == null) {
            return class_2561.method_30163((String)"???(%s)".formatted(disguiseIdentifier));
        }
        return class_2561.method_43471((String)entityType.method_5882());
    }

    @Override
    public VanillaAnimationProvider getAnimationProvider() {
        return this.animationProvider;
    }
}

