/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.network.BasicClientHandler;
import xyz.nifeather.morph.network.InitializeState;
import xyz.nifeather.morph.network.PlayerOptions;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SActivateSkillCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SCommandRecord;
import xyz.nifeather.morph.network.commands.C2S.C2SExchangeRequestManagementCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SMorphCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestAnimationCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestInitialCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SSetSingleOptionCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SToggleSelfCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SUnmorphCommand;
import xyz.nifeather.morph.network.commands.CommandRegistriesNew;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CCommandRecord;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CAddAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSyncRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.query.QueryType;
import xyz.nifeather.morph.network.commands.S2C.query.S2CQueryCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSelfViewingStatusCommand;
import xyz.nifeather.morph.server.ServerPluginObject;
import xyz.nifeather.morph.server.disguise.animations.AnimationProvider;
import xyz.nifeather.morph.server.disguise.animations.SingleAnimation;
import xyz.nifeather.morph.server.morphs.DisguiseSession;
import xyz.nifeather.morph.server.morphs.MorphManager;
import xyz.nifeather.morph.shared.payload.V3MorphCommandPayload;

public class ClientHandler
extends ServerPluginObject
implements BasicClientHandler<class_3222> {
    private final CommandRegistriesNew commandRegistries = new CommandRegistriesNew();
    private final Bindable<Boolean> logInComingPackets = new Bindable<Boolean>(true);
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphManager;

    public ClientHandler() {
        this.commandRegistries.registerC2S("request_initial", C2SRequestInitialCommand::fromArguments).registerC2S("morph", C2SMorphCommand::fromArguments).registerC2S("skill", C2SActivateSkillCommand::fromArguments).registerC2S("set_single_option", C2SSetSingleOptionCommand::fromArguments).registerC2S("set_selfview_mode", C2SToggleSelfCommand::fromArguments).registerC2S("unmorph", C2SUnmorphCommand::fromArguments).registerC2S("manage_request", C2SExchangeRequestManagementCommand::fromArguments).registerC2S("request_animation", C2SRequestAnimationCommand::fromArguments);
    }

    private void logPacket(boolean isOutGoingPacket, class_3222 player, String channel, String data, int size) {
        String arrow = isOutGoingPacket ? " -> " : " <- ";
        String builder = channel + arrow + player.method_5477().method_54160() + " :: " + "'%s'".formatted(data) + " (\u2248 %s bytes)".formatted(size);
        this.logger.info(builder);
    }

    public void onCommandPayload(V3MorphCommandPayload morphCommandPayload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        String input = morphCommandPayload.content();
        if (this.logInComingPackets.get().booleanValue()) {
            this.logPacket(false, player, morphCommandPayload.method_56479().comp_2242().toString(), input, input.length());
        }
        try {
            C2SCommandRecord record = (C2SCommandRecord)this.gson.fromJson(input, C2SCommandRecord.class);
            AbstractC2SCommand command = this.commandRegistries.createC2SCommand(record.commandName(), record.arguments());
            command.setOwner((Object)player);
            command.onCommand((BasicClientHandler)this);
        }
        catch (Throwable t) {
            this.logger.error("Failed to handle client command '%s': %s".formatted(input, t.getMessage()));
            this.logger.error("Disconnecting player " + player.method_5820());
            this.disconnect(player);
        }
    }

    public boolean clientConnected(class_3222 player) {
        return true;
    }

    private boolean sendCommand(class_3222 player, AbstractS2CCommand<?> command, boolean forceSend) {
        S2CCommandRecord record = S2CCommandRecord.fromS2CCommand(command);
        String cmd = this.gson.toJson((Object)record);
        this.logPacket(true, player, V3MorphCommandPayload.id.comp_2242().toString(), cmd, cmd.length());
        V3MorphCommandPayload payload = new V3MorphCommandPayload(cmd);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        return true;
    }

    public boolean sendCommand(class_3222 player, AbstractS2CCommand<?> basicS2CCommand) {
        return this.sendCommand(player, basicS2CCommand, false);
    }

    public int getPlayerVersion(class_3222 ServerPlayerEntity) {
        return 0;
    }

    public List<class_3222> getConnectedPlayers() {
        return List.of();
    }

    public InitializeState getInitializeState(class_3222 ServerPlayerEntity) {
        return null;
    }

    public boolean isPlayerInitialized(class_3222 ServerPlayerEntity) {
        return false;
    }

    public boolean isPlayerConnected(class_3222 ServerPlayerEntity) {
        return false;
    }

    public void disconnect(class_3222 ServerPlayerEntity) {
    }

    @Nullable
    public PlayerOptions<class_3222> getPlayerOption(class_3222 ServerPlayerEntity) {
        this.logger.warn("getPlayerOption is not implemented yet.");
        return null;
    }

    public void onInitialCommand(C2SRequestInitialCommand command) {
        class_3222 player = (class_3222)command.getOwner();
        List<String> unlocked = this.morphManager.getUnlockedDisguiseIds((class_1657)player);
        S2CQueryCommand cmd = new S2CQueryCommand(QueryType.SET, unlocked);
        this.sendCommand(player, (AbstractS2CCommand<?>)cmd);
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSelfViewingStatusCommand(Boolean.valueOf(true)));
        Object2ObjectOpenHashMap renderMap = new Object2ObjectOpenHashMap();
        for (DisguiseSession session : this.morphManager.listAllSession()) {
            renderMap.put(session.player().method_5628(), session.disguiseIdentifier());
        }
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CCRSyncRegisterCommand((Map)renderMap));
        Object2ObjectOpenHashMap revealMap = new Object2ObjectOpenHashMap();
        for (DisguiseSession session : this.morphManager.listAllSession()) {
            revealMap.put(session.player().method_5628(), session.player().method_5477().method_54160());
        }
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CAddAdminRevealCommand((Map)revealMap));
    }

    public void onMorphCommand(C2SMorphCommand command) {
        class_3222 player = (class_3222)command.getOwner();
        String disguiseId = command.identifier();
        this.morphManager.morph(player, disguiseId);
    }

    public void onOptionCommand(C2SSetSingleOptionCommand command) {
    }

    public void onSkillCommand(C2SActivateSkillCommand command) {
    }

    public void onToggleSelfCommand(C2SToggleSelfCommand command) {
        class_3222 player = (class_3222)command.getOwner();
        C2SToggleSelfCommand.SelfViewMode val = command.getSelfViewMode();
        switch (val) {
            case ON: 
            case CLIENT_ON: {
                this.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSelfViewingStatusCommand(Boolean.valueOf(true)));
                break;
            }
            default: {
                this.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSelfViewingStatusCommand(Boolean.valueOf(false)));
            }
        }
    }

    public void onUnmorphCommand(C2SUnmorphCommand command) {
        class_3222 player = (class_3222)command.getOwner();
        this.morphManager.unMorph(player);
    }

    public void onRequestCommand(C2SExchangeRequestManagementCommand command) {
    }

    public void onAnimationCommand(C2SRequestAnimationCommand command) {
        Pair<List<SingleAnimation>, Boolean> seqPair;
        class_3222 player = (class_3222)command.getOwner();
        DisguiseSession session = this.morphManager.getSessionFor(player);
        if (session == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"Session is NULL, you are not disguised!"));
            return;
        }
        AnimationProvider animationProvider = session.disguiseProvider().getAnimationProvider();
        String animationId = command.getAnimationId();
        if (!session.tryScheduleSequence(animationId, (List)(seqPair = animationProvider.getAnimationSetFor(session.disguiseIdentifier()).sequenceOf(animationId)).left())) {
            player.method_64398((class_2561)class_2561.method_43470((String)"Playing Animation is not available now."));
        }
    }

    public void sendDiff(@Nullable List<String> addits, @Nullable List<String> removal, class_3222 player) {
        if (addits != null) {
            this.sendCommand(player, (AbstractS2CCommand<?>)new S2CQueryCommand(QueryType.ADD, addits));
        }
        if (removal != null) {
            this.sendCommand(player, (AbstractS2CCommand<?>)new S2CQueryCommand(QueryType.REMOVE, removal));
        }
    }
}

