/*
 * Decompiled with CFR 0.152.
 */
package com.solace.infinitygenerator.block.entity;

import com.solace.infinitygenerator.AdaptedEnergyStorage;
import com.solace.infinitygenerator.ModBlockEntities;
import com.solace.infinitygenerator.ModTags;
import com.solace.infinitygenerator.block.GeneratorBlock;
import com.solace.infinitygenerator.block.entity.StoneType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GeneratorBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "Inventory";
    public static final String ENERGY_TAG = "Energy";
    public static final int GENERATE = 100000;
    public static final int MAXTRANSFER = 100000;
    public static final int CAPACITY = 1000000;
    public static int SLOT_COUNT = 1;
    public static int SLOT = 0;
    public StoneType stoneType = StoneType.NONE;
    private final ItemStackHandler items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.items);
    private final EnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage((IEnergyStorage)this.energy){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return GeneratorBlockEntity.this.energy.extractEnergy(maxExtract, simulate);
        }

        @Override
        public boolean canExtract() {
            return true;
        }

        @Override
        public boolean canReceive() {
            return false;
        }
    });

    public GeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.INFINITY_GENERATOR_BE.get(), pos, state);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void tickServer() {
        this.generateEnergy();
        this.distributeEnergy();
        this.checkStone();
    }

    private void generateEnergy() {
        if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
            if (!this.items.getStackInSlot(SLOT).m_41619_()) {
                this.energy.receiveEnergy(100000, false);
            }
            this.m_6596_();
        }
    }

    private void checkStone() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        StoneType prevType = this.stoneType;
        ItemStack stack = this.items.getStackInSlot(SLOT);
        this.stoneType = stack.m_41619_() ? StoneType.NONE : (stack.m_204117_(ModTags.Items.MIND_STONES) ? StoneType.MIND : (stack.m_204117_(ModTags.Items.REALITY_STONES) ? StoneType.REALITY : (stack.m_204117_(ModTags.Items.SPACE_STONES) ? StoneType.SPACE : (stack.m_204117_(ModTags.Items.TIME_STONES) ? StoneType.TIME : (stack.m_204117_(ModTags.Items.SOUL_STONES) ? StoneType.SOUL : (stack.m_204117_(ModTags.Items.POWER_STONES) ? StoneType.POWER : StoneType.NONE))))));
        if (this.stoneType != prevType) {
            this.m_6596_();
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state.m_61138_(GeneratorBlock.STONE_TYPE)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_(GeneratorBlock.STONE_TYPE, (Comparable)((Object)this.stoneType)), 3);
            }
        }
    }

    private void distributeEnergy() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.energy.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity neighbor = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (neighbor == null) continue;
            neighbor.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(neighborEnergy -> {
                int energyToSend;
                int received;
                if (neighborEnergy.canReceive() && (received = neighborEnergy.receiveEnergy(energyToSend = Math.min(this.energy.getEnergyStored(), 100000), false)) > 0) {
                    this.energy.extractEnergy(received, false);
                    this.m_6596_();
                }
            });
            if (this.energy.getEnergyStored() <= 0) break;
        }
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public int getStoredPower() {
        return this.energy.getEnergyStored();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
        tag.m_128365_(ENERGY_TAG, this.energy.serializeNBT());
        tag.m_128359_("StoneType", this.stoneType.name());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(ITEMS_TAG));
        }
        if (tag.m_128441_(ENERGY_TAG)) {
            this.energy.deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
        if (tag.m_128441_("StoneType")) {
            this.stoneType = StoneType.valueOf(tag.m_128461_("StoneType"));
        }
    }

    @Nonnull
    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(SLOT_COUNT){

            protected void onContentsChanged(int slot) {
                GeneratorBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(1000000, 100000, 100000);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

