/*
 * Decompiled with CFR 0.152.
 */
package com.solace.infinitygenerator.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.solace.infinitygenerator.block.entity.GeneratorBlockEntity;
import com.solace.infinitygenerator.block.entity.StoneType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GeneratorRenderer
implements BlockEntityRenderer<GeneratorBlockEntity> {
    public GeneratorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GeneratorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        if (blockEntity.getItems().getStackInSlot(0).m_41619_()) {
            return;
        }
        int yEnd = level.m_151558_();
        float textureScale = 1.0f + (float)Math.sin(((float)level.m_46467_() + partialTick) * 0.05f) * 0.1f;
        BeaconRenderer.m_112184_((PoseStack)poseStack, (MultiBufferSource)bufferSource, (ResourceLocation)BeaconRenderer.f_112102_, (float)partialTick, (float)textureScale, (long)level.m_46467_(), (int)0, (int)(yEnd - blockEntity.m_58899_().m_123342_()), (float[])this.colorFromType(blockEntity.stoneType), (float)0.2f, (float)0.25f);
    }

    public boolean shouldRenderOffScreen(GeneratorBlockEntity blockEntity) {
        return true;
    }

    public float[] colorFromType(StoneType type) {
        switch (type) {
            case MIND: {
                return new float[]{1.0f, 0.81f, 0.0f};
            }
            case POWER: {
                return new float[]{0.81f, 0.0f, 1.0f};
            }
            case SOUL: {
                return new float[]{1.0f, 0.64f, 0.0f};
            }
            case SPACE: {
                return new float[]{0.0f, 0.41f, 1.0f};
            }
            case TIME: {
                return new float[]{0.05f, 1.0f, 0.0f};
            }
            case REALITY: {
                return new float[]{1.0f, 0.0f, 0.1f};
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }
}

