/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.config;

import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.utils.Match;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class JechConfigForge {
    private static final String PATH = "jecharacters.toml";
    public static final ForgeConfigSpec common;
    static ForgeConfigSpec.BooleanValue enableQuote;
    static ForgeConfigSpec.EnumValue<JechConfig.Spell> enumKeyboard;
    static ForgeConfigSpec.BooleanValue enableFZh2z;
    static ForgeConfigSpec.BooleanValue enableFSh2s;
    static ForgeConfigSpec.BooleanValue enableFCh2c;
    static ForgeConfigSpec.BooleanValue enableFAng2an;
    static ForgeConfigSpec.BooleanValue enableFIng2in;
    static ForgeConfigSpec.BooleanValue enableFEng2en;
    static ForgeConfigSpec.BooleanValue enableFU2v;
    static ForgeConfigSpec.BooleanValue enableVerbose;
    static ForgeConfigSpec.BooleanValue enableChat;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)common, FMLPaths.CONFIGDIR.get().resolve(PATH).toString());
    }

    public static void reload() {
        JechConfig.enumKeyboard = (JechConfig.Spell)((Object)enumKeyboard.get());
        JechConfig.enableFZh2z = (Boolean)enableFZh2z.get();
        JechConfig.enableFSh2s = (Boolean)enableFSh2s.get();
        JechConfig.enableFCh2c = (Boolean)enableFCh2c.get();
        JechConfig.enableFAng2an = (Boolean)enableFAng2an.get();
        JechConfig.enableFIng2in = (Boolean)enableFIng2in.get();
        JechConfig.enableFEng2en = (Boolean)enableFEng2en.get();
        JechConfig.enableFU2v = (Boolean)enableFU2v.get();
        JechConfig.enableChat = (Boolean)enableChat.get();
        JechConfig.enableQuote = (Boolean)enableQuote.get();
        JechConfig.enableVerbose = (Boolean)enableVerbose.get();
        Match.onConfigChange();
    }

    public static void save() {
        enumKeyboard.set((Object)JechConfig.enumKeyboard);
        enableFZh2z.set((Object)JechConfig.enableFZh2z);
        enableFSh2s.set((Object)JechConfig.enableFSh2s);
        enableFCh2c.set((Object)JechConfig.enableFCh2c);
        enableFAng2an.set((Object)JechConfig.enableFAng2an);
        enableFIng2in.set((Object)JechConfig.enableFIng2in);
        enableFEng2en.set((Object)JechConfig.enableFEng2en);
        enableFU2v.set((Object)JechConfig.enableFU2v);
        enableChat.set((Object)JechConfig.enableChat);
        enableQuote.set((Object)JechConfig.enableQuote);
        enableVerbose.set((Object)JechConfig.enableVerbose);
        common.save();
    }

    public static void setKeyboard(JechConfig.Spell keyboard) {
        JechConfig.enumKeyboard = keyboard;
        enumKeyboard.set((Object)keyboard);
    }

    public static void setEnableQuote(boolean enableQuote) {
        JechConfig.enableQuote = enableQuote;
        JechConfigForge.enableQuote.set((Object)enableQuote);
    }

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("General");
        b.comment("Keyboard for the checker to use");
        enumKeyboard = b.defineEnum("enumKeyboard", (Enum)JechConfig.Spell.QUANPIN);
        b.comment("Set to true to enable fuzzy spelling zh <=> z");
        enableFZh2z = b.define("enableFZh2z", JechConfig.enableFZh2z);
        b.comment("Set to true to enable fuzzy spelling sh <=> s");
        enableFSh2s = b.define("enableFSh2s", JechConfig.enableFSh2s);
        b.comment("Set to true to enable fuzzy spelling ch <=> c");
        enableFCh2c = b.define("enableFCh2c", JechConfig.enableFCh2c);
        b.comment("Set to true to enable fuzzy spelling ang <=> an");
        enableFAng2an = b.define("enableFAng2an", JechConfig.enableFAng2an);
        b.comment("Set to true to enable fuzzy spelling ing <=> in");
        enableFIng2in = b.define("enableFIng2in", JechConfig.enableFIng2in);
        b.comment("Set to true to enable fuzzy spelling eng <=> en");
        enableFEng2en = b.define("enableFEng2en", JechConfig.enableFEng2en);
        b.comment("Set to true to enable fuzzy spelling u <=> v");
        enableFU2v = b.define("enableFU2v", JechConfig.enableFU2v);
        b.comment("Set to false to disable chat message when entering world");
        enableChat = b.define("enableChat", JechConfig.enableChat);
        b.comment("Set to true to disable JEI's split for search tokens");
        enableQuote = b.define("enableQuote", JechConfig.enableQuote);
        b.pop();
        b.push("Utilities");
        b.comment("Set true to print verbose debug message");
        enableVerbose = b.define("enableVerbose", JechConfig.enableVerbose);
        b.pop();
        common = b.build();
    }
}

