/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.utils;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import me.towdium.jecharacters.utils.Profiler;

public class ForgeInfoReader
implements Profiler.InfoReader {
    @Override
    public Profiler.Plafform getPlatform() {
        return Profiler.Plafform.FORGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Profiler.ModContainer[] readInfo(InputStream is) {
        Path p = null;
        try {
            p = Files.createTempFile("jecharacters", ".toml", new FileAttribute[0]);
            Files.copy(is, p, StandardCopyOption.REPLACE_EXISTING);
            FileConfig c = FileConfig.of((Path)p);
            c.load();
            Collection mods = (Collection)c.get("mods");
            Profiler.ModContainer[] modContainerArray = (Profiler.ModContainer[])mods.stream().map(i -> new Profiler.ModContainer((String)i.get("modId"), (String)i.get("displayName"), (String)i.get("version"))).toArray(Profiler.ModContainer[]::new);
            return modContainerArray;
        }
        catch (IOException e) {
            Profiler.LOGGER.error("Failed to read forge mod list.");
            Profiler.ModContainer[] modContainerArray = null;
            return modContainerArray;
        }
        finally {
            if (p != null && !p.toFile().delete()) {
                Profiler.LOGGER.error("Failed to delete temp file.");
            }
        }
    }
}

