/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import me.towdium.pinin.PinIn;

@FunctionalInterface
public interface DictLoader {
    public void load(BiConsumer<Character, String[]> var1);

    default public void loadCodePoints(CodePointConsumer feed) {
    }

    public static class Default
    implements DictLoader {
        @Override
        public void load(BiConsumer<Character, String[]> feed) {
            if (feed == null) {
                return;
            }
            this.loadInternal(feed, null);
        }

        @Override
        public void loadCodePoints(CodePointConsumer feed) {
            if (feed == null) {
                return;
            }
            this.loadInternal(null, feed);
        }

        private void loadInternal(BiConsumer<Character, String[]> charFeed, CodePointConsumer codePointFeed) {
            InputStream is = PinIn.class.getResourceAsStream("data.txt");
            if (is == null) {
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    char second;
                    int separator;
                    if (line.isEmpty() || (separator = line.indexOf(58)) <= 0 || separator + 2 > line.length()) continue;
                    String[] records = line.substring(separator + 2).split(", ");
                    char first = line.charAt(0);
                    if (Character.isHighSurrogate(first) && line.length() > 1 && Character.isLowSurrogate(second = line.charAt(1))) {
                        if (codePointFeed == null) continue;
                        int codePoint = Character.toCodePoint(first, second);
                        codePointFeed.accept(codePoint, records);
                        continue;
                    }
                    if (charFeed == null) continue;
                    charFeed.accept(Character.valueOf(first), records);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @FunctionalInterface
    public static interface CodePointConsumer {
        public void accept(int var1, String[] var2);
    }
}

