/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import me.towdium.pinin.DictLoader;
import me.towdium.pinin.Keyboard;
import me.towdium.pinin.elements.Char;
import me.towdium.pinin.elements.Phoneme;
import me.towdium.pinin.elements.Pinyin;
import me.towdium.pinin.utils.Accelerator;
import me.towdium.pinin.utils.Cache;
import me.towdium.pinin.utils.IndexSet;
import me.towdium.pinin.utils.PinyinFormat;

public class PinIn {
    public final Cache<String, Phoneme> phonemes = new Cache<String, Phoneme>(s -> new Phoneme((String)s, this));
    private final Char[] chars = new Char[65535];
    private final Int2ObjectArrayMap<Char> codePoints = new Int2ObjectArrayMap();
    private final Char.Dummy temp = new Char.Dummy();
    private final ThreadLocal<Accelerator> acc;
    private int total = 0;
    public final Cache<String, Pinyin> pinyins = new Cache<String, Pinyin>(s -> new Pinyin((String)s, this, this.total++));
    private Keyboard keyboard = Keyboard.QUANPIN;
    private int modification = 0;
    private boolean fZh2Z = false;
    private boolean fSh2S = false;
    private boolean fCh2C = false;
    private boolean fAng2An = false;
    private boolean fIng2In = false;
    private boolean fEng2En = false;
    private boolean fU2V = false;
    private boolean accelerate = false;
    private PinyinFormat format = PinyinFormat.NUMBER;

    public PinIn() {
        this(new DictLoader.Default());
    }

    public PinIn(DictLoader loader) {
        this.acc = ThreadLocal.withInitial(() -> new Accelerator(this));
        loader.load((c, ss) -> {
            if (ss == null) {
                this.chars[c.charValue()] = null;
            } else {
                Pinyin[] pinyins = new Pinyin[((String[])ss).length];
                for (int i = 0; i < ((String[])ss).length; ++i) {
                    pinyins[i] = this.getPinyin(ss[i]);
                }
                this.chars[c.charValue()] = new Char(c.charValue(), pinyins);
            }
        });
        loader.loadCodePoints((cp, ss) -> {
            if (ss == null) {
                if (Character.isBmpCodePoint(cp)) {
                    this.chars[cp] = null;
                } else {
                    this.codePoints.remove(cp);
                }
                return;
            }
            Pinyin[] pinyins = new Pinyin[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                pinyins[i] = this.getPinyin(ss[i]);
            }
            Char value = new Char(cp, pinyins);
            if (Character.isBmpCodePoint(cp)) {
                this.chars[cp] = value;
                this.codePoints.remove(cp);
            } else {
                this.codePoints.put(cp, (Object)value);
            }
        });
    }

    public boolean contains(String s1, String s2) {
        if (this.accelerate) {
            Accelerator a = this.acc.get();
            a.setProvider(s1);
            a.search(s2);
            return a.contains(0, 0);
        }
        return Matcher.contains(s1, s2, this);
    }

    public boolean begins(String s1, String s2) {
        if (this.accelerate) {
            Accelerator a = this.acc.get();
            a.setProvider(s1);
            a.search(s2);
            return a.begins(0, 0);
        }
        return Matcher.begins(s1, s2, this);
    }

    public boolean matches(String s1, String s2) {
        if (this.accelerate) {
            Accelerator a = this.acc.get();
            a.setProvider(s1);
            a.search(s2);
            return a.matches(0, 0);
        }
        return Matcher.matches(s1, s2, this);
    }

    public Phoneme getPhoneme(String s) {
        return this.phonemes.get(s);
    }

    public Pinyin getPinyin(String s) {
        return this.pinyins.get(s);
    }

    public Char getChar(char c) {
        Char ret = this.chars[c];
        if (ret != null) {
            return ret;
        }
        this.temp.set(c);
        return this.temp;
    }

    public Char getChar(int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            return this.getChar((char)codePoint);
        }
        Char ret = (Char)this.codePoints.get(codePoint);
        if (ret != null) {
            return ret;
        }
        this.temp.set(codePoint);
        return this.temp;
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public boolean fZh2Z() {
        return this.fZh2Z;
    }

    public boolean fSh2S() {
        return this.fSh2S;
    }

    public boolean fCh2C() {
        return this.fCh2C;
    }

    public boolean fAng2An() {
        return this.fAng2An;
    }

    public boolean fIng2In() {
        return this.fIng2In;
    }

    public boolean fEng2En() {
        return this.fEng2En;
    }

    public boolean fU2V() {
        return this.fU2V;
    }

    public PinyinFormat format() {
        return this.format;
    }

    public String format(Pinyin p) {
        return this.format.format(p);
    }

    public Config config() {
        return new Config();
    }

    public Ticket ticket(Runnable r) {
        return new Ticket(r);
    }

    private void config(Config c) {
        this.format = c.format;
        if (this.fAng2An == c.fAng2An && this.fEng2En == c.fEng2En && this.fIng2In == c.fIng2In && this.fZh2Z == c.fZh2Z && this.fSh2S == c.fSh2S && this.fCh2C == c.fCh2C && this.keyboard == c.keyboard && this.fU2V == c.fU2V && this.accelerate == c.accelerate) {
            return;
        }
        this.keyboard = c.keyboard;
        this.fZh2Z = c.fZh2Z;
        this.fSh2S = c.fSh2S;
        this.fCh2C = c.fCh2C;
        this.fAng2An = c.fAng2An;
        this.fIng2In = c.fIng2In;
        this.fEng2En = c.fEng2En;
        this.fU2V = c.fU2V;
        this.accelerate = c.accelerate;
        this.phonemes.foreach((s, p) -> p.reload((String)s, this));
        this.pinyins.foreach((s, p) -> p.reload((String)s, this));
        ++this.modification;
    }

    public class Config {
        public Keyboard keyboard;
        public boolean fZh2Z;
        public boolean fSh2S;
        public boolean fCh2C;
        public boolean fAng2An;
        public boolean fIng2In;
        public boolean fEng2En;
        public boolean fU2V;
        public boolean accelerate;
        public PinyinFormat format;

        private Config() {
            this.keyboard = PinIn.this.keyboard;
            this.fZh2Z = PinIn.this.fZh2Z;
            this.fSh2S = PinIn.this.fSh2S;
            this.fCh2C = PinIn.this.fCh2C;
            this.fAng2An = PinIn.this.fAng2An;
            this.fIng2In = PinIn.this.fIng2In;
            this.fEng2En = PinIn.this.fEng2En;
            this.fU2V = PinIn.this.fU2V;
            this.accelerate = PinIn.this.accelerate;
            this.format = PinyinFormat.NUMBER;
        }

        public Config keyboard(Keyboard keyboard) {
            this.keyboard = keyboard;
            return this;
        }

        public Config fZh2Z(boolean fZh2Z) {
            this.fZh2Z = fZh2Z;
            return this;
        }

        public Config fSh2S(boolean fSh2S) {
            this.fSh2S = fSh2S;
            return this;
        }

        public Config fCh2C(boolean fCh2C) {
            this.fCh2C = fCh2C;
            return this;
        }

        public Config fAng2An(boolean fAng2An) {
            this.fAng2An = fAng2An;
            return this;
        }

        public Config fIng2In(boolean fIng2In) {
            this.fIng2In = fIng2In;
            return this;
        }

        public Config fEng2En(boolean fEng2En) {
            this.fEng2En = fEng2En;
            return this;
        }

        public Config fU2V(boolean fU2V) {
            this.fU2V = fU2V;
            return this;
        }

        public Config format(PinyinFormat format) {
            this.format = format;
            return this;
        }

        public Config accelerate(boolean accelerate) {
            this.accelerate = accelerate;
            return this;
        }

        public PinIn commit() {
            PinIn.this.config(this);
            return PinIn.this;
        }
    }

    public static class Matcher {
        public static boolean begins(String s1, String s2, PinIn p) {
            if (s1.isEmpty()) {
                return s1.startsWith(s2);
            }
            return Matcher.check(s1, 0, s2, 0, p, true);
        }

        public static boolean contains(String s1, String s2, PinIn p) {
            if (s1.isEmpty()) {
                return s1.contains(s2);
            }
            int i = 0;
            while (i < s1.length()) {
                if (Matcher.check(s1, i, s2, 0, p, true)) {
                    return true;
                }
                char ch = s1.charAt(i);
                if (Character.isHighSurrogate(ch) && i + 1 < s1.length() && Character.isLowSurrogate(s1.charAt(i + 1))) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            return false;
        }

        public static boolean matches(String s1, String s2, PinIn p) {
            if (s1.isEmpty()) {
                return s1.equals(s2);
            }
            return Matcher.check(s1, 0, s2, 0, p, false);
        }

        private static boolean check(String s1, int start1, String s2, int start2, PinIn p, boolean partial) {
            char second;
            if (start2 == s2.length()) {
                return partial || start1 == s1.length();
            }
            if (start1 >= s1.length()) {
                return false;
            }
            int first = s1.charAt(start1);
            int consumed = 1;
            int codePoint = first;
            if (Character.isHighSurrogate((char)first) && start1 + 1 < s1.length() && Character.isLowSurrogate(second = s1.charAt(start1 + 1))) {
                codePoint = Character.toCodePoint((char)first, second);
                consumed = 2;
            }
            Char r = p.getChar(codePoint);
            IndexSet s = r.match(s2, start2, partial);
            int next = start1 + consumed;
            if (next >= s1.length()) {
                int i2 = s2.length() - start2;
                return s.get(i2);
            }
            return s.traverse(i -> Matcher.check(s1, next, s2, start2 + i, p, partial));
        }
    }

    public class Ticket {
        int modification;
        Runnable runnable;

        private Ticket(Runnable r) {
            this.runnable = r;
            this.modification = PinIn.this.modification;
        }

        public void renew() {
            int i = PinIn.this.modification;
            if (this.modification != i) {
                this.modification = i;
                this.runnable.run();
            }
        }
    }
}

