/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.searchers;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.searchers.Searcher;
import me.towdium.pinin.utils.Accelerator;
import me.towdium.pinin.utils.Compressor;

public class SimpleSearcher<T>
implements Searcher<T> {
    List<T> objs = new ArrayList<T>();
    final Accelerator acc;
    final Compressor strs = new Compressor();
    final PinIn context;
    final Searcher.Logic logic;
    final PinIn.Ticket ticket;

    public SimpleSearcher(Searcher.Logic logic, PinIn context) {
        this.context = context;
        this.logic = logic;
        this.acc = new Accelerator(context);
        this.acc.setProvider(this.strs);
        this.ticket = context.ticket(this::reset);
    }

    @Override
    public void put(String name, T identifier) {
        this.strs.put(name);
        this.objs.add(identifier);
    }

    @Override
    public List<T> search(String name) {
        ArrayList<T> ret = new ArrayList<T>();
        this.acc.search(name);
        IntList offsets = this.strs.offsets();
        for (int i = 0; i < offsets.size(); ++i) {
            int s = offsets.getInt(i);
            if (!this.logic.test(this.acc, 0, s)) continue;
            ret.add(this.objs.get(i));
        }
        return ret;
    }

    @Override
    public PinIn context() {
        return this.context;
    }

    public void reset() {
        this.acc.reset();
    }
}

