/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.elements.Char;
import me.towdium.pinin.elements.Pinyin;
import me.towdium.pinin.utils.IndexSet;

public class Accelerator {
    final PinIn context;
    List<IndexSet.Storage> cache;
    char[] searchChars = new char[0];
    String searchStr;
    Provider provider;
    Str str = new Str();
    boolean partial;

    public Accelerator(PinIn context) {
        this.context = context;
    }

    public void search(String s) {
        if (!s.equals(this.searchStr)) {
            this.searchStr = s;
            this.searchChars = s.toCharArray();
            this.reset();
        }
    }

    public IndexSet get(int codePoint, int offset) {
        int searchCode;
        Char c = this.context.getChar(codePoint);
        IndexSet ret = new IndexSet();
        if (offset < this.searchChars.length && (searchCode = this.searchCodePoint(offset)) == c.getCodePoint()) {
            ret.set(Character.charCount(searchCode));
        }
        for (Pinyin p : c.pinyins()) {
            ret.merge(this.get(p, offset));
        }
        return ret;
    }

    public IndexSet get(Pinyin p, int offset) {
        for (int i = this.cache.size(); i <= offset; ++i) {
            this.cache.add(new IndexSet.Storage());
        }
        IndexSet.Storage data = this.cache.get(offset);
        IndexSet ret = data.get(p.id);
        if (ret == null) {
            ret = p.match(this.searchStr, offset, this.partial);
            data.set(ret, p.id);
        }
        return ret;
    }

    public void setProvider(Provider p) {
        this.provider = p;
    }

    public void setProvider(String s) {
        this.str.s = s;
        this.provider = this.str;
    }

    public void reset() {
        this.cache = new ObjectArrayList();
    }

    public boolean check(int offset, int start) {
        if (offset == this.searchChars.length) {
            return this.partial || this.provider.end(start);
        }
        if (this.provider.end(start)) {
            return false;
        }
        int codePoint = this.provider.get(start);
        IndexSet s = this.get(codePoint, offset);
        int consumed = Character.charCount(codePoint);
        if (this.provider.end(start + consumed)) {
            int remaining = this.searchChars.length - offset;
            return s.get(remaining);
        }
        return s.traverse(i -> this.check(offset + i, start + consumed));
    }

    public boolean matches(int offset, int start) {
        if (this.partial) {
            this.partial = false;
            this.reset();
        }
        return this.check(offset, start);
    }

    public boolean begins(int offset, int start) {
        if (!this.partial) {
            this.partial = true;
            this.reset();
        }
        return this.check(offset, start);
    }

    public boolean contains(int offset, int start) {
        if (!this.partial) {
            this.partial = true;
            this.reset();
        }
        int i = start;
        while (!this.provider.end(i)) {
            if (this.check(offset, i)) {
                return true;
            }
            int consumed = Character.charCount(this.provider.get(i));
            i += consumed;
        }
        return false;
    }

    public String search() {
        return this.searchStr;
    }

    public int searchCodePoint(int offset) {
        return Accelerator.searchCodePoint(offset, this.searchChars);
    }

    public int common(int s1, int s2, int max) {
        int consumed;
        int o1 = s1;
        int o2 = s2;
        for (int matched = 0; matched < max; matched += consumed) {
            int b;
            if (this.provider.end(o1) || this.provider.end(o2)) {
                return matched;
            }
            int a = this.provider.get(o1);
            if (a != (b = this.provider.get(o2))) {
                return matched;
            }
            consumed = Character.charCount(a);
            o1 += consumed;
            o2 += consumed;
        }
        return max;
    }

    private static int searchCodePoint(int offset, char[] chars) {
        char second;
        char first = chars[offset];
        if (Character.isHighSurrogate(first) && offset + 1 < chars.length && Character.isLowSurrogate(second = chars[offset + 1])) {
            return Character.toCodePoint(first, second);
        }
        return first;
    }

    static class Str
    implements Provider {
        String s;

        Str() {
        }

        @Override
        public boolean end(int i) {
            return i >= this.s.length();
        }

        @Override
        public int get(int i) {
            char second;
            char first = this.s.charAt(i);
            if (Character.isHighSurrogate(first) && i + 1 < this.s.length() && Character.isLowSurrogate(second = this.s.charAt(i + 1))) {
                return Character.toCodePoint(first, second);
            }
            return first;
        }
    }

    public static interface Provider {
        public boolean end(int var1);

        public int get(int var1);
    }
}

