/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.asm;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.towdium.jecharacters.asm.Transformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;

public class JechClassTransformer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Jech Transformer");
    public static String suffixClassName = "net/minecraft/client/searchtree/SuffixArray";
    private final List<Transformer> transformers = new ArrayList<Transformer>();

    public JechClassTransformer(List<Transformer> transformers, JsonObject json) {
        this.transformers.addAll(transformers);
        HashSet removals = new HashSet();
        if (!json.entrySet().isEmpty()) {
            json.get("removals").getAsJsonArray().forEach(it -> {
                String name = it.getAsString();
                removals.add(name);
            });
            transformers.forEach(it -> it.init(json, removals));
        }
        suffixClassName = json.get("suffixClassName").getAsString();
    }

    public boolean transform(ClassNode node) {
        boolean transformed = false;
        for (Transformer transformer : this.transformers) {
            if (!transformer.accept(node.name)) continue;
            transformer.transform(node);
            transformed = true;
            LOGGER.debug("Transformed " + node.name + " with " + transformer.getClass().getSimpleName());
        }
        return transformed;
    }

    public List<Transformer> getTransformers() {
        return this.transformers;
    }
}

