/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleJsonConfig {
    private static final Logger logger = LogManager.getLogger((String)"Jech Config");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;
    private JsonObject jsonObject = new JsonObject();

    public SimpleJsonConfig() {
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve("jecharacters.json").toFile();
    }

    public boolean save() {
        if (!this.configFile.exists()) {
            try {
                Files.createFile(this.configFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Can't create config file!");
                return false;
            }
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            IOUtils.write((String)gson.toJson((JsonElement)this.jsonObject), (Writer)writer);
        }
        catch (IOException e) {
            logger.error("Can't save config file!");
            return false;
        }
        return true;
    }

    public boolean load() {
        if (!this.configFile.exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            this.jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (IOException e) {
            logger.error("Can't read config file!");
            return false;
        }
        return true;
    }

    public boolean getBoolValue(String category, String key) {
        if (this.jsonObject.has(category)) {
            JsonObject categoryObject = this.jsonObject.getAsJsonObject(category);
            if (categoryObject.has(key)) {
                return categoryObject.get(key).getAsBoolean();
            }
            throw new IllegalArgumentException("Can't find config key : " + key + "in category : " + category);
        }
        throw new IllegalArgumentException("Can't find config category  : " + category);
    }

    public <T extends Enum<T>> T getEnumValue(String category, String key, Class<T> enumClass) {
        if (this.jsonObject.has(category)) {
            JsonObject categoryObject = this.jsonObject.getAsJsonObject(category);
            if (categoryObject.has(key)) {
                String enumName = categoryObject.get(key).getAsString();
                return Enum.valueOf(enumClass, enumName);
            }
            throw new IllegalArgumentException("Can't find config key : " + key + "in category : " + category);
        }
        throw new IllegalArgumentException("Can't find config category  : " + category);
    }

    public void putValue(String category, String key, String value) {
        JsonObject categoryObject;
        if (!this.jsonObject.has(category)) {
            this.jsonObject.add(category, (JsonElement)new JsonObject());
        }
        if (!(categoryObject = this.jsonObject.getAsJsonObject(category)).has(key)) {
            categoryObject.addProperty(key, value);
        }
    }

    public void putValue(String category, String key, boolean value) {
        this.putValue(category, key, String.valueOf(value));
    }

    public void setValue(String category, String key, String value) {
        if (this.jsonObject.has(category)) {
            JsonObject categoryObject = this.jsonObject.getAsJsonObject(category);
            categoryObject.addProperty(key, value);
        } else {
            this.jsonObject.add(category, (JsonElement)new JsonObject());
        }
    }

    public void setValue(String category, String key, boolean value) {
        this.setValue(category, key, String.valueOf(value));
    }
}

