/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.mixin;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.towdium.jecharacters.asm.JechClassTransformer;
import me.towdium.jecharacters.asm.Transformer;
import me.towdium.jecharacters.mixin.MixinTransformerHook;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.transformers.TreeTransformer;

public class JechMixinPlugin
implements IMixinConfigPlugin {
    static final ImmutableList<Transformer> TRANSFORMERS = JechMixinPlugin.entrypoint("transformer", Transformer.class);
    private static final Logger log = LoggerFactory.getLogger(JechMixinPlugin.class);

    private static <ENTRYPOINT> ImmutableList<ENTRYPOINT> entrypoint(@NotNull String key, @NotNull Class<ENTRYPOINT> entrypointClass) {
        return ImmutableList.copyOf((Collection)FabricLoader.getInstance().getEntrypoints("jech:" + key, entrypointClass));
    }

    private static <T extends TreeTransformer> void hook() throws NoSuchFieldException, IllegalAccessException {
        ClassLoader knotClassLoader = JechMixinPlugin.class.getClassLoader();
        Field knotClassDelegateField = knotClassLoader.getClass().getDeclaredField("delegate");
        knotClassDelegateField.setAccessible(true);
        Object knotClassDelegate = knotClassDelegateField.get(knotClassLoader);
        Field mixinTransformerField = knotClassDelegate.getClass().getDeclaredField("mixinTransformer");
        mixinTransformerField.setAccessible(true);
        InputStream is = JechClassTransformer.class.getClassLoader().getResourceAsStream("me/towdium/jecharacters/targets.json");
        if (is == null) {
            throw new RuntimeException("Could not find targets.json. JechTransformer will not be loaded.");
        }
        JsonObject targets = JsonParser.parseReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)).getAsJsonObject();
        File configDataFile = FabricLoader.getInstance().getConfigDir().resolve("jecharacters-extra.json").toFile();
        if (!configDataFile.exists()) {
            JsonObject template = new JsonObject();
            template.add("removals", (JsonElement)new JsonArray());
            template.add("contains", (JsonElement)JechMixinPlugin.withDefaults());
            template.add("equals", (JsonElement)JechMixinPlugin.withDefaults());
            template.add("suffix", (JsonElement)JechMixinPlugin.withDefaults());
            template.add("regExp", (JsonElement)JechMixinPlugin.withDefaults());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)template);
            configDataFile.getParentFile().mkdirs();
            try {
                configDataFile.createNewFile();
            }
            catch (IOException e) {
                log.error("Could not create config file", (Throwable)e);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configDataFile), StandardCharsets.UTF_8);){
                writer.write(json);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                log.error("Could not write to config file", (Throwable)e);
            }
        } else {
            try {
                String s = Files.readString(configDataFile.toPath());
                JsonObject extra = JsonParser.parseString((String)s).getAsJsonObject();
                for (Map.Entry entry : extra.entrySet()) {
                    if (((String)entry.getKey()).equals("removals")) {
                        ((JsonElement)entry.getValue()).getAsJsonArray().forEach(arg_0 -> ((JsonArray)targets.get("removals").getAsJsonArray()).add(arg_0));
                        continue;
                    }
                    JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
                    value.get("additional").getAsJsonArray().forEach(target -> targets.get((String)entry.getKey()).getAsJsonObject().get("additional").getAsJsonArray().add(target));
                }
            }
            catch (IOException e) {
                log.error("Could not read config file", (Throwable)e);
            }
        }
        mixinTransformerField.set(knotClassDelegate, new MixinTransformerHook<TreeTransformer>((TreeTransformer)mixinTransformerField.get(knotClassDelegate), new JechClassTransformer((List<Transformer>)TRANSFORMERS, targets)));
    }

    private static JsonObject withDefaults() {
        JsonObject template = new JsonObject();
        template.add("additional", (JsonElement)new JsonArray());
        return template;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        try {
            JechMixinPlugin.hook();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

