/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.mixin;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import me.towdium.jecharacters.asm.JechClassTransformer;
import me.towdium.jecharacters.mixin.MixinTransformerDelegate;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.transformers.TreeTransformer;

class MixinTransformerHook<T extends TreeTransformer>
extends MixinTransformerDelegate<T> {
    private final Deque<String> transformationStack = new ArrayDeque<String>();
    private final JechClassTransformer transformer;

    MixinTransformerHook(T delegate, JechClassTransformer transformer) {
        super(delegate);
        this.transformer = transformer;
    }

    @Override
    public byte[] transformClassBytes(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || Objects.equals(this.transformationStack.peek(), name)) {
            return super.transformClassBytes(name, transformedName, basicClass);
        }
        this.transformationStack.push(name);
        basicClass = super.transformClassBytes(name, transformedName, basicClass);
        String internalName = name.replace('.', '/');
        boolean shouldTransform = this.transformer.getTransformers().stream().anyMatch(it -> it.accept(internalName));
        if (!shouldTransform) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.transformer.transform(classNode);
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        basicClass = classWriter.toByteArray();
        this.transformationStack.pop();
        return basicClass;
    }
}

