/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.config;

import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.config.SimpleJsonConfig;
import me.towdium.jecharacters.utils.Match;

public class JechConfigFabric {
    private static SimpleJsonConfig config;

    public static SimpleJsonConfig getConfig() {
        return config;
    }

    public static void register() {
        config = new SimpleJsonConfig();
        config.putValue("general", "EnumKeyboard", JechConfig.Spell.QUANPIN.name());
        config.putValue("general", "EnableFZh2z", true);
        config.putValue("general", "EnableFSh2s", true);
        config.putValue("general", "EnableFCh2c", true);
        config.putValue("general", "EnableFAng2an", true);
        config.putValue("general", "EnableFIng2in", true);
        config.putValue("general", "EnableFEng2en", true);
        config.putValue("general", "EnableFU2v", true);
        config.putValue("general", "EnableQuote", false);
        config.putValue("utilities", "EnableVerbose", false);
    }

    public static void loadConfig() {
        config.load();
        JechConfig.enumKeyboard = config.getEnumValue("general", "EnumKeyboard", JechConfig.Spell.class);
        JechConfig.enableFZh2z = config.getBoolValue("general", "EnableFZh2z");
        JechConfig.enableFSh2s = config.getBoolValue("general", "EnableFSh2s");
        JechConfig.enableFCh2c = config.getBoolValue("general", "EnableFCh2c");
        JechConfig.enableFAng2an = config.getBoolValue("general", "EnableFAng2an");
        JechConfig.enableFIng2in = config.getBoolValue("general", "EnableFIng2in");
        JechConfig.enableFEng2en = config.getBoolValue("general", "EnableFEng2en");
        JechConfig.enableFU2v = config.getBoolValue("general", "EnableFU2v");
        JechConfig.enableQuote = config.getBoolValue("general", "EnableQuote");
        JechConfig.enableVerbose = config.getBoolValue("utilities", "EnableVerbose");
        Match.onConfigChange();
        config.save();
    }

    public static void save() {
        config.setValue("general", "EnumKeyboard", JechConfig.enumKeyboard.name());
        config.setValue("general", "EnableFZh2z", JechConfig.enableFZh2z);
        config.setValue("general", "EnableFSh2s", JechConfig.enableFSh2s);
        config.setValue("general", "EnableFCh2c", JechConfig.enableFCh2c);
        config.setValue("general", "EnableFAng2an", JechConfig.enableFAng2an);
        config.setValue("general", "EnableFIng2in", JechConfig.enableFIng2in);
        config.setValue("general", "EnableFEng2en", JechConfig.enableFEng2en);
        config.setValue("general", "EnableFU2v", JechConfig.enableFU2v);
        config.setValue("general", "EnableQuote", JechConfig.enableQuote);
        config.setValue("utilities", "EnableVerbose", JechConfig.enableVerbose);
        config.save();
    }

    public static void setKeyboard(JechConfig.Spell enumKeyboard) {
        JechConfig.enumKeyboard = enumKeyboard;
        config.setValue("general", "EnumKeyboard", enumKeyboard.name());
        config.save();
    }

    public static void setEnableQuote(boolean enableQuote) {
        JechConfig.enableQuote = enableQuote;
        config.setValue("general", "EnableQuote", enableQuote);
        config.save();
    }

    public static void setEnableVerbose(boolean enableVerbose) {
        JechConfig.enableVerbose = enableVerbose;
        config.setValue("utilities", "EnableVerbose", enableVerbose);
        config.save();
    }
}

