/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.mixin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.towdium.jecharacters.asm.ITransformer;
import me.towdium.jecharacters.asm.JechClassTransformer;
import me.towdium.jecharacters.mixin.MixinTransformerHook;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.transformers.TreeTransformer;

public class JechMixinPlugin
implements IMixinConfigPlugin {
    static final ImmutableList<ITransformer> TRANSFORMERS = JechMixinPlugin.entrypoint("transformer", ITransformer.class);

    private static <ENTRYPOINT> ImmutableList<ENTRYPOINT> entrypoint(@NotNull String key, @NotNull Class<ENTRYPOINT> entrypointClass) {
        return ImmutableList.copyOf((Collection)FabricLoader.getInstance().getEntrypoints("jech:" + key, entrypointClass));
    }

    private static <T extends TreeTransformer> void hook() throws NoSuchFieldException, IllegalAccessException {
        ClassLoader knotClassLoader = JechMixinPlugin.class.getClassLoader();
        Field knotClassDelegateField = knotClassLoader.getClass().getDeclaredField("delegate");
        knotClassDelegateField.setAccessible(true);
        Object knotClassDelegate = knotClassDelegateField.get(knotClassLoader);
        Field mixinTransformerField = knotClassDelegate.getClass().getDeclaredField("mixinTransformer");
        mixinTransformerField.setAccessible(true);
        InputStream is = JechClassTransformer.class.getClassLoader().getResourceAsStream("me/towdium/jecharacters/targets.json");
        if (is == null) {
            throw new RuntimeException("Could not find targets.json. JechTransformer will not be loaded.");
        }
        JsonObject targets = new JsonParser().parse((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)).getAsJsonObject();
        mixinTransformerField.set(knotClassDelegate, new MixinTransformerHook<TreeTransformer>((TreeTransformer)mixinTransformerField.get(knotClassDelegate), new JechClassTransformer((List<ITransformer>)TRANSFORMERS, targets)));
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        try {
            JechMixinPlugin.hook();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

