/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.elements;

import me.towdium.pinin.elements.Element;
import me.towdium.pinin.elements.Pinyin;
import me.towdium.pinin.utils.IndexSet;

public class Char
implements Element {
    public static final Pinyin[] NONE = new Pinyin[0];
    Pinyin[] pinyin;
    protected int ch;

    public Char(char ch, Pinyin[] pinyin) {
        this.ch = ch;
        this.pinyin = pinyin;
    }

    public Char(int ch, Pinyin[] pinyin) {
        this.ch = ch;
        this.pinyin = pinyin;
    }

    public Char(String s, Pinyin[] pinyin) {
        this.ch = s.codePointAt(0);
        this.pinyin = pinyin;
    }

    @Override
    public IndexSet match(String str, int start, boolean partial) {
        IndexSet ret = new IndexSet();
        if (start < str.length()) {
            char second;
            int first;
            int codePoint = first = str.charAt(start);
            int consumed = 1;
            if (Character.isHighSurrogate((char)first) && start + 1 < str.length() && Character.isLowSurrogate(second = str.charAt(start + 1))) {
                codePoint = Character.toCodePoint((char)first, second);
                consumed = 2;
            }
            if (codePoint == this.ch) {
                ret.set(consumed);
            }
        }
        for (Pinyin p : this.pinyin) {
            ret.merge(p.match(str, start, partial));
        }
        return ret;
    }

    public char get() {
        return (char)this.ch;
    }

    public int getCodePoint() {
        return this.ch;
    }

    public Pinyin[] pinyins() {
        return this.pinyin;
    }

    public static class Dummy
    extends Char {
        public Dummy() {
            super('\u0000', NONE);
        }

        public void set(char ch) {
            this.ch = ch;
        }

        public void set(int ch) {
            this.ch = ch;
        }
    }
}

