/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.searchers;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.searchers.Searcher;
import me.towdium.pinin.searchers.SimpleSearcher;

public class CachedSearcher<T>
extends SimpleSearcher<T> {
    IntList all = new IntArrayList();
    float scale;
    int lenCached = 0;
    int maxCached = 0;
    int total = 0;
    Stats<String> stats = new Stats();
    Map<String, IntList> cache = new HashMap<String, IntList>();

    public CachedSearcher(Searcher.Logic logic, PinIn context) {
        this(logic, context, 1.0f);
    }

    public CachedSearcher(Searcher.Logic logic, PinIn context, float scale) {
        super(logic, context);
        this.scale = scale;
    }

    @Override
    public void put(String name, T identifier) {
        this.reset();
        int length = 0;
        int i = 0;
        while (i < name.length()) {
            char second;
            char first = name.charAt(i);
            if (Character.isHighSurrogate(first) && i + 1 < name.length() && Character.isLowSurrogate(second = name.charAt(i + 1))) {
                this.context.getChar(Character.toCodePoint(first, second));
                i += 2;
                length += 2;
                continue;
            }
            this.context.getChar(first);
            ++i;
            ++length;
        }
        this.total += length;
        this.all.add(this.all.size());
        this.lenCached = 0;
        this.maxCached = 0;
        super.put(name, identifier);
    }

    @Override
    public List<T> search(String name) {
        this.ticket.renew();
        if (this.all.isEmpty()) {
            return new ArrayList();
        }
        if (this.maxCached == 0) {
            float totalSearch = this.logic == Searcher.Logic.CONTAIN ? (float)this.total : (float)this.all.size();
            this.maxCached = (int)((double)this.scale * Math.ceil(2.0 * Math.log(totalSearch) / Math.log(2.0) + 16.0));
        }
        if (this.lenCached == 0) {
            this.lenCached = (int)Math.ceil(Math.log(this.maxCached) / Math.log(8.0));
        }
        return this.test(name).stream().map(i -> this.objs.get((int)i)).collect(Collectors.toList());
    }

    @Override
    public void reset() {
        super.reset();
        this.stats.reset();
        this.lenCached = 0;
        this.maxCached = 0;
    }

    private IntList filter(String name) {
        if (name.isEmpty()) {
            return this.all;
        }
        IntList ret = this.cache.get(name);
        this.stats.count(name);
        if (ret == null) {
            IntList base = this.filter(name.substring(0, name.length() - 1));
            if (this.cache.size() >= this.maxCached) {
                String least = this.stats.least(this.cache.keySet(), name);
                if (!least.equals(name)) {
                    this.cache.remove(least);
                } else {
                    return base;
                }
            }
            this.acc.search(name);
            IntArrayList tmp = new IntArrayList();
            Searcher.Logic filter = this.logic == Searcher.Logic.EQUAL ? Searcher.Logic.BEGIN : this.logic;
            IntListIterator intListIterator = base.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                if (!filter.test(this.acc, 0, this.strs.offsets().getInt(i))) continue;
                tmp.add(i);
            }
            if (tmp.size() == base.size()) {
                ret = base;
            } else {
                tmp.trim();
                ret = tmp;
            }
            this.cache.put(name, ret);
        }
        return ret;
    }

    private IntList test(String name) {
        IntList is = this.filter(name.substring(0, Math.min(name.length(), this.lenCached)));
        if (this.logic == Searcher.Logic.EQUAL || name.length() > this.lenCached) {
            IntArrayList ret = new IntArrayList();
            this.acc.search(name);
            IntListIterator intListIterator = is.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                if (!this.logic.test(this.acc, 0, this.strs.offsets().getInt(i))) continue;
                ret.add(i);
            }
            return ret;
        }
        return is;
    }

    static class Stats<T> {
        Object2IntMap<T> data = new Object2IntOpenHashMap();

        Stats() {
        }

        public void count(T key) {
            int cnt = this.data.getInt(key) + 1;
            this.data.put(key, cnt);
            if (cnt == Integer.MAX_VALUE) {
                this.data.forEach((k, v) -> this.data.put(k, v / 2));
            }
        }

        public T least(Collection<T> keys, T extra) {
            T ret = extra;
            int cnt = this.data.getInt(extra);
            for (T i : keys) {
                int value = this.data.getInt(i);
                if (value >= cnt) continue;
                ret = i;
                cnt = value;
            }
            return ret;
        }

        public void reset() {
            this.data.clear();
        }
    }
}

