/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.searchers;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.elements.Char;
import me.towdium.pinin.elements.Phoneme;
import me.towdium.pinin.elements.Pinyin;
import me.towdium.pinin.searchers.Searcher;
import me.towdium.pinin.utils.Accelerator;
import me.towdium.pinin.utils.Compressor;

public class TreeSearcher<T>
implements Searcher<T> {
    Node<T> root = new NDense();
    List<T> objects = new ObjectArrayList();
    List<NAcc<T>> naccs = new ArrayList<NAcc<T>>();
    final Accelerator acc;
    final Compressor strs = new Compressor();
    final PinIn context;
    final Searcher.Logic logic;
    final PinIn.Ticket ticket;
    static final int THRESHOLD = 128;

    public TreeSearcher(Searcher.Logic logic, PinIn context) {
        this.logic = logic;
        this.context = context;
        this.acc = new Accelerator(context);
        this.acc.setProvider(this.strs);
        this.ticket = context.ticket(() -> {
            this.naccs.forEach(i -> i.reload(this));
            this.acc.reset();
        });
    }

    @Override
    public void put(String name, T identifier) {
        this.ticket.renew();
        int pos = this.strs.put(name);
        if (this.logic == Searcher.Logic.CONTAIN) {
            int consumed;
            for (int i = 0; i < name.length(); i += consumed) {
                this.root = this.root.put(this, pos + i, this.objects.size());
                consumed = Character.charCount(name.codePointAt(i));
            }
        } else {
            this.root = this.root.put(this, pos, this.objects.size());
        }
        this.objects.add(identifier);
    }

    @Override
    public List<T> search(String s) {
        this.ticket.renew();
        this.acc.search(s);
        IntRBTreeSet ret = new IntRBTreeSet();
        this.root.get(this, (IntSet)ret, 0);
        return ret.stream().map(i -> this.objects.get((int)i)).collect(Collectors.toList());
    }

    @Override
    public PinIn context() {
        return this.context;
    }

    public void refresh() {
        this.ticket.renew();
    }

    public static class NDense<T>
    implements Node<T> {
        IntList data = new IntArrayList();

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            boolean full;
            boolean bl = full = p.logic == Searcher.Logic.EQUAL;
            if (!full && p.acc.search().length() == offset) {
                this.get(p, ret);
            } else {
                for (int i = 0; i < this.data.size() / 2; ++i) {
                    int ch = this.data.getInt(i * 2);
                    if (!(full ? p.acc.matches(offset, ch) : p.acc.begins(offset, ch))) continue;
                    ret.add(this.data.getInt(i * 2 + 1));
                }
            }
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret) {
            for (int i = 0; i < this.data.size() / 2; ++i) {
                ret.add(this.data.getInt(i * 2 + 1));
            }
        }

        @Override
        public Node<T> put(TreeSearcher<T> p, int name, int identifier) {
            if (this.data.size() >= 128) {
                int pattern = this.data.getInt(0);
                NSlice<T> ret = new NSlice<T>(pattern, pattern + this.match(p));
                for (int j = 0; j < this.data.size() / 2; ++j) {
                    ret.put(p, this.data.getInt(j * 2), this.data.getInt(j * 2 + 1));
                }
                ret.put(p, name, identifier);
                return ret;
            }
            this.data.add(name);
            this.data.add(identifier);
            return this;
        }

        private int match(TreeSearcher<T> p) {
            int offset = 0;
            int base;
            while (!p.strs.end(base = this.data.getInt(0) + offset)) {
                int a = p.strs.get(base);
                int consumed = Character.charCount(a);
                for (int j = 1; j < this.data.size() / 2; ++j) {
                    int other = this.data.getInt(j * 2) + offset;
                    if (!p.strs.end(other) && p.strs.get(other) == a) continue;
                    return offset;
                }
                offset += consumed;
            }
            return offset;
        }
    }

    static interface Node<T> {
        public void get(TreeSearcher<T> var1, IntSet var2, int var3);

        public void get(TreeSearcher<T> var1, IntSet var2);

        public Node<T> put(TreeSearcher<T> var1, int var2, int var3);
    }

    public static class NAcc<T>
    extends NMap<T> {
        Map<Phoneme, CodePointIndex> index = new Object2ObjectArrayMap();

        private NAcc(TreeSearcher<T> p, NMap<T> n) {
            this.charChildren = n.charChildren;
            this.intChildren = n.intChildren;
            this.leaves = n.leaves;
            this.reload(p);
            p.naccs.add(this);
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            if (p.acc.search().length() == offset) {
                if (p.logic == Searcher.Logic.EQUAL) {
                    ret.addAll((IntCollection)this.leaves);
                } else {
                    this.get(p, ret);
                }
            } else {
                int searchCodePoint = p.acc.searchCodePoint(offset);
                int consumed = Character.charCount(searchCodePoint);
                Node<T> n = this.getChild(searchCodePoint);
                if (n != null) {
                    n.get(p, ret, offset + consumed);
                }
                this.index.forEach((k, v) -> {
                    if (!k.match(p.acc.search(), offset, true).isEmpty()) {
                        v.forEach(i -> {
                            Node child = this.getChild(i);
                            if (child != null) {
                                p.acc.get(i, offset).foreach(j -> child.get(p, ret, offset + j));
                            }
                        });
                    }
                });
            }
        }

        @Override
        public NAcc<T> put(TreeSearcher<T> p, int name, int identifier) {
            super.put((TreeSearcher)p, name, identifier);
            if (!p.strs.end(name)) {
                this.index(p, p.strs.get(name));
            }
            return this;
        }

        public void reload(TreeSearcher<T> p) {
            this.index.clear();
            this.forEachChildCodePoint(i -> this.index(p, i));
        }

        private void index(TreeSearcher<T> p, int codePoint) {
            Char ch = p.context.getChar(codePoint);
            for (Pinyin py : ch.pinyins()) {
                CodePointIndex bucket = this.index.computeIfAbsent(py.phonemes()[0], k -> new CodePointIndex());
                bucket.add(codePoint);
            }
        }

        private static class CodePointIndex {
            CharSet chars;
            IntSet ints;

            private CodePointIndex() {
            }

            void add(int codePoint) {
                if (Character.isBmpCodePoint(codePoint)) {
                    if (this.chars == null) {
                        this.chars = new CharArraySet();
                    } else if (this.chars instanceof CharArraySet && this.chars.size() >= 128 && !this.chars.contains((char)codePoint)) {
                        this.chars = new CharOpenHashSet((CharCollection)this.chars);
                    }
                    this.chars.add((char)codePoint);
                } else {
                    if (this.ints == null) {
                        this.ints = new IntArraySet();
                    } else if (this.ints instanceof IntArraySet && this.ints.size() >= 128 && !this.ints.contains(codePoint)) {
                        this.ints = new IntOpenHashSet((IntCollection)this.ints);
                    }
                    this.ints.add(codePoint);
                }
            }

            void forEach(IntConsumer consumer) {
                if (this.chars != null) {
                    this.chars.forEach(consumer);
                }
                if (this.ints != null) {
                    this.ints.forEach(consumer);
                }
            }
        }
    }

    public static class NMap<T>
    implements Node<T> {
        Char2ObjectMap<Node<T>> charChildren;
        Int2ObjectMap<Node<T>> intChildren;
        IntSet leaves = new IntArraySet(1);

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            if (p.acc.search().length() == offset) {
                if (p.logic == Searcher.Logic.EQUAL) {
                    ret.addAll((IntCollection)this.leaves);
                } else {
                    this.get(p, ret);
                }
            } else {
                if (this.charChildren != null) {
                    this.charChildren.char2ObjectEntrySet().forEach(entry -> p.acc.get(entry.getCharKey(), offset).foreach(i -> ((Node)entry.getValue()).get(p, ret, offset + i)));
                }
                if (this.intChildren != null) {
                    this.intChildren.int2ObjectEntrySet().forEach(entry -> p.acc.get(entry.getIntKey(), offset).foreach(i -> ((Node)entry.getValue()).get(p, ret, offset + i)));
                }
            }
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret) {
            ret.addAll((IntCollection)this.leaves);
            if (this.charChildren != null) {
                this.charChildren.values().forEach(n -> n.get(p, ret));
            }
            if (this.intChildren != null) {
                this.intChildren.values().forEach(n -> n.get(p, ret));
            }
        }

        @Override
        public NMap<T> put(TreeSearcher<T> p, int name, int identifier) {
            if (p.strs.end(name)) {
                if (this.leaves.size() >= 128 && this.leaves instanceof IntArraySet) {
                    this.leaves = new IntOpenHashSet((IntCollection)this.leaves);
                }
                this.leaves.add(identifier);
            } else {
                int codePoint = p.strs.get(name);
                Node<T> sub = this.getChild(codePoint);
                if (sub == null) {
                    sub = new NDense();
                    this.putChild(codePoint, sub);
                }
                int consumed = Character.charCount(codePoint);
                sub = sub.put(p, name + consumed, identifier);
                this.putChild(codePoint, sub);
            }
            return !(this instanceof NAcc) && this.childCount() > 32 ? new NAcc(p, this) : this;
        }

        private void putChild(int codePoint, Node<T> node) {
            if (Character.isBmpCodePoint(codePoint)) {
                if (this.charChildren == null) {
                    this.charChildren = new Char2ObjectArrayMap();
                } else if (this.charChildren.size() >= 128 && this.charChildren instanceof Char2ObjectArrayMap) {
                    this.charChildren = new Char2ObjectOpenHashMap(this.charChildren);
                }
                this.charChildren.put((char)codePoint, node);
            } else {
                if (this.intChildren == null) {
                    this.intChildren = new Int2ObjectArrayMap();
                } else if (this.intChildren.size() >= 128 && this.intChildren instanceof Int2ObjectArrayMap) {
                    this.intChildren = new Int2ObjectOpenHashMap(this.intChildren);
                }
                this.intChildren.put(codePoint, node);
            }
        }

        Node<T> getChild(int codePoint) {
            if (Character.isBmpCodePoint(codePoint)) {
                return this.charChildren == null ? null : (Node)this.charChildren.get((char)codePoint);
            }
            return this.intChildren == null ? null : (Node)this.intChildren.get(codePoint);
        }

        void forEachChildCodePoint(IntConsumer consumer) {
            if (this.charChildren != null) {
                this.charChildren.keySet().forEach(consumer);
            }
            if (this.intChildren != null) {
                this.intChildren.keySet().forEach(consumer);
            }
        }

        private int childCount() {
            int count = 0;
            if (this.charChildren != null) {
                count += this.charChildren.size();
            }
            if (this.intChildren != null) {
                count += this.intChildren.size();
            }
            return count;
        }
    }

    public static class NSlice<T>
    implements Node<T> {
        Node<T> exit = new NMap();
        int start;
        int end;

        public NSlice(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret, int offset) {
            this.get(p, ret, offset, 0);
        }

        @Override
        public void get(TreeSearcher<T> p, IntSet ret) {
            this.exit.get(p, ret);
        }

        @Override
        public Node<T> put(TreeSearcher<T> p, int name, int identifier) {
            int length = this.end - this.start;
            int match = p.acc.common(this.start, name, length);
            if (match >= length) {
                this.exit = this.exit.put(p, name + length, identifier);
            } else {
                this.cut(p, this.start + match);
                this.exit = this.exit.put(p, name + match, identifier);
            }
            return this.start == this.end ? this.exit : this;
        }

        private void cut(TreeSearcher<T> p, int offset) {
            NMap insert = new NMap();
            int codePoint = p.strs.get(offset);
            int consumed = Character.charCount(codePoint);
            if (offset + consumed == this.end) {
                insert.putChild(codePoint, this.exit);
            } else {
                NSlice<T> half = new NSlice<T>(offset + consumed, this.end);
                half.exit = this.exit;
                insert.putChild(codePoint, half);
            }
            this.exit = insert;
            this.end = offset;
        }

        private void get(TreeSearcher<T> p, IntSet ret, int offset, int start) {
            if (this.start + start == this.end) {
                this.exit.get(p, ret, offset);
            } else if (offset == p.acc.search().length()) {
                if (p.logic != Searcher.Logic.EQUAL) {
                    this.exit.get(p, ret);
                }
            } else {
                int codePoint = p.strs.get(this.start + start);
                p.acc.get(codePoint, offset).foreach(i -> this.get(p, ret, offset + i, start + Character.charCount(codePoint)));
            }
        }
    }
}

