/*
 * Decompiled with CFR 0.152.
 */
package me.andy.ecomobs.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.andy.ecomobs.EcoMobs;
import me.andy.ecomobs.config.MessageFormattingData;
import me.andy.ecomobs.config.MessageFormattingManager;
import me.andy.ecomobs.config.ModConfig;
import me.andy.ecomobs.util.MessageFormatter;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class EcoMobsCommand {
    private static final Set<String> MOB_SUGGESTION_LIST = Set.of("allay", "blaze", "bogged", "breeze", "cave_spider", "copper_golem", "creeper", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "ghast", "happy_ghast", "giant", "guardian", "hoglin", "husk", "illusioner", "iron_golem", "magma_cube", "phantom", "piglin", "piglin_brute", "pillager", "polar_bear", "ravager", "shulker", "silverfish", "skeleton", "slime", "snow_golem", "spider", "stray", "vex", "villager", "vindicator", "wandering_trader", "warden", "witch", "wither", "wither_skeleton", "wolf", "zoglin", "zombie", "zombie_villager", "zombified_piglin", "camel", "cat", "donkey", "horse", "llama", "mule", "parrot", "skeleton_horse", "trader_llama", "armadillo", "axolotl", "bee", "chicken", "cow", "fox", "frog", "goat", "mooshroom", "ocelot", "panda", "pig", "rabbit", "sheep", "sniffer", "strider", "turtle", "bat", "cod", "dolphin", "glow_squid", "pufferfish", "salmon", "squid", "tadpole", "tropical_fish");
    private static List<List<String>> ALL_HELP_PAGES = Collections.emptyList();
    private static final List<String> PAGE1_HELP_LINES = List.of("", "&6&m                        &r  &6EcoMobs Commands:  &6&m                        ", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&a/ecomobs mob 'mob / animal'{See settings for this mob / animal.}<action:suggest_command,/em mob >", "&a/ecomobs mob 'mob / animal' 'true / false'{disable or enable this mobs payout.}<action:suggest_command,/em mob >", "&a/ecomobs mob 'mob / animal' 'kill, breed, tame' 'price'{Set kill, breed or tame price for this mobs payout.}<action:suggest_command,/em mob >", "&a/ecomobs mode{See the current active mode for payout and chat messages.}<action:suggest_command,/em mode>", "&a/ecomobs mode 'CHAT, ACTIONBAR, BOTH, FIXED, NONFIXED'{Set the mode for message display and kill, breed and tame payouts.}<action:suggest_command,/em mode >", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&a/ecomobs nonfixed 'single, double, triple, quadruple digit' 'amount'{Set the non fixed payout variation.}<action:suggest_command,/em nonfixed >", "&a/ecomobs spawner 'false / true'{Turn payments from spawners on/off}<action:suggest_command,/em spawner >", "&a/ecomobs spawner multiplier 'amount'{Change the spawners payout multiplier.}<action:suggest_command,/em spawner multiplier >", "&eseperate 'trialspawner' and 'baby' controls baby animals :){Disable 'baby' if you want baby animals to not pay after kill.}<action:suggest_command,/em baby false>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&d/ecomobs reload{Reloads all configs of EcoMobs after edits.}<action:suggest_command,/em reload>", "&e/em is an Alias :)                       &6[EcoMobs Help Link]{This is my discord i dont have a github etc yet will look into it :)}<action:open_url,https://discord.gg/48sZCbdHzJ>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>");
    private static final List<String> PAGE2_HELP_LINES = List.of("", "&6&m                      &r  &6EcoMobs Multipliers:  &6&m                    ", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&b/em spawner{Show/set regular spawner multiplier. (Admin/ecomobs.command.admin)}<action:suggest_command,/em spawner>", "&b/em trialspawner{Show/set Trial Spawner multiplier. (Admin/ecomobs.command.admin)}<action:suggest_command,/em trialspawner>", "&b/em baby{Show/set baby animal multiplier. (Admin/ecomobs.command.admin)}<action:suggest_command,/em baby>", "&b/em nonfixed{Show/set non-fixed payout percentages. (Admin/ecomobs.command.admin)}<action:suggest_command,/em nonfixed>", "&b/em 'type' true/false{Enable/Disable spawner/baby payouts. (Admin/ecomobs.command.admin)}<action:suggest_command,/em baby false>", "&b/em 'type' multiplier 'value'{Set multiplier/percentage value. (Admin/ecomobs.command.admin)}<action:suggest_command,/em spawner multiplier 0.25>", "&eClick me to go back to main menu{}<action:run_command,/ecomobspage 1>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&d/ecomobs reload{Reloads all configs of EcoMobs after edits. (Admin/ecomobs.command.reload)}<action:suggest_command,/ecomobs reload>");

    private static void initializeHelpPages() {
        ALL_HELP_PAGES = new ArrayList<List<String>>();
        try {
            EcoMobs.LOGGER.info("Initializing EcoMobs help pages...");
            ArrayList<List<String>> tempCombinedPages = new ArrayList<List<String>>();
            tempCombinedPages.add(PAGE1_HELP_LINES);
            tempCombinedPages.add(PAGE2_HELP_LINES);
            ALL_HELP_PAGES = List.copyOf(tempCombinedPages);
            EcoMobs.LOGGER.info("Total EcoMobs help pages loaded: {}", (Object)ALL_HELP_PAGES.size());
        }
        catch (Throwable e) {
            EcoMobs.LOGGER.error("CRITICAL ERROR during EcoMobs help page initialization. Command will likely fail.", e);
            ALL_HELP_PAGES = List.of(List.of("", "&c----------------------------------------------------", "&cAn internal error occurred while loading help pages.", "&cPlease contact server administrator and check console for details.", "&c----------------------------------------------------", ""));
        }
    }

    private static CompletableFuture<Suggestions> entityIdSuggester(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        MOB_SUGGESTION_LIST.stream().filter(simpleId -> simpleId.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> EcoMobsCommand.register((CommandDispatcher<class_2168>)dispatcher, (class_7225.class_7874)registryAccess, environment));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7225.class_7874 registryAccess, class_2170.class_5364 environment) {
        EcoMobsCommand.initializeHelpPages();
        RequiredArgumentBuilder idArgument = class_2170.method_9244((String)"entityId", (ArgumentType)StringArgumentType.word()).suggests(EcoMobsCommand::entityIdSuggester);
        RequiredArgumentBuilder payoutActionArgument = class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(Stream.of("kill", "breed", "tame", "true", "false"), (SuggestionsBuilder)builder));
        RequiredArgumentBuilder valueArgument = class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString());
        RequiredArgumentBuilder priceArgument = class_2170.method_9244((String)"price", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0));
        RequiredArgumentBuilder nonFixedActionArgument = class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(Stream.of("singledigit", "doubledigit", "tripledigit", "quadrupledigit"), (SuggestionsBuilder)builder));
        RequiredArgumentBuilder percentageArgument = class_2170.method_9244((String)"percentage", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0));
        LiteralArgumentBuilder<class_2168> spawnerLiteral = EcoMobsCommand.createMultiplierCommand("spawner", (RequiredArgumentBuilder<class_2168, String>)valueArgument);
        LiteralArgumentBuilder<class_2168> trialspawnerLiteral = EcoMobsCommand.createMultiplierCommand("trialspawner", (RequiredArgumentBuilder<class_2168, String>)valueArgument);
        LiteralArgumentBuilder<class_2168> babyLiteral = EcoMobsCommand.createMultiplierCommand("baby", (RequiredArgumentBuilder<class_2168, String>)valueArgument);
        LiteralArgumentBuilder nonFixedConfigLiteral = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nonfixed").executes(EcoMobsCommand::getNonFixedPayoutStatus)).then(((RequiredArgumentBuilder)nonFixedActionArgument.requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.admin", 2))).then(percentageArgument.executes(EcoMobsCommand::setNonFixedPayoutPercentage)));
        LiteralArgumentBuilder ecoMobsCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ecomobs").requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.use", 0))).executes(context -> EcoMobsCommand.showHelpPage((CommandContext<class_2168>)context, 1))).then(class_2170.method_9247((String)"mob").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)idArgument.requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.info", 0))).executes(EcoMobsCommand::getEntityPayoutConfig)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)payoutActionArgument.requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.admin", 2))).executes(EcoMobsCommand::setEntityPayoutConfigToggle)).then(priceArgument.executes(EcoMobsCommand::setEntityPayoutConfigPrice)))))).then(spawnerLiteral.requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.admin", 2)))).then(trialspawnerLiteral.requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.admin", 2)))).then(babyLiteral.requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.admin", 2)))).then((ArgumentBuilder)nonFixedConfigLiteral)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").executes(EcoMobsCommand::showAllModesStatus)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.admin", 2))).suggests((context, builder) -> {
            Stream<String> payoutModes = Arrays.stream(ModConfig.PayoutMode.values()).map(Enum::name);
            Stream<String> messageModes = Arrays.stream(ModConfig.MessagesMode.values()).map(Enum::name);
            return class_2172.method_9264(Stream.concat(payoutModes, messageModes), (SuggestionsBuilder)builder);
        }).executes(EcoMobsCommand::setGenericMode)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.reload", 4))).executes(EcoMobsCommand::reloadConfig));
        LiteralCommandNode mainEcoMobsCommandNode = dispatcher.register(ecoMobsCommand);
        LiteralArgumentBuilder emAlias = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"em").requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.use", 0))).executes(context -> EcoMobsCommand.showHelpPage((CommandContext<class_2168>)context, 1))).redirect((CommandNode)mainEcoMobsCommandNode);
        dispatcher.register(emAlias);
        LiteralArgumentBuilder ecoMobsPageCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ecomobspage").requires(source -> EcoMobs.checkPermission(source, "ecomobs.command.use", 0))).then(class_2170.method_9244((String)"page_num", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> EcoMobsCommand.showHelpPage((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"page_num"))));
        dispatcher.register(ecoMobsPageCommand);
    }

    private static LiteralArgumentBuilder<class_2168> createMultiplierCommand(String type, RequiredArgumentBuilder<class_2168, String> valueArgument) {
        Command toggleExecutor = context -> EcoMobsCommand.setMultiplierConfigToggle((CommandContext<class_2168>)context, type);
        Command valueExecutor = context -> EcoMobsCommand.setMultiplierConfigValue((CommandContext<class_2168>)context, type);
        Command getExecutor = context -> EcoMobsCommand.getMultiplierConfig((CommandContext<class_2168>)context, type);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)type).executes(context -> {
            if (!EcoMobs.checkPermission((class_2168)context.getSource(), "ecomobs.command.use", 0)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)MessageFormattingManager.getMessages().permission_denied().chat().replace("&", "\u00a7")));
                return 0;
            }
            return EcoMobsCommand.getMultiplierConfig((CommandContext<class_2168>)context, type);
        })).then(class_2170.method_9247((String)"true").executes(toggleExecutor))).then(class_2170.method_9247((String)"false").executes(toggleExecutor))).then(class_2170.method_9247((String)"multiplier").then(valueArgument.executes(valueExecutor)));
    }

    private static String getFullEntityId(CommandContext<class_2168> context) {
        String simpleId = StringArgumentType.getString(context, (String)"entityId").toLowerCase();
        return simpleId.contains(":") ? simpleId : "minecraft:" + simpleId;
    }

    private static class_2561 getEntityDisplayName(String fullEntityId) {
        try {
            class_1299 entityType = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)fullEntityId));
            return entityType.method_5897();
        }
        catch (Exception e) {
            return class_2561.method_43470((String)fullEntityId);
        }
    }

    private static int getEntityPayoutConfig(CommandContext<class_2168> context) throws CommandSyntaxException {
        String fullEntityId = EcoMobsCommand.getFullEntityId(context);
        ModConfig config = ModConfig.getInstance();
        class_2168 source = (class_2168)context.getSource();
        class_2561 mobDisplayName = EcoMobsCommand.getEntityDisplayName(fullEntityId);
        MessageFormattingData.MobPayoutGetMessages messages = MessageFormattingManager.getMessages().mob_payout_get();
        ModConfig.AnimalPayoutConfig animalConfig = config.getAnimalPayout(fullEntityId);
        ModConfig.MobPayoutConfig mobConfig = config.getMobPayout(fullEntityId);
        boolean isAnimal = animalConfig.killPrice() != 0.0 || animalConfig.breedPrice() != 0.0 || animalConfig.tamePrice() != 0.0 || animalConfig.payoutEnabled();
        String headerMessageTemplate = messages.header().chat();
        String[] parts = headerMessageTemplate.split("%mob_id%", 2);
        class_5250 header = class_2561.method_43470((String)parts[0].replace("&", "\u00a7"));
        header.method_10852(mobDisplayName);
        if (parts.length > 1) {
            header.method_10852((class_2561)class_2561.method_43470((String)parts[1].replace("&", "\u00a7")));
        }
        source.method_9226(() -> header, false);
        if (isAnimal) {
            if (animalConfig.killPrice() > 0.0) {
                String killMsg = String.format(messages.kill_entry().chat().replace("&", "\u00a7"), animalConfig.killPrice());
                source.method_9226(() -> class_2561.method_43470((String)killMsg), false);
            }
            if (animalConfig.breedPrice() > 0.0) {
                String breedMsg = String.format(messages.breed_entry().chat().replace("&", "\u00a7"), animalConfig.breedPrice());
                source.method_9226(() -> class_2561.method_43470((String)breedMsg), false);
            }
            if (animalConfig.tamePrice() > 0.0) {
                String tameMsg = String.format(messages.tame_entry().chat().replace("&", "\u00a7"), animalConfig.tamePrice());
                source.method_9226(() -> class_2561.method_43470((String)tameMsg), false);
            }
            String enabledMsg = messages.enabled_status().chat().replace("%enabled%", String.valueOf(animalConfig.payoutEnabled()));
            source.method_9226(() -> class_2561.method_43470((String)enabledMsg.replace("&", "\u00a7")), false);
        } else {
            if (mobConfig.killPrice() > 0.0) {
                String killMsg = String.format(messages.kill_entry().chat().replace("&", "\u00a7"), mobConfig.killPrice());
                source.method_9226(() -> class_2561.method_43470((String)killMsg), false);
            }
            String enabledMsg = messages.enabled_status().chat().replace("%enabled%", String.valueOf(mobConfig.payoutEnabled()));
            source.method_9226(() -> class_2561.method_43470((String)enabledMsg.replace("&", "\u00a7")), false);
        }
        return 1;
    }

    private static int setEntityPayoutConfigPrice(CommandContext<class_2168> context) throws CommandSyntaxException {
        String fullEntityId = EcoMobsCommand.getFullEntityId(context);
        String action = StringArgumentType.getString(context, (String)"action").toLowerCase();
        double price = DoubleArgumentType.getDouble(context, (String)"price");
        ModConfig config = ModConfig.getInstance();
        class_2561 mobDisplayName = EcoMobsCommand.getEntityDisplayName(fullEntityId);
        if (price < 0.0) {
            String error = MessageFormattingManager.getMessages().error_negative_value().chat();
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)error.replace("&", "\u00a7")));
            return 0;
        }
        String actionDisplay = action;
        MessageFormattingData.MessageEntry setEntry = MessageFormattingManager.getMessages().mob_payout_set();
        ModConfig.AnimalPayoutConfig currentAnimalConfig = config.getAnimalPayout(fullEntityId);
        if (currentAnimalConfig.killPrice() != 0.0 || currentAnimalConfig.breedPrice() != 0.0 || currentAnimalConfig.tamePrice() != 0.0 || currentAnimalConfig.payoutEnabled()) {
            ModConfig.AnimalPayoutConfig newConfig = currentAnimalConfig;
            switch (action) {
                case "kill": {
                    newConfig = currentAnimalConfig.withKillPrice(price);
                    break;
                }
                case "breed": {
                    newConfig = currentAnimalConfig.withBreedPrice(price);
                    break;
                }
                case "tame": {
                    newConfig = currentAnimalConfig.withTamePrice(price);
                    break;
                }
                default: {
                    String error = MessageFormattingManager.getMessages().error_invalid_payout_action().chat().replace("%mob_id%", fullEntityId);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)error.replace("&", "\u00a7")));
                    return 0;
                }
            }
            config.setAnimalPayout(fullEntityId, newConfig);
        } else {
            ModConfig.MobPayoutConfig currentMobConfig = config.getMobPayout(fullEntityId);
            switch (action) {
                case "kill": {
                    ModConfig.MobPayoutConfig newConfig = currentMobConfig.withKillPrice(price);
                    config.setMobPayout(fullEntityId, newConfig);
                    break;
                }
                case "breed": 
                case "tame": {
                    String error = MessageFormattingManager.getMessages().error_unsupported_payout_action().chat().replace("%mob_id%", fullEntityId).replace("%action%", action);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)error.replace("&", "\u00a7")));
                    return 0;
                }
                default: {
                    String errorDefault = MessageFormattingManager.getMessages().error_invalid_payout_action().chat().replace("%mob_id%", fullEntityId);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)errorDefault.replace("&", "\u00a7")));
                    return 0;
                }
            }
        }
        String successMessageTemplate = setEntry.chat().replace("%action%", actionDisplay).replace("%mob_id%", "%temp_mob_id%");
        String formattedMessageWithPrice = String.format(successMessageTemplate.replace("&", "\u00a7"), price);
        class_5250 finalFeedback = class_2561.method_43470((String)"");
        String[] parts = formattedMessageWithPrice.split("%temp_mob_id%", 2);
        finalFeedback.method_10852((class_2561)class_2561.method_43470((String)parts[0]));
        finalFeedback.method_10852(mobDisplayName);
        if (parts.length > 1) {
            finalFeedback.method_10852((class_2561)class_2561.method_43470((String)parts[1]));
        }
        ((class_2168)context.getSource()).method_9226(() -> finalFeedback, true);
        return 1;
    }

    private static int setEntityPayoutConfigToggle(CommandContext<class_2168> context) throws CommandSyntaxException {
        String fullEntityId = EcoMobsCommand.getFullEntityId(context);
        String action = StringArgumentType.getString(context, (String)"action").toLowerCase();
        boolean enabled = Boolean.parseBoolean(action);
        ModConfig config = ModConfig.getInstance();
        class_2561 mobDisplayName = EcoMobsCommand.getEntityDisplayName(fullEntityId);
        String actionDisplay = "Enabled";
        MessageFormattingData.MessageEntry setEntry = MessageFormattingManager.getMessages().mob_payout_toggle_set();
        if (action.equals("true") || action.equals("false")) {
            ModConfig.AnimalPayoutConfig currentAnimalConfig = config.getAnimalPayout(fullEntityId);
            if (currentAnimalConfig.killPrice() != 0.0 || currentAnimalConfig.breedPrice() != 0.0 || currentAnimalConfig.tamePrice() != 0.0 || currentAnimalConfig.payoutEnabled()) {
                ModConfig.AnimalPayoutConfig newConfig = currentAnimalConfig.withEnabled(enabled);
                config.setAnimalPayout(fullEntityId, newConfig);
            } else {
                ModConfig.MobPayoutConfig currentMobConfig = config.getMobPayout(fullEntityId);
                ModConfig.MobPayoutConfig newConfig = currentMobConfig.withEnabled(enabled);
                config.setMobPayout(fullEntityId, newConfig);
            }
            String successMessageTemplate = setEntry.chat().replace("%status%", enabled ? "True" : "False").replace("%mob_id%", "%temp_mob_id%");
            String formattedMessage = successMessageTemplate.replace("&", "\u00a7");
            class_5250 finalMessage = class_2561.method_43470((String)"");
            String[] parts = formattedMessage.split("%temp_mob_id%", 2);
            finalMessage.method_10852((class_2561)class_2561.method_43470((String)parts[0]));
            finalMessage.method_10852(mobDisplayName);
            if (parts.length > 1) {
                finalMessage.method_10852((class_2561)class_2561.method_43470((String)parts[1]));
            }
            ((class_2168)context.getSource()).method_9226(() -> finalMessage, true);
            return 1;
        }
        String error = MessageFormattingManager.getMessages().error_invalid_payout_action().chat().replace("%mob_id%", fullEntityId);
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)error.replace("&", "\u00a7")));
        return 0;
    }

    private static int getMultiplierConfig(CommandContext<class_2168> context, String type) {
        double multiplier;
        boolean enabled;
        ModConfig config = ModConfig.getInstance();
        MessageFormattingData.MessageEntry messageEntry = MessageFormattingManager.getMessages().multiplier_status();
        Object typeDisplay = type.substring(0, 1).toUpperCase() + type.substring(1);
        switch (type) {
            case "spawner": {
                enabled = config.isMobSpawnerPayoutEnabled();
                multiplier = config.getMobSpawnerPayoutMultiplier();
                break;
            }
            case "trialspawner": {
                enabled = config.isTrialSpawnerPayoutEnabled();
                multiplier = config.getTrialSpawnerPayoutMultiplier();
                typeDisplay = "Trial Spawner";
                break;
            }
            case "baby": {
                enabled = config.isAnimalBabyPayoutEnabled();
                multiplier = config.getAnimalBabyPayoutMultiplier();
                typeDisplay = "Baby Animal";
                break;
            }
            default: {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cInternal Error: Invalid multiplier type."));
                return 0;
            }
        }
        String messageTemplate = messageEntry.chat().replace("%type%", (CharSequence)typeDisplay).replace("%enabled%", String.valueOf(enabled));
        String formattedMessage = String.format(messageTemplate.replace("&", "\u00a7"), multiplier);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)formattedMessage), false);
        return 1;
    }

    private static int setMultiplierConfigToggle(CommandContext<class_2168> context, String type) throws CommandSyntaxException {
        String action = context.getInput().split(" ")[2].toLowerCase();
        boolean enabled = Boolean.parseBoolean(action);
        ModConfig config = ModConfig.getInstance();
        MessageFormattingData.MessageEntry setEntry = MessageFormattingManager.getMessages().multiplier_set();
        Object typeDisplay = type.substring(0, 1).toUpperCase() + type.substring(1);
        switch (type) {
            case "spawner": {
                config.setMobSpawnerPayoutEnabled(enabled);
                break;
            }
            case "trialspawner": {
                config.setTrialSpawnerPayoutEnabled(enabled);
                typeDisplay = "Trial Spawner";
                break;
            }
            case "baby": {
                config.setAnimalBabyPayoutEnabled(enabled);
            }
        }
        String successMessageTemplate = setEntry.chat().replace("%action%", "Enabled").replace("%type%", (CharSequence)typeDisplay);
        String formattedMessage = String.format(successMessageTemplate.replace("&", "\u00a7"), enabled ? "True" : "False");
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)formattedMessage), true);
        return 1;
    }

    private static int setMultiplierConfigValue(CommandContext<class_2168> context, String type) throws CommandSyntaxException {
        double multiplier;
        String valueString = StringArgumentType.getString(context, (String)"value").trim();
        String normalizedValueString = valueString.replace(',', '.').replace(':', '.');
        try {
            multiplier = Double.parseDouble(normalizedValueString);
        }
        catch (NumberFormatException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cInvalid number format: '\u00a7e" + valueString + "\u00a7c'. Please use a number (e.g., 0.25).")));
            return 0;
        }
        ModConfig config = ModConfig.getInstance();
        MessageFormattingData.MessageEntry setEntry = MessageFormattingManager.getMessages().multiplier_set();
        Object typeDisplay = type.substring(0, 1).toUpperCase() + type.substring(1);
        if (multiplier < 0.0) {
            String error = MessageFormattingManager.getMessages().error_negative_value().chat();
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)error.replace("&", "\u00a7")));
            return 0;
        }
        switch (type) {
            case "spawner": {
                config.setMobSpawnerPayoutMultiplier(multiplier);
                break;
            }
            case "trialspawner": {
                config.setTrialSpawnerPayoutMultiplier(multiplier);
                typeDisplay = "Trial Spawner";
                break;
            }
            case "baby": {
                config.setAnimalBabyPayoutMultiplier(multiplier);
            }
        }
        String successMessageTemplate = setEntry.chat().replace("%action%", "Multiplier").replace("%type%", (CharSequence)typeDisplay);
        String formattedValue = String.format("%.2f", multiplier);
        String formattedMessage = String.format(successMessageTemplate.replace("&", "\u00a7"), formattedValue);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)formattedMessage), true);
        return 1;
    }

    private static int getNonFixedPayoutStatus(CommandContext<class_2168> context) {
        ModConfig config = ModConfig.getInstance();
        class_2168 source = (class_2168)context.getSource();
        MessageFormattingData.NonFixedMessages messages = MessageFormattingManager.getMessages().non_fixed_payout();
        String header = messages.header().chat().replace("%mode%", config.getPayoutMode().name());
        source.method_9226(() -> class_2561.method_43470((String)header.replace("&", "\u00a7")), false);
        String single = String.format(messages.single_digit().chat().replace("&", "\u00a7"), config.getSingleDigitPercentage());
        source.method_9226(() -> class_2561.method_43470((String)single), false);
        String doubleD = String.format(messages.double_digit().chat().replace("&", "\u00a7"), config.getDoubleDigitPercentage());
        source.method_9226(() -> class_2561.method_43470((String)doubleD), false);
        String triple = String.format(messages.triple_digit().chat().replace("&", "\u00a7"), config.getTripleDigitPercentage());
        source.method_9226(() -> class_2561.method_43470((String)triple), false);
        String quadruple = String.format(messages.quadruple_digit().chat().replace("&", "\u00a7"), config.getQuadrupleDigitPercentage());
        source.method_9226(() -> class_2561.method_43470((String)quadruple), false);
        return 1;
    }

    private static int setNonFixedPayoutPercentage(CommandContext<class_2168> context) throws CommandSyntaxException {
        String action = StringArgumentType.getString(context, (String)"action").toLowerCase();
        double percentage = DoubleArgumentType.getDouble(context, (String)"percentage");
        ModConfig config = ModConfig.getInstance();
        class_2168 source = (class_2168)context.getSource();
        if (percentage < 0.0) {
            String error = MessageFormattingManager.getMessages().error_negative_value().chat();
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)error.replace("&", "\u00a7")));
            return 0;
        }
        MessageFormattingData.MessageEntry setEntry = MessageFormattingManager.getMessages().multiplier_set();
        String successMessageTemplate = setEntry.chat().replace("%type%", "Non-Fixed Payout");
        String typeDisplay = "";
        switch (action) {
            case "singledigit": {
                config.setSingleDigitPercentage(percentage);
                typeDisplay = "Single Digit";
                break;
            }
            case "doubledigit": {
                config.setDoubleDigitPercentage(percentage);
                typeDisplay = "Double Digit";
                break;
            }
            case "tripledigit": {
                config.setTripleDigitPercentage(percentage);
                typeDisplay = "Triple Digit";
                break;
            }
            case "quadrupledigit": {
                config.setQuadrupleDigitPercentage(percentage);
                typeDisplay = "Quadruple Digit";
                break;
            }
            default: {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cInvalid digit setting. Use: singledigit, doubledigit, tripledigit, or quadrupledigit."));
                return 0;
            }
        }
        String formattedValue = String.format("%.2f%%", percentage);
        String formattedMessage = String.format(successMessageTemplate.replace("&", "\u00a7").replace("%action%", typeDisplay + " %"), formattedValue);
        source.method_9226(() -> class_2561.method_43470((String)formattedMessage), true);
        return 1;
    }

    private static int showAllModesStatus(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        ModConfig config = ModConfig.getInstance();
        ModConfig.MessagesMode msgMode = config.getMessagesMode();
        String msgTemplate = MessageFormattingManager.getMessages().messages_mode_status().chat();
        String msgStatus = msgTemplate.replace("%mode%", msgMode.name());
        source.method_9226(() -> class_2561.method_43470((String)msgStatus.replace("&", "\u00a7")), false);
        ModConfig.PayoutMode payoutMode = config.getPayoutMode();
        String payoutTemplate = MessageFormattingManager.getMessages().messages_mode_status().chat().replace("messages mode", "payout mode");
        String payoutStatus = payoutTemplate.replace("%mode%", payoutMode.name());
        source.method_9226(() -> class_2561.method_43470((String)payoutStatus.replace("&", "\u00a7")), false);
        return 1;
    }

    private static int setGenericMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        Enum newMode2;
        String modeString = StringArgumentType.getString(context, (String)"mode").toUpperCase();
        class_2168 source = (class_2168)context.getSource();
        MessageFormattingData.MessageEntry setEntry = MessageFormattingManager.getMessages().messages_mode_set();
        MessageFormattingData.MessageEntry errorEntry = MessageFormattingManager.getMessages().error_invalid_message_mode();
        String finalSuccessMessage = null;
        try {
            newMode2 = ModConfig.PayoutMode.valueOf(modeString);
            ModConfig.getInstance().setPayoutMode((ModConfig.PayoutMode)newMode2);
            String successMessageTemplate = setEntry.chat().replace("messages mode", "payout mode");
            finalSuccessMessage = successMessageTemplate.replace("%mode%", newMode2.name());
        }
        catch (IllegalArgumentException newMode2) {
            // empty catch block
        }
        if (finalSuccessMessage == null) {
            try {
                newMode2 = ModConfig.MessagesMode.valueOf(modeString);
                ModConfig.getInstance().setMessagesMode((ModConfig.MessagesMode)newMode2);
                finalSuccessMessage = setEntry.chat().replace("%mode%", newMode2.name());
            }
            catch (IllegalArgumentException newMode3) {
                // empty catch block
            }
        }
        if (finalSuccessMessage != null) {
            String messageToSend = finalSuccessMessage.replace("&", "\u00a7");
            source.method_9226(() -> class_2561.method_43470((String)messageToSend), true);
            return 1;
        }
        String validPayoutModes = Arrays.toString((Object[])ModConfig.PayoutMode.values()).replace("[", "").replace("]", "");
        String validMsgModes = Arrays.toString((Object[])ModConfig.MessagesMode.values()).replace("[", "").replace("]", "");
        String errorMessageUnformatted = errorEntry.chat().replace("%mode%", modeString).replace("%valid_modes%", validPayoutModes + ", " + validMsgModes);
        source.method_9213((class_2561)class_2561.method_43470((String)errorMessageUnformatted.replace("&", "\u00a7")));
        return 0;
    }

    private static int showHelpPage(CommandContext<class_2168> context, int pageNum) {
        class_2168 source = (class_2168)context.getSource();
        try {
            if (ALL_HELP_PAGES.isEmpty()) {
                EcoMobs.LOGGER.warn("ALL_HELP_PAGES was unexpectedly empty when showHelpPage was called. Re-attempting initialization as a safeguard.");
                EcoMobsCommand.initializeHelpPages();
                if (ALL_HELP_PAGES.isEmpty()) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"EcoMobs help pages could not be loaded. Check server console for errors during initialization."));
                    return 0;
                }
            }
            int totalPages = ALL_HELP_PAGES.size();
            int actualPageNum = Math.max(1, Math.min(pageNum, totalPages));
            List<String> rawHelpLines = ALL_HELP_PAGES.get(actualPageNum - 1);
            source.method_9226(() -> class_2561.method_43470((String)" "), false);
            class_3222 player = source.method_44023();
            List<class_2561> formattedLines = MessageFormatter.formatLines(rawHelpLines, player, source.method_9211());
            for (class_2561 line : formattedLines) {
                source.method_9226(() -> line, false);
            }
            source.method_9226(() -> class_2561.method_43470((String)" "), false);
            return 1;
        }
        catch (Throwable e) {
            EcoMobs.LOGGER.error("ERROR executing /ecomobs help command.", e);
            source.method_9213((class_2561)class_2561.method_43470((String)"An internal error occurred displaying help. Check console."));
            return 0;
        }
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        try {
            ModConfig.loadConfig();
            EcoMobsCommand.initializeHelpPages();
            String successMessage = MessageFormattingManager.getMessages().reload_success().chat();
            String messageToSend = successMessage.replace("&", "\u00a7");
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)messageToSend), true);
            return 1;
        }
        catch (Exception e) {
            EcoMobs.LOGGER.error("Failed to execute /ecomobs reload.", (Throwable)e);
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to reload configuration. Check console for details."));
            return 0;
        }
    }
}

