/*
 * Decompiled with CFR 0.152.
 */
package me.andy.ecomobs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import me.andy.ecomobs.EcoMobs;
import me.andy.ecomobs.config.MessageFormattingData;
import me.andy.ecomobs.config.ModConfig;
import me.andy.ecomobs.config.SettingsData;
import net.fabricmc.loader.api.FabricLoader;

public class MessageFormattingManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String SETTINGS_FILE_NAME = "settings.json";
    private static final String MESSAGES_FILE_NAME = "message_formatting.json";
    private static final String MOBS_FILE_NAME = "mobs.json";
    private static final String ANIMALS_FILE_NAME = "animals.json";
    private static final Type MOB_MAP_TYPE = new TypeToken<Map<String, ModConfig.MobPayoutConfig>>(){}.getType();
    private static final Type ANIMAL_MAP_TYPE = new TypeToken<Map<String, ModConfig.AnimalPayoutConfig>>(){}.getType();
    private static File settingsFile;
    private static File messagesFile;
    private static File mobsFile;
    private static File animalsFile;
    private static MessageFormattingData messages;

    public static void initialize() {
        Path modConfigDir = FabricLoader.getInstance().getConfigDir().resolve("ecomobs");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            EcoMobs.LOGGER.error("Failed to create config directory for EcoMobs.", (Throwable)e);
        }
        settingsFile = modConfigDir.resolve(SETTINGS_FILE_NAME).toFile();
        messagesFile = modConfigDir.resolve(MESSAGES_FILE_NAME).toFile();
        mobsFile = modConfigDir.resolve(MOBS_FILE_NAME).toFile();
        animalsFile = modConfigDir.resolve(ANIMALS_FILE_NAME).toFile();
    }

    public static MessageFormattingData getMessages() {
        if (messages == null) {
            MessageFormattingManager.loadMessages();
        }
        return messages;
    }

    public static SettingsData loadSettings() {
        return MessageFormattingManager.loadFile(settingsFile, SettingsData.class, SettingsData.createDefault(), "settings");
    }

    public static void loadMessages() {
        if (messagesFile.exists()) {
            try (FileReader reader = new FileReader(messagesFile);){
                messages = (MessageFormattingData)GSON.fromJson((Reader)reader, MessageFormattingData.class);
                if (messages == null) {
                    messages = MessageFormattingData.createDefault();
                    EcoMobs.LOGGER.warn("Message formatting file was empty or corrupted. Loaded defaults.");
                }
            }
            catch (Exception e) {
                EcoMobs.LOGGER.error("Failed to load message formatting file. Using default values.", (Throwable)e);
                messages = MessageFormattingData.createDefault();
            }
        } else {
            messages = MessageFormattingData.createDefault();
            MessageFormattingManager.saveFile(messagesFile, messages, "message formatting");
        }
    }

    public static void loadPayouts(Map<String, ModConfig.MobPayoutConfig> mobMap, Map<String, ModConfig.MobPayoutConfig> defaultMobMap, Map<String, ModConfig.AnimalPayoutConfig> animalMap, Map<String, ModConfig.AnimalPayoutConfig> defaultAnimalMap) {
        Map<String, ModConfig.MobPayoutConfig> loadedMobs = MessageFormattingManager.loadFile(mobsFile, MOB_MAP_TYPE, defaultMobMap, "mob payouts");
        mobMap.clear();
        mobMap.putAll(loadedMobs);
        if (!mobsFile.exists() && loadedMobs.equals(defaultMobMap)) {
            MessageFormattingManager.saveFile(mobsFile, mobMap, "mob payouts");
        }
        Map<String, ModConfig.AnimalPayoutConfig> loadedAnimals = MessageFormattingManager.loadFile(animalsFile, ANIMAL_MAP_TYPE, defaultAnimalMap, "animal payouts");
        animalMap.clear();
        animalMap.putAll(loadedAnimals);
        if (!animalsFile.exists() && loadedAnimals.equals(defaultAnimalMap)) {
            MessageFormattingManager.saveFile(animalsFile, animalMap, "animal payouts");
        }
    }

    private static <T> T loadFile(File file, Class<T> clazz, T defaultData, String configName) {
        T loadedData = MessageFormattingManager.loadFile(file, clazz, defaultData, configName);
        if (!file.exists() && loadedData.equals(defaultData)) {
            MessageFormattingManager.saveFile(file, loadedData, configName);
        }
        return loadedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T loadFile(File file, Type typeOfT, T defaultData, String configName) {
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Object loadedData = GSON.fromJson((Reader)reader, typeOfT);
                if (loadedData != null) {
                    Object object = loadedData;
                    return (T)object;
                }
                EcoMobs.LOGGER.warn("{} file was empty or corrupted. Loaded defaults.", (Object)configName);
            }
            catch (Exception e) {
                EcoMobs.LOGGER.error("Failed to load {} file. Using default values.", (Object)configName, (Object)e);
            }
        }
        EcoMobs.LOGGER.info("Returning default settings for {}: {}", (Object)configName, (Object)file.getName());
        return defaultData;
    }

    public static <T> void saveFile(File file, T data, String configName) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(data, (Appendable)writer);
            EcoMobs.LOGGER.info("Saved {} file: {}", (Object)configName, (Object)file.getName());
        }
        catch (IOException e) {
            EcoMobs.LOGGER.error("Failed to save {} file.", (Object)configName, (Object)e);
        }
    }

    public static void saveSettings(SettingsData data) {
        MessageFormattingManager.saveFile(settingsFile, data, "settings");
    }

    public static void saveMobs(Map<String, ModConfig.MobPayoutConfig> data) {
        MessageFormattingManager.saveFile(mobsFile, data, "mob payouts");
    }

    public static void saveAnimals(Map<String, ModConfig.AnimalPayoutConfig> data) {
        MessageFormattingManager.saveFile(animalsFile, data, "animal payouts");
    }
}

