/*
 * Decompiled with CFR 0.152.
 */
package me.andy.ecomobs.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.andy.ecomobs.config.MessageFormattingData;
import me.andy.ecomobs.config.MessageFormattingManager;
import me.andy.ecomobs.config.SettingsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EcoMobsConfig");
    private static ModConfig instance;
    private static final double MOB_DEFAULT_PRICE = 3.0;
    private static final boolean MOB_DEFAULT_ENABLED = true;
    private static final Map<String, MobPayoutConfig> DEFAULT_MOB_PAYOUTS;
    private static final double KILL_PRICE = 2.0;
    private static final double BREED_PRICE = 1.0;
    private static final double TAME_PRICE = 2.5;
    private static final boolean ANIMAL_DEFAULT_ENABLED = true;
    private static final Map<String, AnimalPayoutConfig> DEFAULT_ANIMAL_PAYOUTS;
    private SettingsData settings = SettingsData.createDefault();
    private final Map<String, MobPayoutConfig> mobPayouts = new HashMap<String, MobPayoutConfig>();
    private final Map<String, AnimalPayoutConfig> animalPayouts = new HashMap<String, AnimalPayoutConfig>();

    private static AnimalPayoutConfig killOnlyConfig() {
        return new AnimalPayoutConfig(true, 2.0, 0.0, 0.0);
    }

    private static AnimalPayoutConfig killBreedConfig() {
        return new AnimalPayoutConfig(true, 2.0, 1.0, 0.0);
    }

    private static AnimalPayoutConfig fullConfig() {
        return new AnimalPayoutConfig(true, 2.0, 1.0, 2.5);
    }

    private ModConfig() {
    }

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    public static void loadConfig() {
        LOGGER.info("EcoMobs config load initiated.");
        ModConfig.getInstance().settings = MessageFormattingManager.loadSettings();
        MessageFormattingManager.loadPayouts(ModConfig.getInstance().mobPayouts, DEFAULT_MOB_PAYOUTS, ModConfig.getInstance().animalPayouts, DEFAULT_ANIMAL_PAYOUTS);
        MessageFormattingManager.loadMessages();
        LOGGER.info("EcoMobs config loaded successfully.");
    }

    public MobPayoutConfig getMobPayout(String mobId) {
        return this.mobPayouts.getOrDefault(mobId.toLowerCase(), MobPayoutConfig.createDefault());
    }

    public void setMobPayout(String mobId, MobPayoutConfig config) {
        this.mobPayouts.put(mobId.toLowerCase(), Objects.requireNonNull(config));
        LOGGER.info("Mob payout for {} set to: {}", (Object)mobId, (Object)String.format("Kill: %.2f (Enabled: %b)", config.killPrice(), config.payoutEnabled()));
        MessageFormattingManager.saveMobs(this.mobPayouts);
    }

    public AnimalPayoutConfig getAnimalPayout(String animalId) {
        return this.animalPayouts.getOrDefault(animalId.toLowerCase(), AnimalPayoutConfig.createDefault());
    }

    public void setAnimalPayout(String animalId, AnimalPayoutConfig config) {
        this.animalPayouts.put(animalId.toLowerCase(), Objects.requireNonNull(config));
        LOGGER.info("Animal payout for {} set to: {}", (Object)animalId, (Object)String.format("Kill: %.2f, Breed: %.2f, Tame: %.2f (Enabled: %b)", config.killPrice(), config.breedPrice(), config.tamePrice(), config.payoutEnabled()));
        MessageFormattingManager.saveAnimals(this.animalPayouts);
    }

    public MessagesMode getMessagesMode() {
        return this.settings.messagesMode();
    }

    public void setMessagesMode(MessagesMode messagesMode) {
        this.settings = new SettingsData(messagesMode, this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Messages mode set to: {}", (Object)messagesMode);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public boolean isMobSpawnerPayoutEnabled() {
        return this.settings.mobSpawnerSettings().payoutEnabled();
    }

    public double getMobSpawnerPayoutMultiplier() {
        return this.settings.mobSpawnerSettings().multiplier();
    }

    public void setMobSpawnerPayoutEnabled(boolean enabled) {
        SettingsData.MobSpawnerSettings newSettings = new SettingsData.MobSpawnerSettings(enabled, this.settings.mobSpawnerSettings().multiplier());
        this.settings = new SettingsData(this.settings.messagesMode(), newSettings, this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Mob Spawner payout enabled set to: {}", (Object)enabled);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public void setMobSpawnerPayoutMultiplier(double multiplier) {
        SettingsData.MobSpawnerSettings newSettings = new SettingsData.MobSpawnerSettings(this.settings.mobSpawnerSettings().payoutEnabled(), multiplier);
        this.settings = new SettingsData(this.settings.messagesMode(), newSettings, this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Mob Spawner multiplier set to: {}", (Object)multiplier);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public boolean isAnimalBabyPayoutEnabled() {
        return this.settings.animalBabySettings().payoutEnabled();
    }

    public double getAnimalBabyPayoutMultiplier() {
        return this.settings.animalBabySettings().multiplier();
    }

    public void setAnimalBabyPayoutEnabled(boolean enabled) {
        SettingsData.AnimalBabySettings newSettings = new SettingsData.AnimalBabySettings(enabled, this.settings.animalBabySettings().multiplier());
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), newSettings, this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Baby Animal payout enabled set to: {}", (Object)enabled);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public void setAnimalBabyPayoutMultiplier(double multiplier) {
        SettingsData.AnimalBabySettings newSettings = new SettingsData.AnimalBabySettings(this.settings.animalBabySettings().payoutEnabled(), multiplier);
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), newSettings, this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Baby Animal multiplier set to: {}", (Object)multiplier);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public boolean isTrialSpawnerPayoutEnabled() {
        return this.settings.trialSpawnerSettings().payoutEnabled();
    }

    public double getTrialSpawnerPayoutMultiplier() {
        return this.settings.trialSpawnerSettings().multiplier();
    }

    public void setTrialSpawnerPayoutEnabled(boolean enabled) {
        SettingsData.TrialSpawnerSettings newSettings = new SettingsData.TrialSpawnerSettings(enabled, this.settings.trialSpawnerSettings().multiplier());
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), newSettings, this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Trial Spawner payout enabled set to: {}", (Object)enabled);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public void setTrialSpawnerPayoutMultiplier(double multiplier) {
        SettingsData.TrialSpawnerSettings newSettings = new SettingsData.TrialSpawnerSettings(this.settings.trialSpawnerSettings().payoutEnabled(), multiplier);
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), newSettings, this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Trial Spawner multiplier set to: {}", (Object)multiplier);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public PayoutMode getPayoutMode() {
        return this.settings.nonFixedPayoutConfig().mode();
    }

    public void setPayoutMode(PayoutMode mode) {
        SettingsData.NonFixedPayoutConfig current = this.settings.nonFixedPayoutConfig();
        SettingsData.NonFixedPayoutConfig newConfig = new SettingsData.NonFixedPayoutConfig(mode, current.singleDigitPercentage(), current.doubleDigitPercentage(), current.tripleDigitPercentage(), current.quadrupleDigitPercentage());
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), newConfig, this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("Payout mode set to: {}", (Object)mode.name());
        MessageFormattingManager.saveSettings(this.settings);
    }

    public double getSingleDigitPercentage() {
        return this.settings.nonFixedPayoutConfig().singleDigitPercentage();
    }

    public double getDoubleDigitPercentage() {
        return this.settings.nonFixedPayoutConfig().doubleDigitPercentage();
    }

    public double getTripleDigitPercentage() {
        return this.settings.nonFixedPayoutConfig().tripleDigitPercentage();
    }

    public double getQuadrupleDigitPercentage() {
        return this.settings.nonFixedPayoutConfig().quadrupleDigitPercentage();
    }

    public void setSingleDigitPercentage(double percentage) {
        SettingsData.NonFixedPayoutConfig current = this.settings.nonFixedPayoutConfig();
        SettingsData.NonFixedPayoutConfig newConfig = new SettingsData.NonFixedPayoutConfig(current.mode(), percentage, current.doubleDigitPercentage(), current.tripleDigitPercentage(), current.quadrupleDigitPercentage());
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), newConfig, this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("NonFixedPayout SingleDigit set to: {}", (Object)percentage);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public void setDoubleDigitPercentage(double percentage) {
        SettingsData.NonFixedPayoutConfig current = this.settings.nonFixedPayoutConfig();
        SettingsData.NonFixedPayoutConfig newConfig = new SettingsData.NonFixedPayoutConfig(current.mode(), current.singleDigitPercentage(), percentage, current.tripleDigitPercentage(), current.quadrupleDigitPercentage());
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), newConfig, this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("NonFixedPayout DoubleDigit set to: {}", (Object)percentage);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public void setTripleDigitPercentage(double percentage) {
        SettingsData.NonFixedPayoutConfig current = this.settings.nonFixedPayoutConfig();
        SettingsData.NonFixedPayoutConfig newConfig = new SettingsData.NonFixedPayoutConfig(current.mode(), current.singleDigitPercentage(), current.doubleDigitPercentage(), percentage, current.quadrupleDigitPercentage());
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), newConfig, this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("NonFixedPayout TripleDigit set to: {}", (Object)percentage);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public void setQuadrupleDigitPercentage(double percentage) {
        SettingsData.NonFixedPayoutConfig current = this.settings.nonFixedPayoutConfig();
        SettingsData.NonFixedPayoutConfig newConfig = new SettingsData.NonFixedPayoutConfig(current.mode(), current.singleDigitPercentage(), current.doubleDigitPercentage(), current.tripleDigitPercentage(), percentage);
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), newConfig, this.settings.payoutStackingWindowMs(), this.settings.payoutMessageSettings());
        LOGGER.info("NonFixedPayout QuadrupleDigit set to: {}", (Object)percentage);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public int getPayoutStackingWindowMs() {
        return this.settings.payoutStackingWindowMs();
    }

    public void setPayoutStackingWindowMs(int ms) {
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), ms, this.settings.payoutMessageSettings());
        LOGGER.info("Payout stacking window set to: {}ms", (Object)ms);
        MessageFormattingManager.saveSettings(this.settings);
    }

    public MessageFormattingData.PayoutMessageSettings getPayoutMessageSettings() {
        return this.settings.payoutMessageSettings();
    }

    public void setPayoutMessageSettings(MessageFormattingData.PayoutMessageSettings payoutMessageSettings) {
        this.settings = new SettingsData(this.settings.messagesMode(), this.settings.mobSpawnerSettings(), this.settings.animalBabySettings(), this.settings.trialSpawnerSettings(), this.settings.nonFixedPayoutConfig(), this.settings.payoutStackingWindowMs(), payoutMessageSettings);
        LOGGER.info("Payout message settings updated.");
        MessageFormattingManager.saveSettings(this.settings);
    }

    static {
        DEFAULT_MOB_PAYOUTS = Map.ofEntries(Map.entry("minecraft:allay", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:copper_golem", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:snow_golem", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:villager", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:wandering_trader", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:iron_golem", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:giant", new MobPayoutConfig(false, 1.0)), Map.entry("minecraft:cave_spider", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:creeper", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:drowned", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:husk", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:silverfish", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:skeleton", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:slime", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:spider", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:stray", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:zombie", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:zombie_villager", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:bogged", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:blaze", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:ghast", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:happy_ghast", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:magma_cube", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:piglin", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:hoglin", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:zombified_piglin", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:wither_skeleton", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:shulker", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:enderman", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:guardian", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:phantom", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:vex", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:witch", new MobPayoutConfig(true, 10.0)), Map.entry("minecraft:piglin_brute", new MobPayoutConfig(true, 15.0)), Map.entry("minecraft:pillager", new MobPayoutConfig(true, 15.0)), Map.entry("minecraft:vindicator", new MobPayoutConfig(true, 15.0)), Map.entry("minecraft:illusioner", new MobPayoutConfig(true, 15.0)), Map.entry("minecraft:evoker", new MobPayoutConfig(true, 25.0)), Map.entry("minecraft:ravager", new MobPayoutConfig(true, 25.0)), Map.entry("minecraft:breeze", new MobPayoutConfig(true, 20.0)), Map.entry("minecraft:elder_guardian", new MobPayoutConfig(true, 50.0)), Map.entry("minecraft:wither", new MobPayoutConfig(true, 200.0)), Map.entry("minecraft:warden", new MobPayoutConfig(true, 300.0)), Map.entry("minecraft:ender_dragon", new MobPayoutConfig(true, 700.0)), Map.entry("minecraft:polar_bear", new MobPayoutConfig(true, 5.0)), Map.entry("minecraft:wolf", new MobPayoutConfig(true, 3.0)), Map.entry("minecraft:zoglin", new MobPayoutConfig(true, 5.0)));
        DEFAULT_ANIMAL_PAYOUTS = Map.ofEntries(Map.entry("minecraft:camel", ModConfig.fullConfig().withKillPrice(5.0).withTamePrice(10.0)), Map.entry("minecraft:cat", ModConfig.fullConfig()), Map.entry("minecraft:donkey", ModConfig.fullConfig()), Map.entry("minecraft:horse", ModConfig.fullConfig()), Map.entry("minecraft:llama", ModConfig.fullConfig()), Map.entry("minecraft:mule", ModConfig.fullConfig()), Map.entry("minecraft:parrot", ModConfig.fullConfig()), Map.entry("minecraft:skeleton_horse", ModConfig.fullConfig()), Map.entry("minecraft:trader_llama", ModConfig.fullConfig()), Map.entry("minecraft:wolf", ModConfig.fullConfig().withKillPrice(3.0).withTamePrice(5.0)), Map.entry("minecraft:zombie_horse", ModConfig.fullConfig()), Map.entry("minecraft:armadillo", ModConfig.killBreedConfig().withBreedPrice(2.0)), Map.entry("minecraft:axolotl", ModConfig.killBreedConfig().withKillPrice(5.0).withBreedPrice(5.0)), Map.entry("minecraft:bee", ModConfig.killBreedConfig()), Map.entry("minecraft:chicken", ModConfig.killBreedConfig()), Map.entry("minecraft:cow", ModConfig.killBreedConfig()), Map.entry("minecraft:fox", ModConfig.killBreedConfig()), Map.entry("minecraft:frog", ModConfig.killBreedConfig()), Map.entry("minecraft:goat", ModConfig.killBreedConfig().withBreedPrice(2.0)), Map.entry("minecraft:mooshroom", ModConfig.killBreedConfig().withKillPrice(3.0)), Map.entry("minecraft:ocelot", ModConfig.killBreedConfig()), Map.entry("minecraft:panda", ModConfig.killBreedConfig().withKillPrice(5.0).withBreedPrice(10.0)), Map.entry("minecraft:pig", ModConfig.killBreedConfig()), Map.entry("minecraft:rabbit", ModConfig.killBreedConfig()), Map.entry("minecraft:sheep", ModConfig.killBreedConfig()), Map.entry("minecraft:sniffer", ModConfig.killBreedConfig().withKillPrice(10.0).withBreedPrice(20.0)), Map.entry("minecraft:strider", ModConfig.killBreedConfig()), Map.entry("minecraft:turtle", ModConfig.killBreedConfig()), Map.entry("minecraft:zoglin", ModConfig.killBreedConfig()), Map.entry("minecraft:bat", ModConfig.killOnlyConfig()), Map.entry("minecraft:cod", ModConfig.killOnlyConfig()), Map.entry("minecraft:dolphin", ModConfig.killOnlyConfig().withKillPrice(5.0)), Map.entry("minecraft:glow_squid", ModConfig.killOnlyConfig().withKillPrice(3.0)), Map.entry("minecraft:pufferfish", ModConfig.killOnlyConfig()), Map.entry("minecraft:salmon", ModConfig.killOnlyConfig()), Map.entry("minecraft:squid", ModConfig.killOnlyConfig()), Map.entry("minecraft:tadpole", ModConfig.killOnlyConfig()), Map.entry("minecraft:tropical_fish", ModConfig.killOnlyConfig()));
    }

    public record AnimalPayoutConfig(boolean payoutEnabled, double killPrice, double breedPrice, double tamePrice) {
        public static AnimalPayoutConfig createDefault() {
            return new AnimalPayoutConfig(false, 0.0, 0.0, 0.0);
        }

        public AnimalPayoutConfig withEnabled(boolean enabled) {
            return new AnimalPayoutConfig(enabled, this.killPrice, this.breedPrice, this.tamePrice);
        }

        public AnimalPayoutConfig withKillPrice(double price) {
            return new AnimalPayoutConfig(this.payoutEnabled, price, this.breedPrice, this.tamePrice);
        }

        public AnimalPayoutConfig withBreedPrice(double price) {
            return new AnimalPayoutConfig(this.payoutEnabled, this.killPrice, price, this.tamePrice);
        }

        public AnimalPayoutConfig withTamePrice(double price) {
            return new AnimalPayoutConfig(this.payoutEnabled, this.killPrice, this.breedPrice, price);
        }
    }

    public record MobPayoutConfig(boolean payoutEnabled, double killPrice) {
        public static MobPayoutConfig createDefault() {
            return new MobPayoutConfig(false, 0.0);
        }

        public MobPayoutConfig withEnabled(boolean enabled) {
            return new MobPayoutConfig(enabled, this.killPrice);
        }

        public MobPayoutConfig withKillPrice(double price) {
            return new MobPayoutConfig(this.payoutEnabled, price);
        }
    }

    public static enum MessagesMode {
        CHAT,
        ACTIONBAR,
        BOTH;

    }

    public static enum PayoutMode {
        FIXED,
        NONFIXED;

    }
}

