/*
 * Decompiled with CFR 0.152.
 */
package me.andy.ecomobs.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.andy.ecomobs.EcoMobs;
import me.andy.ecomobs.access.LivingEntitySpawnerExtension;
import me.andy.ecomobs.config.MessageFormattingData;
import me.andy.ecomobs.config.MessageFormattingManager;
import me.andy.ecomobs.config.ModConfig;
import me.andy.ecomobs.util.EconomyManager;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9866;

public class MobPayoutListener {
    private static final Map<UUID, Integer> PLAYER_BREED_COUNT = new ConcurrentHashMap<UUID, Integer>();
    private static final Random RANDOM = new Random();
    private static final Map<UUID, ActionbarAccumulator> ACTIONBAR_ACCUMULATOR = new HashMap<UUID, ActionbarAccumulator>();

    public static void register() {
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            class_1657 killer;
            if (livingEntity.method_37908().method_8608()) {
                return;
            }
            class_1657 class_16572 = killer = damageSource.method_5529() instanceof class_1657 ? (class_1657)damageSource.method_5529() : null;
            if (killer instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)killer;
                MobPayoutListener.processKillPayout(serverPlayer, livingEntity);
            }
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            if (livingEntity.method_37908().method_8608()) {
                return;
            }
        });
    }

    public static void onTameSuccess(class_3222 tamer, class_1309 tameable) {
        MobPayoutListener.processTamePayout(tamer, tameable);
    }

    public static void onBabySpawned(class_3222 breeder, class_1429 baby) {
        UUID playerUuid = breeder.method_5667();
        int currentCount = PLAYER_BREED_COUNT.getOrDefault(playerUuid, 0) + 1;
        PLAYER_BREED_COUNT.put(playerUuid, currentCount);
        EcoMobs.LOGGER.debug("Player {} triggered breed count: {}", (Object)breeder.method_5477().getString(), (Object)currentCount);
        if (currentCount % 2 == 0) {
            MobPayoutListener.processBreedPayout(breeder, baby);
            PLAYER_BREED_COUNT.put(playerUuid, 0);
            EcoMobs.LOGGER.debug("Payout executed and counter reset for {}", (Object)breeder.method_5477().getString());
        }
    }

    private static double getNonFixedPayoutAmount(double baseAmount) {
        ModConfig config = ModConfig.getInstance();
        if (config.getPayoutMode() == ModConfig.PayoutMode.FIXED || baseAmount <= 0.0) {
            return baseAmount;
        }
        double percentageToRandomize = baseAmount >= 1000.0 ? config.getQuadrupleDigitPercentage() : (baseAmount >= 100.0 ? config.getTripleDigitPercentage() : (baseAmount >= 10.0 ? config.getDoubleDigitPercentage() : config.getSingleDigitPercentage()));
        double rangeMultiplier = percentageToRandomize / 100.0;
        double maxReduction = baseAmount * rangeMultiplier;
        double randomReduction = RANDOM.nextDouble() * maxReduction;
        double finalPayout = baseAmount - randomReduction;
        EcoMobs.LOGGER.debug("NonFixed Payout applied: Base={}, Range={:.2f}%, Min={:.2f}, Final={:.2f}", new Object[]{baseAmount, percentageToRandomize, baseAmount - maxReduction, finalPayout});
        return Math.max(0.0, finalPayout);
    }

    private static void sendStackedActionbar(class_3222 player, String entityId, double amount, String action) {
        if (amount <= 0.0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long stackingWindowMs = ModConfig.getInstance().getPayoutStackingWindowMs();
        UUID playerUuid = player.method_5667();
        ActionbarAccumulator currentAccumulator = ACTIONBAR_ACCUMULATOR.get(playerUuid);
        double newAccumulatedAmount = amount;
        String newEntityId = entityId;
        if (currentAccumulator != null && action.equals(currentAccumulator.action()) && currentTime - currentAccumulator.lastTriggerTimeMs() <= stackingWindowMs) {
            newAccumulatedAmount += currentAccumulator.accumulatedAmount();
            newEntityId = currentAccumulator.entityId();
        }
        ActionbarAccumulator newAccumulator = new ActionbarAccumulator(newAccumulatedAmount, action, newEntityId, currentTime);
        ACTIONBAR_ACCUMULATOR.put(playerUuid, newAccumulator);
        MobPayoutListener.dispatchMessage(player, newEntityId, newAccumulatedAmount, action, true);
    }

    private static void dispatchMessage(class_3222 player, String entityId, double amount, String action, boolean isActionbar) {
        ModConfig.MessagesMode mode;
        MessageFormattingData.MessageEntry messageEntry;
        if (amount <= 0.0) {
            return;
        }
        MessageFormattingData.PayoutMessageSettings payoutSettings = ModConfig.getInstance().getPayoutMessageSettings();
        switch (action.toLowerCase()) {
            case "killing": {
                messageEntry = MessageFormattingManager.getMessages().payout_success().kill();
                mode = payoutSettings.kill();
                break;
            }
            case "taming": {
                messageEntry = MessageFormattingManager.getMessages().payout_success().tame();
                mode = payoutSettings.tame();
                break;
            }
            case "breeding": {
                messageEntry = MessageFormattingManager.getMessages().payout_success().breed();
                mode = payoutSettings.breed();
                break;
            }
            default: {
                EcoMobs.LOGGER.warn("Attempted to dispatch payout message with unknown action: {}", (Object)action);
                return;
            }
        }
        String entityName = class_2561.method_43471((String)("entity." + entityId.replace(':', '.'))).getString();
        String formattedAmount = EconomyManager.formatCurrency(amount);
        String rawChatMessage = messageEntry.chat().replace("%value%", formattedAmount).replace("%mob_id%", entityName);
        String rawActionbarMessage = messageEntry.actionbar().replace("%value%", formattedAmount).replace("%mob_id%", entityName);
        class_5250 chatMessage = class_2561.method_43470((String)rawChatMessage.replace("&", "\u00a7"));
        class_5250 actionbarMessage = class_2561.method_43470((String)rawActionbarMessage.replace("&", "\u00a7"));
        if (!(isActionbar || mode != ModConfig.MessagesMode.CHAT && mode != ModConfig.MessagesMode.BOTH)) {
            player.method_7353((class_2561)chatMessage, false);
        }
        if (isActionbar && (mode == ModConfig.MessagesMode.ACTIONBAR || mode == ModConfig.MessagesMode.BOTH)) {
            player.method_7353((class_2561)actionbarMessage, true);
        }
    }

    private static void processKillPayout(class_3222 killer, class_1309 victim) {
        class_2960 id = class_7923.field_41177.method_10221((Object)victim.method_5864());
        String entityId = id.toString().toLowerCase();
        ModConfig configInstance = ModConfig.getInstance();
        boolean isAnimalConfigType = victim instanceof class_1429 || victim instanceof class_9866 || victim instanceof class_1422;
        boolean isMobType = victim instanceof class_1308;
        double basePayout = 0.0;
        if (isAnimalConfigType) {
            config = configInstance.getAnimalPayout(entityId);
            if (((ModConfig.AnimalPayoutConfig)config).payoutEnabled()) {
                basePayout = ((ModConfig.AnimalPayoutConfig)config).killPrice();
            }
        } else if (isMobType) {
            config = configInstance.getMobPayout(entityId);
            if (((ModConfig.MobPayoutConfig)config).payoutEnabled()) {
                basePayout = ((ModConfig.MobPayoutConfig)config).killPrice();
            }
        } else {
            return;
        }
        if (basePayout <= 0.0) {
            EcoMobs.LOGGER.debug("Base payout for {} is 0.0 or negative. Skipping payout.", (Object)entityId);
            return;
        }
        double finalPayout = basePayout;
        SpawnerType spawnerType = MobPayoutListener.getSpawnerType(victim);
        EcoMobs.LOGGER.debug("Processing kill payout for {}: base={}, spawnerType={}, isBaby={}", new Object[]{entityId, basePayout, spawnerType, victim.method_6109()});
        if (spawnerType == SpawnerType.TRIAL_SPAWNER) {
            boolean trialPayoutEnabled = configInstance.isTrialSpawnerPayoutEnabled();
            if (!trialPayoutEnabled) {
                EcoMobs.LOGGER.debug("Trial spawner payout disabled. Zeroing {} payout.", (Object)entityId);
                finalPayout = 0.0;
            } else {
                double trialMultiplier = configInstance.getTrialSpawnerPayoutMultiplier();
                EcoMobs.LOGGER.debug("Applied TRIAL-SPAWNER multiplier ({}) to {}. New payout: {}", new Object[]{trialMultiplier, entityId, finalPayout *= trialMultiplier});
            }
        } else if (spawnerType == SpawnerType.REGULAR_SPAWNER) {
            boolean spawnerPayoutEnabled = configInstance.isMobSpawnerPayoutEnabled();
            if (!spawnerPayoutEnabled) {
                EcoMobs.LOGGER.debug("Regular spawner payout disabled. Zeroing {} payout.", (Object)entityId);
                finalPayout = 0.0;
            } else {
                double spawnerMultiplier = configInstance.getMobSpawnerPayoutMultiplier();
                EcoMobs.LOGGER.debug("Applied REGULAR-SPAWNER multiplier ({}) to {}. New payout: {}", new Object[]{spawnerMultiplier, entityId, finalPayout *= spawnerMultiplier});
            }
        } else {
            EcoMobs.LOGGER.debug("{} was a natural spawn. Payout remains: {}", (Object)entityId, (Object)finalPayout);
        }
        if (finalPayout > 0.0 && isAnimalConfigType && victim.method_6109()) {
            if (configInstance.isAnimalBabyPayoutEnabled()) {
                double babyMultiplier = configInstance.getAnimalBabyPayoutMultiplier();
                EcoMobs.LOGGER.debug("Applied baby animal multiplier ({}) to {}. Final payout: {}", new Object[]{babyMultiplier, entityId, finalPayout *= babyMultiplier});
            } else {
                EcoMobs.LOGGER.debug("Baby animal payout disabled. Zeroing {} payout.", (Object)entityId);
                finalPayout = 0.0;
            }
        }
        if (finalPayout > 0.0) {
            if ((finalPayout = MobPayoutListener.getNonFixedPayoutAmount(finalPayout)) > 0.0 && EconomyManager.doSilentPayout((class_1657)killer, finalPayout)) {
                MobPayoutListener.dispatchMessage(killer, entityId, finalPayout, "Killing", false);
                MobPayoutListener.sendStackedActionbar(killer, entityId, finalPayout, "Killing");
            }
        } else {
            EcoMobs.LOGGER.debug("Final payout for {} was 0.0 or negative. No payout executed.", (Object)entityId);
        }
    }

    private static void processTamePayout(class_3222 tamer, class_1309 tameable) {
        class_2960 id = class_7923.field_41177.method_10221((Object)tameable.method_5864());
        String entityId = id.toString().toLowerCase();
        ModConfig.AnimalPayoutConfig config = ModConfig.getInstance().getAnimalPayout(entityId);
        double payoutAmount = 0.0;
        if (config.payoutEnabled()) {
            payoutAmount = config.tamePrice();
        }
        if (payoutAmount <= 0.0) {
            return;
        }
        if ((payoutAmount = MobPayoutListener.getNonFixedPayoutAmount(payoutAmount)) > 0.0 && EconomyManager.doSilentPayout((class_1657)tamer, payoutAmount)) {
            MobPayoutListener.dispatchMessage(tamer, entityId, payoutAmount, "Taming", false);
            MobPayoutListener.sendStackedActionbar(tamer, entityId, payoutAmount, "Taming");
        }
    }

    private static void processBreedPayout(class_3222 breeder, class_1429 baby) {
        class_2960 id = class_7923.field_41177.method_10221((Object)baby.method_5864());
        String entityId = id.toString().toLowerCase();
        ModConfig.AnimalPayoutConfig config = ModConfig.getInstance().getAnimalPayout(entityId);
        double payoutAmount = 0.0;
        if (config.payoutEnabled()) {
            payoutAmount = config.breedPrice();
        }
        if (payoutAmount <= 0.0) {
            return;
        }
        if ((payoutAmount = MobPayoutListener.getNonFixedPayoutAmount(payoutAmount)) > 0.0 && EconomyManager.doSilentPayout((class_1657)breeder, payoutAmount)) {
            MobPayoutListener.dispatchMessage(breeder, entityId, payoutAmount, "Breeding", false);
            MobPayoutListener.sendStackedActionbar(breeder, entityId, payoutAmount, "Breeding");
        }
    }

    private static SpawnerType getSpawnerType(class_1309 entity) {
        if (!(entity instanceof class_1308)) {
            return SpawnerType.NATURAL;
        }
        if (!(entity instanceof LivingEntitySpawnerExtension)) {
            EcoMobs.LOGGER.warn("MobEntity {} does not implement LivingEntitySpawnerExtension. Mixin may have failed!", (Object)entity.method_5864().toString());
            return SpawnerType.NATURAL;
        }
        LivingEntitySpawnerExtension ext = (LivingEntitySpawnerExtension)entity;
        if (ext.ecomobs$isFromTrialSpawner()) {
            return SpawnerType.TRIAL_SPAWNER;
        }
        if (ext.ecomobs$isFromRegularSpawner()) {
            return SpawnerType.REGULAR_SPAWNER;
        }
        return SpawnerType.NATURAL;
    }

    private record ActionbarAccumulator(double accumulatedAmount, String action, String entityId, long lastTriggerTimeMs) {
    }

    private static enum SpawnerType {
        NATURAL,
        REGULAR_SPAWNER,
        TRIAL_SPAWNER;

    }
}

