/*
 * Decompiled with CFR 0.152.
 */
package me.andy.ecomobs.util;

import java.lang.reflect.Method;
import java.util.UUID;
import me.andy.ecomobs.EcoMobs;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;

public class EconomyManager {
    private static final String ECOBAL_MOD_ID = "ecobal";
    private static final String API_CLASS = "me.andy.ecobal.api.EconomyManager";
    private static Boolean isEcobalLoaded = null;
    private static Method silentDepositMethod = null;
    private static Method getCurrencySymbolMethod = null;

    private static boolean checkEcobalLoaded() {
        if (isEcobalLoaded == null) {
            isEcobalLoaded = FabricLoader.getInstance().isModLoaded(ECOBAL_MOD_ID);
            if (isEcobalLoaded.booleanValue()) {
                EcoMobs.LOGGER.info("EcoBal mod detected. Initializing economy integration.");
                try {
                    Class<?> economyManagerClass = Class.forName(API_CLASS);
                    silentDepositMethod = economyManagerClass.getMethod("silentDeposit", UUID.class, Double.TYPE);
                    getCurrencySymbolMethod = economyManagerClass.getMethod("getCurrencySymbol", new Class[0]);
                    EcoMobs.LOGGER.debug("Reflected EcoBal API methods successfully.");
                }
                catch (ClassNotFoundException e) {
                    EcoMobs.LOGGER.error("EcoBal mod is loaded but the API class '{}' was not found. Reflection failed.", (Object)API_CLASS, (Object)e);
                    isEcobalLoaded = false;
                }
                catch (NoSuchMethodException e) {
                    EcoMobs.LOGGER.error("EcoBal API class found, but a required method was not found. Reflection failed. Expected signatures: silentDeposit(UUID, double) and getCurrencySymbol(). Error: {}", (Object)e.getMessage(), (Object)e);
                    isEcobalLoaded = false;
                }
                catch (Exception e) {
                    EcoMobs.LOGGER.error("An unexpected error occurred during EcoBal API reflection setup.", (Throwable)e);
                    isEcobalLoaded = false;
                }
            } else {
                EcoMobs.LOGGER.warn("EcoBal mod not detected. Economy features will be disabled.");
            }
        }
        return isEcobalLoaded;
    }

    public static boolean doSilentPayout(class_1657 player, double amount) {
        if (!EconomyManager.checkEcobalLoaded() || silentDepositMethod == null || amount <= 0.0) {
            return false;
        }
        try {
            silentDepositMethod.invoke(null, player.method_5667(), amount);
            EcoMobs.LOGGER.debug("Silent payout of {} processed for {}", (Object)amount, (Object)player.method_5477().getString());
            return true;
        }
        catch (Exception e) {
            EcoMobs.LOGGER.error("CRITICAL: Failed to invoke silentDeposit method via reflection. Payout failed. Check EcoBal API compatibility.", (Throwable)e);
            isEcobalLoaded = false;
            silentDepositMethod = null;
            return false;
        }
    }

    public static String getCurrencySymbol() {
        if (!EconomyManager.checkEcobalLoaded() || getCurrencySymbolMethod == null) {
            return "";
        }
        try {
            Object result = getCurrencySymbolMethod.invoke(null, new Object[0]);
            return (String)result;
        }
        catch (Exception e) {
            EcoMobs.LOGGER.error("Failed to get currency symbol from EcoBal API.", (Throwable)e);
            return "";
        }
    }

    public static String formatCurrency(double amount) {
        String symbol = EconomyManager.getCurrencySymbol();
        if (symbol.isEmpty()) {
            return String.format("%.2f", amount);
        }
        return String.format("%s%.2f", symbol, amount);
    }
}

